/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.KotlinType;

public class JvmCodegenUtil {
    public static boolean isJvmInterface(@Nullable DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof ClassDescriptor) {
            ClassKind kind = ((ClassDescriptor)descriptor2).getKind();
            return kind == ClassKind.INTERFACE || kind == ClassKind.ANNOTATION_CLASS;
        }
        return false;
    }

    public static boolean isJvmInterface(KotlinType type2) {
        return JvmCodegenUtil.isJvmInterface(type2.getConstructor().getDeclarationDescriptor());
    }

    @NotNull
    public static String getModuleName(ModuleDescriptor module2) {
        Name stableName = module2.getStableName();
        if (stableName == null) {
            return JvmCodegenUtil.prepareModuleName(module2.getName());
        }
        return JvmCodegenUtil.prepareModuleName(stableName);
    }

    @NotNull
    public static String prepareModuleName(@NotNull Name name) {
        if (name == null) {
            JvmCodegenUtil.$$$reportNull$$$0(1);
        }
        String string2 = StringsKt.removeSurrounding(name.asString(), (CharSequence)"<", (CharSequence)">");
        if (string2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(2);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/JvmCodegenUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/JvmCodegenUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareModuleName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDispatchReceiverParameterForConstructorCall";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "prepareModuleName";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMappingFileName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

