/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.serialization;

import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.metadata.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.metadata.serialization.StringTable;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.org.objectweb.asm.commons.Method;

public abstract class JvmSignatureSerializer<F, P> {
    @NotNull
    private final StringTable stringTable;

    public JvmSignatureSerializer(@NotNull StringTable stringTable) {
        Intrinsics.checkNotNullParameter(stringTable, "stringTable");
        this.stringTable = stringTable;
    }

    @Nullable
    public final JvmProtoBuf.JvmMethodSignature methodSignature(@Nullable F descriptor2, @Nullable Name descriptorName, @NotNull Method method) {
        JvmProtoBuf.JvmMethodSignature.Builder builder2;
        block7: {
            block6: {
                block5: {
                    block4: {
                        Intrinsics.checkNotNullParameter(method, "method");
                        builder2 = JvmProtoBuf.JvmMethodSignature.newBuilder();
                        if (descriptor2 == null) break block4;
                        Name name = descriptorName;
                        if (Intrinsics.areEqual(name != null ? name.asString() : null, method.getName())) break block5;
                    }
                    String string2 = method.getName();
                    Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                    builder2.setName(this.stringTable.getStringIndex(string2));
                }
                if (descriptor2 == null) break block6;
                String string3 = method.getDescriptor();
                Intrinsics.checkNotNullExpressionValue(string3, "getDescriptor(...)");
                if (!this.requiresFunctionSignature(descriptor2, string3)) break block7;
            }
            String string4 = method.getDescriptor();
            Intrinsics.checkNotNullExpressionValue(string4, "getDescriptor(...)");
            builder2.setDesc(this.stringTable.getStringIndex(string4));
        }
        return builder2.hasName() || builder2.hasDesc() ? builder2.build() : null;
    }

    protected abstract boolean requiresFunctionSignature(F var1, @NotNull String var2);

    @Nullable
    public final JvmProtoBuf.JvmPropertySignature propertySignature(@NotNull Name descriptorName, @Nullable String fieldName, @Nullable String fieldDesc, @Nullable JvmProtoBuf.JvmMethodSignature syntheticMethod, @Nullable JvmProtoBuf.JvmMethodSignature delegateMethod, @Nullable JvmProtoBuf.JvmMethodSignature getter, @Nullable JvmProtoBuf.JvmMethodSignature setter, boolean requiresFieldSignature) {
        JvmProtoBuf.JvmPropertySignature jvmPropertySignature;
        Intrinsics.checkNotNullParameter(descriptorName, "descriptorName");
        JvmProtoBuf.JvmPropertySignature.Builder signature2 = JvmProtoBuf.JvmPropertySignature.newBuilder();
        if (fieldDesc != null) {
            boolean bl;
            boolean bl2 = bl = fieldName != null;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-JvmSignatureSerializer$propertySignature$22 = false;
                String $i$a$-assert-JvmSignatureSerializer$propertySignature$22 = "Field name shouldn't be null when there's a field type: " + fieldDesc;
                throw new AssertionError((Object)$i$a$-assert-JvmSignatureSerializer$propertySignature$22);
            }
            String string2 = fieldName;
            Intrinsics.checkNotNull(string2);
            signature2.setField(this.fieldSignature(descriptorName, string2, fieldDesc, requiresFieldSignature, this.stringTable));
        }
        if (syntheticMethod != null) {
            signature2.setSyntheticMethod(syntheticMethod);
        }
        if (delegateMethod != null) {
            signature2.setDelegateMethod(delegateMethod);
        }
        if (getter != null) {
            signature2.setGetter(getter);
        }
        if (setter != null) {
            signature2.setSetter(setter);
        }
        JvmProtoBuf.JvmPropertySignature it = jvmPropertySignature = signature2.build();
        boolean bl = false;
        return it.getSerializedSize() > 0 ? jvmPropertySignature : null;
    }

    private final JvmProtoBuf.JvmFieldSignature fieldSignature(Name propertyName, String fieldName, String fieldDesc, boolean requiresFieldSignature, StringTable stringTable) {
        JvmProtoBuf.JvmFieldSignature.Builder builder2 = JvmProtoBuf.JvmFieldSignature.newBuilder();
        if (!Intrinsics.areEqual(propertyName.asString(), fieldName)) {
            builder2.setName(stringTable.getStringIndex(fieldName));
        }
        if (requiresFieldSignature) {
            builder2.setDesc(stringTable.getStringIndex(fieldDesc));
        }
        JvmProtoBuf.JvmFieldSignature jvmFieldSignature = builder2.build();
        Intrinsics.checkNotNullExpressionValue(jvmFieldSignature, "build(...)");
        return jvmFieldSignature;
    }
}

