/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.state;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.state.InfoForMangling;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.InlineClassManglingRulesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public final class InlineClassManglingUtilsKt {
    @Nullable
    public static final String collectFunctionSignatureForManglingSuffix(boolean useOldManglingRules, boolean requiresFunctionNameManglingForParameterTypes, @NotNull List<InfoForMangling> fqNamesForMangling, @Nullable InfoForMangling returnTypeInfo) {
        Intrinsics.checkNotNullParameter(fqNamesForMangling, "fqNamesForMangling");
        if (useOldManglingRules) {
            if (requiresFunctionNameManglingForParameterTypes) {
                return InlineClassManglingUtilsKt.collectFunctionSignatureForManglingSuffix$collectSignatureForMangling(fqNamesForMangling, useOldManglingRules);
            }
            if (returnTypeInfo != null) {
                return ':' + InlineClassManglingUtilsKt.collectFunctionSignatureForManglingSuffix$getSignatureElementForMangling(useOldManglingRules, returnTypeInfo);
            }
        } else if (requiresFunctionNameManglingForParameterTypes || returnTypeInfo != null) {
            String signature2 = InlineClassManglingUtilsKt.collectFunctionSignatureForManglingSuffix$collectSignatureForMangling(fqNamesForMangling, useOldManglingRules) + (returnTypeInfo != null ? ':' + InlineClassManglingUtilsKt.collectFunctionSignatureForManglingSuffix$getSignatureElementForMangling(useOldManglingRules, returnTypeInfo) : "");
            return signature2;
        }
        return null;
    }

    @Nullable
    public static final String getManglingSuffixBasedOnKotlinSignature(@NotNull CallableMemberDescriptor descriptor2, boolean shouldMangleByReturnType, boolean useOldManglingRules) {
        String string2;
        String resultNew;
        InfoForMangling infoForMangling;
        KotlinType it;
        Collection<KotlinType> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (!(descriptor2 instanceof FunctionDescriptor)) {
            return null;
        }
        if (descriptor2 instanceof ConstructorDescriptor) {
            return null;
        }
        if (descriptor2 instanceof JavaMethodDescriptor) {
            return null;
        }
        if (InlineClassDescriptorResolver.isSynthesizedBoxOrUnboxMethod(descriptor2)) {
            return null;
        }
        if (DescriptorUtils.hasJvmNameAnnotation(descriptor2)) {
            return null;
        }
        boolean bl = InlineClassManglingRulesKt.requiresFunctionNameManglingForParameterTypes(descriptor2);
        ReceiverParameterDescriptor receiverParameterDescriptor = ((FunctionDescriptor)descriptor2).getExtensionReceiverParameter();
        Collection collection2 = CollectionsKt.listOfNotNull(receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null);
        List<ValueParameterDescriptor> list = ((FunctionDescriptor)descriptor2).getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
        Iterable iterable = list;
        Collection collection3 = collection2;
        boolean bl2 = bl;
        boolean bl3 = useOldManglingRules;
        boolean $i$f$map = false;
        void var6_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            KotlinType kotlinType = it.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            collection.add(kotlinType);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = CollectionsKt.plus(collection3, (Iterable)collection);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (KotlinType)item$iv$iv;
            collection3 = destination$iv$iv;
            boolean bl5 = false;
            collection3.add(InlineClassManglingUtilsKt.getInfoForMangling(it));
        }
        collection3 = (List)destination$iv$iv;
        if (shouldMangleByReturnType && InlineClassManglingRulesKt.requiresFunctionNameManglingForReturnType(descriptor2)) {
            KotlinType kotlinType = ((FunctionDescriptor)descriptor2).getReturnType();
            Intrinsics.checkNotNull(kotlinType);
            infoForMangling = InlineClassManglingUtilsKt.getInfoForMangling(kotlinType);
        } else {
            infoForMangling = null;
        }
        String string3 = resultNew = InlineClassManglingUtilsKt.collectFunctionSignatureForManglingSuffix(bl3, bl2, (List<InfoForMangling>)collection3, infoForMangling);
        if (string3 != null) {
            String it2 = string3;
            boolean bl6 = false;
            string2 = '-' + InlineClassManglingUtilsKt.md5base64(it2);
        } else {
            string2 = null;
        }
        return string2;
    }

    private static final InfoForMangling getInfoForMangling(KotlinType type2) {
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return null;
        }
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        ClassifierDescriptor classifierDescriptor2 = descriptor2;
        return classifierDescriptor2 instanceof ClassDescriptor ? new InfoForMangling(DescriptorUtilsKt.getFqNameUnsafe(descriptor2), InlineClassesUtilsKt.isValueClass(descriptor2), type2.isMarkedNullable()) : (classifierDescriptor2 instanceof TypeParameterDescriptor ? InlineClassManglingUtilsKt.getInfoForMangling(TypeUtilsKt.getRepresentativeUpperBound((TypeParameterDescriptor)descriptor2)) : null);
    }

    @NotNull
    public static final String md5base64(@NotNull String signatureForMangling) {
        Intrinsics.checkNotNullParameter(signatureForMangling, "signatureForMangling");
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        String string2 = signatureForMangling;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
        byte[] byArray2 = messageDigest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue(byArray2, "digest(...)");
        byte[] byArray3 = byArray2;
        int n = 0;
        int n2 = 5;
        byte[] d = ArraysKt.copyOfRange(byArray3, n, n2);
        String string3 = Base64.getUrlEncoder().withoutPadding().encodeToString(d);
        Intrinsics.checkNotNullExpressionValue(string3, "encodeToString(...)");
        return string3;
    }

    private static final String collectFunctionSignatureForManglingSuffix$getSignatureElementForMangling(boolean $useOldManglingRules, InfoForMangling info) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder $this$collectFunctionSignatureForManglingSuffix_u24getSignatureElementForMangling_u24lambda_u240 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        if (info == null) {
            return "";
        }
        if ($useOldManglingRules || info.isValue()) {
            $this$collectFunctionSignatureForManglingSuffix_u24getSignatureElementForMangling_u24lambda_u240.append('L');
            $this$collectFunctionSignatureForManglingSuffix_u24getSignatureElementForMangling_u24lambda_u240.append(info.getFqName());
            if (info.isNullable()) {
                $this$collectFunctionSignatureForManglingSuffix_u24getSignatureElementForMangling_u24lambda_u240.append('?');
            }
            stringBuilder = $this$collectFunctionSignatureForManglingSuffix_u24getSignatureElementForMangling_u24lambda_u240.append(';');
        } else {
            stringBuilder = $this$collectFunctionSignatureForManglingSuffix_u24getSignatureElementForMangling_u24lambda_u240.append("_");
        }
        return stringBuilder2.toString();
    }

    private static final CharSequence collectFunctionSignatureForManglingSuffix$collectSignatureForMangling$lambda$1(boolean $useOldManglingRules, InfoForMangling it) {
        return InlineClassManglingUtilsKt.collectFunctionSignatureForManglingSuffix$getSignatureElementForMangling($useOldManglingRules, it);
    }

    private static final String collectFunctionSignatureForManglingSuffix$collectSignatureForMangling(List<InfoForMangling> $fqNamesForMangling, boolean $useOldManglingRules) {
        return CollectionsKt.joinToString$default($fqNamesForMangling, $useOldManglingRules ? ", " : "", null, null, 0, null, arg_0 -> InlineClassManglingUtilsKt.collectFunctionSignatureForManglingSuffix$collectSignatureForMangling$lambda$1($useOldManglingRules, arg_0), 30, null);
    }
}

