/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.state;

import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.load.kotlin.TypeMappingMode;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSystemCommonBackendContext;
import org.jetbrains.kotlin.types.UtilsKt;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.ClassicTypeSystemContextKt;
import org.jetbrains.kotlin.types.checker.SimpleClassicTypeSystemContext;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeArgumentMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;

public final class TypeMappingUtil {
    @NotNull
    private static final Set<FqName> METHODS_WITH_DECLARATION_SITE_WILDCARDS;

    public static final boolean isMostPreciseContravariantArgument(@NotNull TypeSystemCommonBackendContext $this$isMostPreciseContravariantArgument, @NotNull KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter($this$isMostPreciseContravariantArgument, "<this>");
        Intrinsics.checkNotNullParameter(type2, "type");
        return $this$isMostPreciseContravariantArgument.isAnyConstructor($this$isMostPreciseContravariantArgument.typeConstructor(type2));
    }

    public static final boolean isMostPreciseCovariantArgument(@NotNull TypeSystemCommonBackendContext $this$isMostPreciseCovariantArgument, @NotNull KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter($this$isMostPreciseCovariantArgument, "<this>");
        Intrinsics.checkNotNullParameter(type2, "type");
        return !TypeMappingUtil.canHaveSubtypesIgnoringNullability($this$isMostPreciseCovariantArgument, type2);
    }

    private static final boolean canHaveSubtypesIgnoringNullability(TypeSystemCommonBackendContext $this$canHaveSubtypesIgnoringNullability, KotlinTypeMarker kotlinType) {
        TypeConstructorMarker constructor = $this$canHaveSubtypesIgnoringNullability.typeConstructor(kotlinType);
        if (!$this$canHaveSubtypesIgnoringNullability.isClassTypeConstructor(constructor) || !$this$canHaveSubtypesIgnoringNullability.isFinalClassOrEnumEntryOrAnnotationClassConstructor(constructor)) {
            return true;
        }
        int n = $this$canHaveSubtypesIgnoringNullability.parametersCount(constructor);
        for (int i = 0; i < n; ++i) {
            KotlinTypeMarker type2;
            TypeParameterMarker parameter = $this$canHaveSubtypesIgnoringNullability.getParameter(constructor, i);
            TypeArgumentMarker argument = $this$canHaveSubtypesIgnoringNullability.getArgument(kotlinType, i);
            if ($this$canHaveSubtypesIgnoringNullability.getType(argument) == null) {
                return true;
            }
            Variance projectionKind = ClassicTypeSystemContextKt.convertVariance($this$canHaveSubtypesIgnoringNullability.getVariance(argument));
            Variance effectiveVariance = UtilsKt.getEffectiveVariance(ClassicTypeSystemContextKt.convertVariance($this$canHaveSubtypesIgnoringNullability.getVariance(parameter)), projectionKind);
            if (effectiveVariance == Variance.OUT_VARIANCE && !TypeMappingUtil.isMostPreciseCovariantArgument($this$canHaveSubtypesIgnoringNullability, type2)) {
                return true;
            }
            if (effectiveVariance != Variance.IN_VARIANCE || TypeMappingUtil.isMostPreciseContravariantArgument($this$canHaveSubtypesIgnoringNullability, type2)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isMethodWithDeclarationSiteWildcards(@Nullable CallableDescriptor $this$isMethodWithDeclarationSiteWildcards) {
        if (!($this$isMethodWithDeclarationSiteWildcards instanceof CallableMemberDescriptor)) {
            return false;
        }
        CallableMemberDescriptor callableMemberDescriptor = ((CallableMemberDescriptor)$this$isMethodWithDeclarationSiteWildcards).getOriginal();
        Intrinsics.checkNotNullExpressionValue(callableMemberDescriptor, "getOriginal(...)");
        return DescriptorUtilsKt.firstOverridden(callableMemberDescriptor, true, TypeMappingUtil::_get_isMethodWithDeclarationSiteWildcards_$lambda$0) != null;
    }

    public static final boolean isMethodWithDeclarationSiteWildcardsFqName(@Nullable FqName $this$isMethodWithDeclarationSiteWildcardsFqName) {
        return CollectionsKt.contains((Iterable)METHODS_WITH_DECLARATION_SITE_WILDCARDS, $this$isMethodWithDeclarationSiteWildcardsFqName);
    }

    private static final FqName child(FqName $this$child, String name) {
        Name name2 = Name.identifier(name);
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        return $this$child.child(name2);
    }

    @Nullable
    public static final TypeMappingMode extractTypeMappingModeFromAnnotation(@Nullable CallableDescriptor callableDescriptor, @NotNull KotlinType outerType, boolean isForAnnotationParameter, boolean mapTypeAliases) {
        Intrinsics.checkNotNullParameter(outerType, "outerType");
        CallableDescriptor callableDescriptor2 = callableDescriptor;
        return TypeMappingUtil.extractTypeMappingModeFromAnnotation(SimpleClassicTypeSystemContext.INSTANCE, callableDescriptor2 != null ? TypeMappingUtil.suppressWildcardsMode(callableDescriptor2) : null, outerType, isForAnnotationParameter, mapTypeAliases);
    }

    @Nullable
    public static final TypeMappingMode extractTypeMappingModeFromAnnotation(@NotNull TypeSystemCommonBackendContext $this$extractTypeMappingModeFromAnnotation, @Nullable Boolean callableSuppressWildcardsMode, @NotNull KotlinTypeMarker outerType, boolean isForAnnotationParameter, boolean mapTypeAliases) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$extractTypeMappingModeFromAnnotation, "<this>");
        Intrinsics.checkNotNullParameter(outerType, "outerType");
        Boolean bl2 = org.jetbrains.kotlin.types.TypeMappingUtil.suppressWildcardsMode(outerType, $this$extractTypeMappingModeFromAnnotation);
        if (bl2 != null) {
            bl = bl2;
        } else {
            Boolean bl3 = callableSuppressWildcardsMode;
            if (bl3 != null) {
                bl = bl3;
            } else {
                return null;
            }
        }
        boolean suppressWildcards2 = bl;
        if ($this$extractTypeMappingModeFromAnnotation.argumentsCount(outerType) == 0) {
            return TypeMappingMode.DEFAULT;
        }
        return TypeMappingMode.Companion.createWithConstantDeclarationSiteWildcardsMode$default(TypeMappingMode.Companion, suppressWildcards2, isForAnnotationParameter, !$this$extractTypeMappingModeFromAnnotation.isInlineClass($this$extractTypeMappingModeFromAnnotation.typeConstructor(outerType)), mapTypeAliases, null, 16, null);
    }

    private static final Boolean suppressWildcardsMode(DeclarationDescriptor $this$suppressWildcardsMode) {
        AnnotationDescriptor annotationDescriptor = SequencesKt.firstOrNull(SequencesKt.mapNotNull(DescriptorUtilsKt.getParentsWithSelf($this$suppressWildcardsMode), TypeMappingUtil::suppressWildcardsMode$lambda$1));
        return annotationDescriptor != null ? TypeMappingUtil.suppressWildcardsMode(annotationDescriptor) : null;
    }

    private static final Boolean suppressWildcardsMode(AnnotationDescriptor $this$suppressWildcardsMode) {
        ConstantValue constantValue = (ConstantValue)CollectionsKt.firstOrNull((Iterable)$this$suppressWildcardsMode.getAllValueArguments().values());
        Object t = constantValue != null ? constantValue.getValue() : null;
        Boolean bl = t instanceof Boolean ? (Boolean)t : null;
        return bl != null ? bl : true;
    }

    private static final boolean _get_isMethodWithDeclarationSiteWildcards_$lambda$0(CallableMemberDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TypeMappingUtil.isMethodWithDeclarationSiteWildcardsFqName(DescriptorUtilsKt.fqNameOrNull(DescriptorUtilsKt.getPropertyIfAccessor(it)));
    }

    private static final AnnotationDescriptor suppressWildcardsMode$lambda$1(DeclarationDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getAnnotations().findAnnotation(JvmStandardClassIds.INSTANCE.getJVM_SUPPRESS_WILDCARDS_ANNOTATION_FQ_NAME());
    }

    static {
        FqName[] fqNameArray = new FqName[]{TypeMappingUtil.child(StandardNames.FqNames.mutableCollection, "addAll"), TypeMappingUtil.child(StandardNames.FqNames.mutableList, "addAll"), TypeMappingUtil.child(StandardNames.FqNames.mutableMap, "putAll")};
        METHODS_WITH_DECLARATION_SITE_WILDCARDS = SetsKt.setOf(fqNameArray);
    }
}

