/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config;

import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageOrApiVersion;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0018\b\u0086\u0001\u0018\u0000 \u001a2\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00000\u0003:\u0001\u001aB\u0019\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\f\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\f\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0014\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u0014\u0010\u0016\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u001a\u0010\u0017\u001a\u00020\t8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u000bj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b("}, d2={"Lorg/jetbrains/kotlin/config/LanguageVersion;", "Lorg/jetbrains/kotlin/utils/DescriptionAware;", "Lorg/jetbrains/kotlin/config/LanguageOrApiVersion;", "", "", "major", "minor", "<init>", "(Ljava/lang/String;III)V", "", "toString", "()Ljava/lang/String;", "I", "getMajor", "()I", "getMinor", "", "isStable", "()Z", "getUsesK2", "usesK2", "isDeprecated", "isUnsupported", "versionString", "Ljava/lang/String;", "getVersionString", "Companion", "KOTLIN_1_0", "KOTLIN_1_1", "KOTLIN_1_2", "KOTLIN_1_3", "KOTLIN_1_4", "KOTLIN_1_5", "KOTLIN_1_6", "KOTLIN_1_7", "KOTLIN_1_8", "KOTLIN_1_9", "KOTLIN_2_0", "KOTLIN_2_1", "KOTLIN_2_2", "KOTLIN_2_3"})
public final class LanguageVersion
extends Enum<LanguageVersion>
implements LanguageOrApiVersion {
    @NotNull
    public static final Companion Companion;
    private final int major;
    private final int minor;
    @NotNull
    private final String versionString;
    @NotNull
    public static final LanguageVersion FIRST_API_SUPPORTED;
    @NotNull
    public static final LanguageVersion FIRST_SUPPORTED;
    @NotNull
    public static final LanguageVersion FIRST_NON_DEPRECATED;
    @NotNull
    public static final LanguageVersion LATEST_STABLE;
    public static final /* enum */ LanguageVersion KOTLIN_1_0;
    public static final /* enum */ LanguageVersion KOTLIN_1_1;
    public static final /* enum */ LanguageVersion KOTLIN_1_2;
    public static final /* enum */ LanguageVersion KOTLIN_1_3;
    public static final /* enum */ LanguageVersion KOTLIN_1_4;
    public static final /* enum */ LanguageVersion KOTLIN_1_5;
    public static final /* enum */ LanguageVersion KOTLIN_1_6;
    public static final /* enum */ LanguageVersion KOTLIN_1_7;
    public static final /* enum */ LanguageVersion KOTLIN_1_8;
    public static final /* enum */ LanguageVersion KOTLIN_1_9;
    public static final /* enum */ LanguageVersion KOTLIN_2_0;
    public static final /* enum */ LanguageVersion KOTLIN_2_1;
    public static final /* enum */ LanguageVersion KOTLIN_2_2;
    public static final /* enum */ LanguageVersion KOTLIN_2_3;
    private static final /* synthetic */ LanguageVersion[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private LanguageVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
        this.versionString = "" + this.major + '.' + this.minor;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    @Override
    public boolean isStable() {
        return this.compareTo((Enum)LATEST_STABLE) <= 0;
    }

    public final boolean getUsesK2() {
        return this.compareTo((Enum)KOTLIN_2_0) >= 0;
    }

    @Override
    public boolean isDeprecated() {
        return FIRST_SUPPORTED.compareTo((Enum)this) <= 0 && this.compareTo((Enum)FIRST_NON_DEPRECATED) < 0;
    }

    @Override
    public boolean isUnsupported() {
        return this.compareTo((Enum)FIRST_SUPPORTED) < 0;
    }

    @Override
    @NotNull
    public String getVersionString() {
        return this.versionString;
    }

    @NotNull
    public String toString() {
        return this.getVersionString();
    }

    public static LanguageVersion[] values() {
        return (LanguageVersion[])$VALUES.clone();
    }

    public static LanguageVersion valueOf(String value2) {
        return Enum.valueOf(LanguageVersion.class, value2);
    }

    @NotNull
    public static EnumEntries<LanguageVersion> getEntries() {
        return $ENTRIES;
    }

    @Nullable
    public static final LanguageVersion fromVersionString(@Nullable String str) {
        return Companion.fromVersionString(str);
    }

    @Nullable
    public static final LanguageVersion fromFullVersionString(@NotNull String str) {
        return Companion.fromFullVersionString(str);
    }

    static {
        KOTLIN_1_0 = new LanguageVersion(1, 0);
        KOTLIN_1_1 = new LanguageVersion(1, 1);
        KOTLIN_1_2 = new LanguageVersion(1, 2);
        KOTLIN_1_3 = new LanguageVersion(1, 3);
        KOTLIN_1_4 = new LanguageVersion(1, 4);
        KOTLIN_1_5 = new LanguageVersion(1, 5);
        KOTLIN_1_6 = new LanguageVersion(1, 6);
        KOTLIN_1_7 = new LanguageVersion(1, 7);
        KOTLIN_1_8 = new LanguageVersion(1, 8);
        KOTLIN_1_9 = new LanguageVersion(1, 9);
        KOTLIN_2_0 = new LanguageVersion(2, 0);
        KOTLIN_2_1 = new LanguageVersion(2, 1);
        KOTLIN_2_2 = new LanguageVersion(2, 2);
        KOTLIN_2_3 = new LanguageVersion(2, 3);
        $VALUES = languageVersionArray = new LanguageVersion[]{LanguageVersion.KOTLIN_1_0, LanguageVersion.KOTLIN_1_1, LanguageVersion.KOTLIN_1_2, LanguageVersion.KOTLIN_1_3, LanguageVersion.KOTLIN_1_4, LanguageVersion.KOTLIN_1_5, LanguageVersion.KOTLIN_1_6, LanguageVersion.KOTLIN_1_7, LanguageVersion.KOTLIN_1_8, LanguageVersion.KOTLIN_1_9, LanguageVersion.KOTLIN_2_0, LanguageVersion.KOTLIN_2_1, LanguageVersion.KOTLIN_2_2, LanguageVersion.KOTLIN_2_3};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        FIRST_API_SUPPORTED = KOTLIN_1_6;
        FIRST_SUPPORTED = KOTLIN_1_6;
        FIRST_NON_DEPRECATED = KOTLIN_1_8;
        LATEST_STABLE = KOTLIN_2_1;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\u000bR\u0014\u0010\r\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000b"}, d2={"Lorg/jetbrains/kotlin/config/LanguageVersion$Companion;", "", "<init>", "()V", "", "str", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "fromVersionString", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/config/LanguageVersion;", "fromFullVersionString", "FIRST_API_SUPPORTED", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "FIRST_SUPPORTED", "FIRST_NON_DEPRECATED", "LATEST_STABLE"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final LanguageVersion fromVersionString(@Nullable String str) {
            Object v0;
            block1: {
                Iterable iterable = LanguageVersion.getEntries();
                for (Object t : iterable) {
                    LanguageVersion it = (LanguageVersion)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getVersionString(), str)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @Nullable
        public final LanguageVersion fromFullVersionString(@NotNull String str) {
            Intrinsics.checkNotNullParameter(str, "str");
            String[] stringArray = new String[]{".", "-"};
            List it = StringsKt.split$default((CharSequence)str, stringArray, false, 0, 6, null);
            boolean bl = false;
            return it.size() >= 2 ? Companion.fromVersionString((String)it.get(0) + '.' + (String)it.get(1)) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

