/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.ClassInfo;
import org.jetbrains.kotlin.container.ClassTraversalCache;
import org.jetbrains.kotlin.container.ConstructorInfo;
import org.jetbrains.kotlin.container.DefaultImplementation;
import org.jetbrains.kotlin.container.SetterInfo;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u001a\u0017\u0010\u0002\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0000H\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u001b\u0010\u0005\u001a\u00020\u00012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0003\u001a!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0002\u00a2\u0006\u0004\b\b\u0010\t\u001a\u001d\u0010\u000b\u001a\u0004\u0018\u00010\n2\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0002\u00a2\u0006\u0004\b\u000b\u0010\f\u001a%\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a!\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00002\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0002\u00a2\u0006\u0004\b\u0017\u0010\t"}, d2={"Ljava/lang/Class;", "Lorg/jetbrains/kotlin/container/ClassInfo;", "getInfo", "(Ljava/lang/Class;)Lorg/jetbrains/kotlin/container/ClassInfo;", "c", "traverseClass", "", "Lorg/jetbrains/kotlin/container/SetterInfo;", "getSetterInfos", "(Ljava/lang/Class;)Ljava/util/List;", "Lorg/jetbrains/kotlin/container/ConstructorInfo;", "getConstructorInfo", "(Ljava/lang/Class;)Lorg/jetbrains/kotlin/container/ConstructorInfo;", "Ljava/lang/reflect/Type;", "type", "", "result", "", "collectInterfacesRecursive", "(Ljava/lang/reflect/Type;Ljava/util/Set;)V", "klass", "getDefaultImplementation", "(Ljava/lang/Class;)Ljava/lang/Class;", "getRegistrations"})
public final class CacheKt {
    @NotNull
    public static final ClassInfo getInfo(@NotNull Class<?> $this$getInfo) {
        Intrinsics.checkNotNullParameter($this$getInfo, "<this>");
        return ClassTraversalCache.INSTANCE.getClassInfo($this$getInfo);
    }

    private static final ClassInfo traverseClass(Class<?> c) {
        return new ClassInfo(CacheKt.getConstructorInfo(c), CacheKt.getSetterInfos(c), CacheKt.getRegistrations(c), CacheKt.getDefaultImplementation(c));
    }

    private static final List<SetterInfo> getSetterInfos(Class<?> c) {
        ArrayList<SetterInfo> setterInfos = new ArrayList<SetterInfo>();
        Iterator<Method> iterator2 = ArrayIteratorKt.iterator(c.getMethods());
        while (iterator2.hasNext()) {
            Method method = iterator2.next();
            Iterator<Annotation> iterator3 = ArrayIteratorKt.iterator(method.getDeclaredAnnotations());
            while (iterator3.hasNext()) {
                Annotation annotation = iterator3.next();
                String string2 = JvmClassMappingKt.getJavaClass(JvmClassMappingKt.getAnnotationClass(annotation)).getName();
                Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
                if (!StringsKt.endsWith$default(string2, ".Inject", false, 2, null)) continue;
                Intrinsics.checkNotNull(method);
                Type[] typeArray = method.getGenericParameterTypes();
                Intrinsics.checkNotNullExpressionValue(typeArray, "getGenericParameterTypes(...)");
                setterInfos.add(new SetterInfo(method, ArraysKt.toList((Object[])typeArray)));
            }
        }
        return setterInfos;
    }

    /*
     * WARNING - void declaration
     */
    private static final ConstructorInfo getConstructorInfo(Class<?> c) {
        List<Object> list;
        void $this$filterTo$iv$iv;
        if (Modifier.isAbstract(c.getModifiers()) || c.isPrimitive()) {
            return null;
        }
        Constructor<?>[] constructorArray = c.getConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, "getConstructors(...)");
        Object[] $this$filter$iv = constructorArray;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            Constructor it = (Constructor)element$iv$iv;
            boolean bl = false;
            if (!(Modifier.isPublic(it.getModifiers()) && !it.isSynthetic())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List publicConstructors = (List)destination$iv$iv;
        if (publicConstructors.size() != 1) {
            return null;
        }
        Constructor constructor = (Constructor)CollectionsKt.single(publicConstructors);
        if (c.getDeclaringClass() != null && !Modifier.isStatic(c.getModifiers())) {
            object = new SpreadBuilder(2);
            ((SpreadBuilder)object).add(c.getDeclaringClass());
            ((SpreadBuilder)object).addSpread(constructor.getGenericParameterTypes());
            list = CollectionsKt.listOf(((SpreadBuilder)object).toArray(new Type[((SpreadBuilder)object).size()]));
        } else {
            Type[] typeArray = constructor.getGenericParameterTypes();
            Intrinsics.checkNotNullExpressionValue(typeArray, "getGenericParameterTypes(...)");
            list = ArraysKt.toList((Object[])typeArray);
        }
        List<Object> parameterTypes = list;
        Intrinsics.checkNotNull(constructor);
        return new ConstructorInfo(constructor, parameterTypes);
    }

    private static final void collectInterfacesRecursive(Type type2, Set<Type> result2) {
        block1: {
            Type[] klass;
            Type type3;
            Type type4 = type2;
            Object object = type4 instanceof Class ? (Type[])type2 : (type4 instanceof ParameterizedType ? ((type3 = ((ParameterizedType)type2).getRawType()) instanceof Class ? (Class)type3 : null) : null);
            Type[] typeArray = klass = object;
            if (klass == null || (typeArray = typeArray.getGenericInterfaces()) == null) break block1;
            Type[] $this$forEach$iv = typeArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Type element$iv;
                Type it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                if (!result2.add(it)) continue;
                CacheKt.collectInterfacesRecursive(it, result2);
            }
        }
    }

    private static final Class<?> getDefaultImplementation(Class<?> klass) {
        DefaultImplementation defaultImplementation = klass.getAnnotation(DefaultImplementation.class);
        return defaultImplementation != null ? defaultImplementation.impl() : null;
    }

    private static final List<Type> getRegistrations(Class<?> klass) {
        ArrayList registrations = new ArrayList();
        Sequence<Type> superClasses = SequencesKt.generateSequence(klass, CacheKt::getRegistrations$lambda$2);
        CollectionsKt.addAll((Collection)registrations, superClasses);
        LinkedHashSet interfaces = new LinkedHashSet();
        Sequence<Type> $this$forEach$iv = superClasses;
        boolean $i$f$forEach = false;
        Iterator<Type> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Type element$iv;
            Type it = element$iv = iterator2.next();
            boolean bl = false;
            CacheKt.collectInterfacesRecursive(it, interfaces);
        }
        registrations.addAll(interfaces);
        registrations.remove(Object.class);
        return registrations;
    }

    private static final Type getRegistrations$lambda$2(Type it) {
        Type type2;
        Intrinsics.checkNotNullParameter(it, "it");
        Type type3 = it;
        if (type3 instanceof Class) {
            type2 = ((Class)it).getGenericSuperclass();
        } else if (type3 instanceof ParameterizedType) {
            Type type4 = ((ParameterizedType)it).getRawType();
            Class clazz = type4 instanceof Class ? (Class)type4 : null;
            type2 = clazz != null ? clazz.getGenericSuperclass() : null;
        } else {
            type2 = null;
        }
        return type2;
    }

    public static final /* synthetic */ ClassInfo access$traverseClass(Class c) {
        return CacheKt.traverseClass(c);
    }
}

