/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import com.intellij.util.containers.MultiMap;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.ClashResolutionDescriptor;
import org.jetbrains.kotlin.container.ComponentContainer;
import org.jetbrains.kotlin.container.ComponentDescriptor;
import org.jetbrains.kotlin.container.PlatformExtensionsClashResolver;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\f\u001a\u00020\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000e\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0000\u00a2\u0006\u0004\b\f\u0010\u0012J'\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00132\u0010\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0015\u00a2\u0006\u0004\b\u0018\u0010\u0019R0\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u001aj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001`\u001b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d"}, d2={"Lorg/jetbrains/kotlin/container/ComponentRegistry;", "", "<init>", "()V", "", "Lorg/jetbrains/kotlin/container/ComponentDescriptor;", "descriptors", "Lcom/intellij/util/containers/MultiMap;", "Ljava/lang/reflect/Type;", "buildRegistrationMap", "(Ljava/util/Collection;)Lcom/intellij/util/containers/MultiMap;", "", "addAll", "(Ljava/util/Collection;)V", "request", "tryGetEntry", "(Ljava/lang/reflect/Type;)Ljava/util/Collection;", "other", "(Lorg/jetbrains/kotlin/container/ComponentRegistry;)V", "Lorg/jetbrains/kotlin/container/ComponentContainer;", "container", "", "Lorg/jetbrains/kotlin/container/PlatformExtensionsClashResolver;", "clashResolvers", "resolveClashesIfAny", "(Lorg/jetbrains/kotlin/container/ComponentContainer;Ljava/util/List;)V", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "registrationMap", "Ljava/util/HashMap;"})
public final class ComponentRegistry {
    @NotNull
    private final HashMap<Type, Object> registrationMap = new HashMap();

    @NotNull
    public final MultiMap<Type, ComponentDescriptor> buildRegistrationMap(@NotNull Collection<? extends ComponentDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, "descriptors");
        MultiMap<Type, ComponentDescriptor> registrationMap = new MultiMap<Type, ComponentDescriptor>();
        for (ComponentDescriptor componentDescriptor : descriptors) {
            for (Type registration : componentDescriptor.getRegistrations()) {
                registrationMap.putValue(registration, componentDescriptor);
            }
        }
        return registrationMap;
    }

    public final void addAll(@NotNull Collection<? extends ComponentDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, "descriptors");
        MultiMap<Type, ComponentDescriptor> newRegistrationMap = this.buildRegistrationMap(descriptors);
        for (Map.Entry<Type, Collection<ComponentDescriptor>> entry : newRegistrationMap.entrySet()) {
            Object object;
            Object object2;
            Object oldEntries = this.registrationMap.get(entry.getKey());
            if (oldEntries != null || entry.getValue().size() > 1) {
                List list = new ArrayList();
                if (oldEntries instanceof Collection) {
                    list.addAll((Collection)oldEntries);
                } else if (oldEntries != null) {
                    list.add((ComponentDescriptor)oldEntries);
                }
                Collection<ComponentDescriptor> collection = entry.getValue();
                Intrinsics.checkNotNullExpressionValue(collection, "<get-value>(...)");
                list.addAll(collection);
                object2 = this.registrationMap;
                object = entry.getKey();
                Object object3 = (ComponentDescriptor)CollectionsKt.singleOrNull(list);
                if (object3 == null) {
                    object3 = list;
                }
                ComponentDescriptor componentDescriptor = object3;
                object2.put(object, componentDescriptor);
                continue;
            }
            Map map2 = this.registrationMap;
            object2 = entry.getKey();
            Collection<ComponentDescriptor> collection = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-value>(...)");
            object = CollectionsKt.single((Iterable)collection);
            map2.put(object2, object);
        }
    }

    @NotNull
    public final Collection<ComponentDescriptor> tryGetEntry(@NotNull Type request) {
        Collection collection;
        Object value2;
        Intrinsics.checkNotNullParameter(request, "request");
        Object object = value2 = this.registrationMap.get(request);
        if (object instanceof Collection) {
            Object object2 = value2;
            Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.collections.Collection<org.jetbrains.kotlin.container.ComponentDescriptor>");
            collection = (Collection)object2;
        } else if (object == null) {
            collection = CollectionsKt.emptyList();
        } else {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type org.jetbrains.kotlin.container.ComponentDescriptor");
            collection = CollectionsKt.listOf((ComponentDescriptor)value2);
        }
        return collection;
    }

    public final void addAll(@NotNull ComponentRegistry other) {
        Intrinsics.checkNotNullParameter(other, "other");
        if (!this.registrationMap.isEmpty()) {
            throw new IllegalStateException("Can only copy entries from another component registry into an empty component registry");
        }
        ((Map)this.registrationMap).putAll((Map)other.registrationMap);
    }

    public final void resolveClashesIfAny(@NotNull ComponentContainer container, @NotNull List<? extends PlatformExtensionsClashResolver<?>> clashResolvers) {
        Intrinsics.checkNotNullParameter(container, "container");
        Intrinsics.checkNotNullParameter(clashResolvers, "clashResolvers");
        for (PlatformExtensionsClashResolver<?> resolver : clashResolvers) {
            Collection clashedComponents;
            Object object = this.registrationMap.get(resolver.getApplicableTo());
            Collection collection = object instanceof Collection ? (Collection)object : null;
            if (collection == null || (clashedComponents = collection).size() <= 1) continue;
            ClashResolutionDescriptor substituteDescriptor = new ClashResolutionDescriptor(container, resolver, CollectionsKt.toList(clashedComponents));
            ((Map)this.registrationMap).put(resolver.getApplicableTo(), substituteDescriptor);
        }
    }
}

