/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import com.intellij.util.containers.MultiMap;
import java.io.Closeable;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.container.CacheKt;
import org.jetbrains.kotlin.container.ClassInfo;
import org.jetbrains.kotlin.container.ComponentDescriptor;
import org.jetbrains.kotlin.container.ComponentRegistry;
import org.jetbrains.kotlin.container.ComponentResolveContext;
import org.jetbrains.kotlin.container.ComponentStorageState;
import org.jetbrains.kotlin.container.ContainerConsistencyException;
import org.jetbrains.kotlin.container.DataStructuresKt;
import org.jetbrains.kotlin.container.DefaultInstanceComponentDescriptor;
import org.jetbrains.kotlin.container.DefaultSingletonTypeComponentDescriptor;
import org.jetbrains.kotlin.container.ImplicitSingletonTypeComponentDescriptor;
import org.jetbrains.kotlin.container.InvalidCardinalityException;
import org.jetbrains.kotlin.container.MethodBinding;
import org.jetbrains.kotlin.container.PlatformExtensionsClashResolver;
import org.jetbrains.kotlin.container.ResolveKt;
import org.jetbrains.kotlin.container.SetterInfo;
import org.jetbrains.kotlin.container.ValueDescriptor;
import org.jetbrains.kotlin.container.ValueResolveContext;
import org.jetbrains.kotlin.container.ValueResolver;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J!\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J%\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J!\u0010\u001d\u001a\u00020\u000e2\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u0018H\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001cJ%\u0010#\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u0018H\u0000\u00a2\u0006\u0004\b!\u0010\"J\u0015\u0010$\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u001e\u00a2\u0006\u0004\b$\u0010%J%\u0010(\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u001e2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001f0&H\u0002\u00a2\u0006\u0004\b(\u0010)J%\u0010+\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u001e2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001f0&H\u0002\u00a2\u0006\u0004\b+\u0010)J+\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001f0,2\u0006\u0010\n\u001a\u00020\u001e2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001f0&H\u0002\u00a2\u0006\u0004\b-\u0010.J;\u00103\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020\u001f2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u0007002\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001f0,H\u0002\u00a2\u0006\u0004\b3\u00104J%\u00107\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\n\u001a\u00020\u001e2\n\u00106\u001a\u0006\u0012\u0002\b\u000305H\u0002\u00a2\u0006\u0004\b7\u00108J\u001f\u0010+\u001a\u00020\u000e2\u0006\u0010:\u001a\u0002092\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b+\u0010;J\r\u0010<\u001a\u00020\u000e\u00a2\u0006\u0004\b<\u0010=J\u0015\u0010>\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0018H\u0002\u00a2\u0006\u0004\b>\u0010?J\u0017\u0010@\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b@\u0010AR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010BR\"\u0010D\u001a\u00020C8\u0007@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\bD\u0010E\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001f0,8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010JR-\u0010M\u001a\u001b\u0012\b\u0012\u0006*\u00020\u001f0\u001f\u0012\b\u0012\u0006*\u00020\u00070\u00070K\u00a2\u0006\u0002\bL8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\bM\u0010NR\u001e\u0010P\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190O8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\bP\u0010QR\u0014\u0010S\u001a\u00020R8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\bS\u0010TR\u0011\u0010W\u001a\u00020\u00028G\u00a2\u0006\u0006\u001a\u0004\bU\u0010V"}, d2={"Lorg/jetbrains/kotlin/container/ComponentStorage;", "Lorg/jetbrains/kotlin/container/ValueResolver;", "", "myId", "parent", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/container/ComponentStorage;)V", "Ljava/lang/reflect/Type;", "request", "Lorg/jetbrains/kotlin/container/ValueResolveContext;", "context", "Lorg/jetbrains/kotlin/container/ValueDescriptor;", "resolve", "(Ljava/lang/reflect/Type;Lorg/jetbrains/kotlin/container/ValueResolveContext;)Lorg/jetbrains/kotlin/container/ValueDescriptor;", "", "registerDependency", "(Ljava/lang/reflect/Type;Lorg/jetbrains/kotlin/container/ValueResolveContext;)V", "Ljava/io/PrintStream;", "printer", "dump", "(Ljava/io/PrintStream;)V", "", "resolveMultiple", "(Ljava/lang/reflect/Type;Lorg/jetbrains/kotlin/container/ValueResolveContext;)Ljava/lang/Iterable;", "", "Lorg/jetbrains/kotlin/container/PlatformExtensionsClashResolver;", "resolvers", "registerClashResolvers$container", "(Ljava/util/List;)V", "registerClashResolvers", "Lorg/jetbrains/kotlin/container/ComponentResolveContext;", "Lorg/jetbrains/kotlin/container/ComponentDescriptor;", "items", "registerDescriptors$container", "(Lorg/jetbrains/kotlin/container/ComponentResolveContext;Ljava/util/List;)V", "registerDescriptors", "compose", "(Lorg/jetbrains/kotlin/container/ComponentResolveContext;)V", "", "descriptors", "composeDescriptors", "(Lorg/jetbrains/kotlin/container/ComponentResolveContext;Ljava/util/Collection;)V", "components", "injectProperties", "Ljava/util/LinkedHashSet;", "inspectDependenciesAndRegisterAdhoc", "(Lorg/jetbrains/kotlin/container/ComponentResolveContext;Ljava/util/Collection;)Ljava/util/LinkedHashSet;", "descriptor", "Ljava/util/HashSet;", "visitedTypes", "adhocDescriptors", "collectAdhocComponents", "(Lorg/jetbrains/kotlin/container/ComponentResolveContext;Lorg/jetbrains/kotlin/container/ComponentDescriptor;Ljava/util/HashSet;Ljava/util/LinkedHashSet;)V", "Ljava/lang/Class;", "rawType", "getImplicitlyDefinedDependency", "(Lorg/jetbrains/kotlin/container/ComponentResolveContext;Ljava/lang/Class;)Lorg/jetbrains/kotlin/container/ComponentDescriptor;", "", "instance", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/container/ValueResolveContext;)V", "dispose", "()V", "getDescriptorsInDisposeOrder", "()Ljava/util/List;", "disposeDescriptor", "(Lorg/jetbrains/kotlin/container/ComponentDescriptor;)V", "Ljava/lang/String;", "Lorg/jetbrains/kotlin/container/ComponentStorageState;", "state", "Lorg/jetbrains/kotlin/container/ComponentStorageState;", "getState", "()Lorg/jetbrains/kotlin/container/ComponentStorageState;", "setState", "(Lorg/jetbrains/kotlin/container/ComponentStorageState;)V", "Ljava/util/LinkedHashSet;", "Lcom/intellij/util/containers/MultiMap;", "Lorg/jetbrains/annotations/NotNull;", "dependencies", "Lcom/intellij/util/containers/MultiMap;", "Ljava/util/ArrayList;", "clashResolvers", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/container/ComponentRegistry;", "registry", "Lorg/jetbrains/kotlin/container/ComponentRegistry;", "getContainerId", "()Ljava/lang/String;", "containerId"})
public final class ComponentStorage
implements ValueResolver {
    @NotNull
    private final String myId;
    @NotNull
    private ComponentStorageState state;
    @NotNull
    private final LinkedHashSet<ComponentDescriptor> descriptors;
    @NotNull
    private final MultiMap<ComponentDescriptor, Type> dependencies;
    @NotNull
    private final ArrayList<PlatformExtensionsClashResolver<?>> clashResolvers;
    @NotNull
    private final ComponentRegistry registry;

    public ComponentStorage(@NotNull String myId, @Nullable ComponentStorage parent2) {
        block0: {
            Intrinsics.checkNotNullParameter(myId, "myId");
            this.myId = myId;
            this.state = ComponentStorageState.Initial;
            this.descriptors = new LinkedHashSet();
            MultiMap multiMap = MultiMap.createLinkedSet();
            Intrinsics.checkNotNullExpressionValue(multiMap, "createLinkedSet(...)");
            this.dependencies = multiMap;
            this.clashResolvers = new ArrayList();
            this.registry = new ComponentRegistry();
            ComponentStorage componentStorage = parent2;
            if (componentStorage == null) break block0;
            ComponentStorage it = componentStorage;
            boolean bl = false;
            this.registry.addAll(it.registry);
            this.clashResolvers.addAll((Collection)it.clashResolvers);
        }
    }

    @NotNull
    public final ComponentStorageState getState() {
        return this.state;
    }

    public final void setState(@NotNull ComponentStorageState componentStorageState) {
        Intrinsics.checkNotNullParameter((Object)componentStorageState, "<set-?>");
        this.state = componentStorageState;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ValueDescriptor resolve(@NotNull Type request, @NotNull ValueResolveContext context) {
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter(context, "context");
        if (this.state == ComponentStorageState.Initial) {
            throw new ContainerConsistencyException("Container was not composed before resolving");
        }
        Collection<ComponentDescriptor> entry = this.registry.tryGetEntry(request);
        if (!entry.isEmpty()) {
            void $this$filterNotTo$iv$iv;
            this.registerDependency(request, context);
            if (entry.size() == 1) {
                return (ValueDescriptor)CollectionsKt.single((Iterable)entry);
            }
            Iterable $this$filterNot$iv = entry;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                ComponentDescriptor it = (ComponentDescriptor)element$iv$iv;
                boolean bl = false;
                if (ComponentStorage.resolve$isDefaultComponent(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List nonDefault = (List)destination$iv$iv;
            if (nonDefault.isEmpty()) {
                return (ValueDescriptor)CollectionsKt.first((Iterable)entry);
            }
            ComponentDescriptor componentDescriptor = (ComponentDescriptor)CollectionsKt.singleOrNull(nonDefault);
            if (componentDescriptor == null) {
                throw new InvalidCardinalityException(this.getContainerId() + ": Request " + request + " cannot be satisfied because there is more than one type registered\nClashed registrations: " + CollectionsKt.joinToString$default(entry, null, null, null, 0, null, null, 63, null));
            }
            return componentDescriptor;
        }
        return null;
    }

    private final void registerDependency(Type request, ValueResolveContext context) {
        ValueDescriptor descriptor2;
        if (context instanceof ComponentResolveContext && (descriptor2 = ((ComponentResolveContext)context).getRequestingDescriptor()) instanceof ComponentDescriptor) {
            this.dependencies.putValue((ComponentDescriptor)descriptor2, request);
        }
    }

    public final void dump(@NotNull PrintStream printer) {
        Intrinsics.checkNotNullParameter(printer, "printer");
        PrintStream $this$dump_u24lambda_u244 = printer;
        boolean bl = false;
        String heading = this.getContainerId();
        $this$dump_u24lambda_u244.println(heading);
        $this$dump_u24lambda_u244.println(StringsKt.repeat("=", heading.length()));
        $this$dump_u24lambda_u244.println();
        Iterable $this$forEach$iv = this.getDescriptorsInDisposeOrder();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ComponentDescriptor descriptor2 = (ComponentDescriptor)element$iv;
            boolean bl2 = false;
            $this$dump_u24lambda_u244.println(descriptor2);
            Collection<Type> collection = this.dependencies.get(descriptor2);
            Intrinsics.checkNotNullExpressionValue(collection, "get(...)");
            Iterable $this$forEach$iv2 = collection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Type it = (Type)element$iv2;
                boolean bl3 = false;
                $this$dump_u24lambda_u244.print("   -> ");
                String typeName = it.toString();
                $this$dump_u24lambda_u244.print(StringsKt.substringBefore$default(typeName, " ", null, 2, null));
                $this$dump_u24lambda_u244.print(" ");
                $this$dump_u24lambda_u244.print(StringsKt.substringAfterLast$default(typeName, ".", null, 2, null));
                Intrinsics.checkNotNull(it);
                Collection<ComponentDescriptor> resolve2 = this.registry.tryGetEntry(it);
                $this$dump_u24lambda_u244.print(" as ");
                $this$dump_u24lambda_u244.print(resolve2);
                $this$dump_u24lambda_u244.println();
            }
            $this$dump_u24lambda_u244.println();
        }
    }

    @NotNull
    public final String getContainerId() {
        return "Container: " + this.myId;
    }

    @NotNull
    public final Iterable<ValueDescriptor> resolveMultiple(@NotNull Type request, @NotNull ValueResolveContext context) {
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter(context, "context");
        this.registerDependency(request, context);
        return this.registry.tryGetEntry(request);
    }

    public final void registerClashResolvers$container(@NotNull List<? extends PlatformExtensionsClashResolver<?>> resolvers) {
        Intrinsics.checkNotNullParameter(resolvers, "resolvers");
        this.clashResolvers.addAll((Collection)resolvers);
    }

    public final void registerDescriptors$container(@NotNull ComponentResolveContext context, @NotNull List<? extends ComponentDescriptor> items) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(items, "items");
        if (this.state == ComponentStorageState.Disposed) {
            throw new ContainerConsistencyException("Cannot register descriptors in " + (Object)((Object)this.state) + " state");
        }
        for (ComponentDescriptor componentDescriptor : items) {
            this.descriptors.add(componentDescriptor);
        }
        if (this.state == ComponentStorageState.Initialized) {
            this.composeDescriptors(context, (Collection<? extends ComponentDescriptor>)items);
        }
    }

    public final void compose(@NotNull ComponentResolveContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        if (this.state != ComponentStorageState.Initial) {
            throw new ContainerConsistencyException(this.getContainerId() + ' ' + this.myId + " was already composed.");
        }
        this.state = ComponentStorageState.Initialized;
        this.composeDescriptors(context, (Collection<? extends ComponentDescriptor>)this.descriptors);
    }

    private final void composeDescriptors(ComponentResolveContext context, Collection<? extends ComponentDescriptor> descriptors) {
        if (descriptors.isEmpty()) {
            return;
        }
        this.registry.addAll(descriptors);
        LinkedHashSet<ComponentDescriptor> implicits = this.inspectDependenciesAndRegisterAdhoc(context, descriptors);
        this.registry.resolveClashesIfAny(context.getContainer(), (List)this.clashResolvers);
        this.injectProperties(context, (Collection<? extends ComponentDescriptor>)CollectionsKt.plus(descriptors, (Iterable)implicits));
    }

    private final void injectProperties(ComponentResolveContext context, Collection<? extends ComponentDescriptor> components) {
        for (ComponentDescriptor componentDescriptor : components) {
            if (!componentDescriptor.getShouldInjectProperties()) continue;
            this.injectProperties(componentDescriptor.getValue(), context.getContainer().createResolveContext(componentDescriptor));
        }
    }

    private final LinkedHashSet<ComponentDescriptor> inspectDependenciesAndRegisterAdhoc(ComponentResolveContext context, Collection<? extends ComponentDescriptor> descriptors) {
        LinkedHashSet<ComponentDescriptor> adhoc = new LinkedHashSet<ComponentDescriptor>();
        HashSet<Type> visitedTypes = new HashSet<Type>();
        for (ComponentDescriptor componentDescriptor : descriptors) {
            this.collectAdhocComponents(context, componentDescriptor, visitedTypes, adhoc);
        }
        this.registry.addAll((Collection<? extends ComponentDescriptor>)adhoc);
        return adhoc;
    }

    private final void collectAdhocComponents(ComponentResolveContext context, ComponentDescriptor descriptor2, HashSet<Type> visitedTypes, LinkedHashSet<ComponentDescriptor> adhocDescriptors) {
        Collection<Type> dependencies = descriptor2.getDependencies(context);
        for (Type type2 : dependencies) {
            Type type3;
            Collection<ComponentDescriptor> entry;
            if (!visitedTypes.add(type2) || !(entry = this.registry.tryGetEntry(type2)).isEmpty()) continue;
            Type type4 = type2;
            Class rawType = type4 instanceof Class ? (Class)type2 : (type4 instanceof ParameterizedType ? ((type3 = ((ParameterizedType)type2).getRawType()) instanceof Class ? (Class)type3 : null) : null);
            Class clazz = rawType;
            if (clazz == null) continue;
            Class it = clazz;
            boolean bl = false;
            ComponentDescriptor componentDescriptor = this.getImplicitlyDefinedDependency(context, it);
            clazz = componentDescriptor;
            if (componentDescriptor == null) {
                continue;
            }
            Class implicitDependency = clazz;
            adhocDescriptors.add((ComponentDescriptor)((Object)implicitDependency));
            this.collectAdhocComponents(context, (ComponentDescriptor)((Object)implicitDependency), visitedTypes, adhocDescriptors);
        }
    }

    private final ComponentDescriptor getImplicitlyDefinedDependency(ComponentResolveContext context, Class<?> rawType) {
        if (!Modifier.isAbstract(rawType.getModifiers()) && !rawType.isPrimitive()) {
            return new ImplicitSingletonTypeComponentDescriptor(context.getContainer(), rawType);
        }
        Class<?> defaultImplementation = CacheKt.getInfo(rawType).getDefaultImplementation();
        if (defaultImplementation != null && CacheKt.getInfo(defaultImplementation).getConstructorInfo() != null) {
            return new DefaultSingletonTypeComponentDescriptor(context.getContainer(), defaultImplementation);
        }
        if (defaultImplementation != null) {
            DefaultInstanceComponentDescriptor defaultInstanceComponentDescriptor;
            Object object = defaultImplementation.getField("INSTANCE");
            if (object != null && (object = ((Field)object).get(null)) != null) {
                Object p0 = object;
                boolean bl = false;
                defaultInstanceComponentDescriptor = new DefaultInstanceComponentDescriptor(p0);
            } else {
                defaultInstanceComponentDescriptor = null;
            }
            return defaultInstanceComponentDescriptor;
        }
        return null;
    }

    private final void injectProperties(Object instance, ValueResolveContext context) {
        ClassInfo classInfo = CacheKt.getInfo(instance.getClass());
        Iterable $this$forEach$iv = classInfo.getSetterInfos();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SetterInfo setterInfo = (SetterInfo)element$iv;
            boolean bl = false;
            Method method = setterInfo.component1();
            MethodBinding methodBinding = ResolveKt.bindToMethod(method, this.getContainerId(), context);
            methodBinding.invoke(instance);
        }
    }

    public final void dispose() {
        if (this.state != ComponentStorageState.Initialized) {
            if (this.state == ComponentStorageState.Initial) {
                return;
            }
            throw new ContainerConsistencyException("Component container cannot be disposed in the " + (Object)((Object)this.state) + " state.");
        }
        this.state = ComponentStorageState.Disposing;
        List<ComponentDescriptor> disposeList = this.getDescriptorsInDisposeOrder();
        for (ComponentDescriptor descriptor2 : disposeList) {
            this.disposeDescriptor(descriptor2);
        }
        this.state = ComponentStorageState.Disposed;
    }

    private final List<ComponentDescriptor> getDescriptorsInDisposeOrder() {
        return DataStructuresKt.topologicalSort$default(this.descriptors, false, arg_0 -> ComponentStorage.getDescriptorsInDisposeOrder$lambda$7(this, arg_0), 2, null);
    }

    private final void disposeDescriptor(ComponentDescriptor descriptor2) {
        if (descriptor2 instanceof Closeable) {
            ((Closeable)((Object)descriptor2)).close();
        }
    }

    private static final boolean resolve$isDefaultComponent(ComponentDescriptor $this$resolve_u24isDefaultComponent) {
        return $this$resolve_u24isDefaultComponent instanceof DefaultInstanceComponentDescriptor || $this$resolve_u24isDefaultComponent instanceof DefaultSingletonTypeComponentDescriptor;
    }

    private static final Iterable getDescriptorsInDisposeOrder$lambda$7(ComponentStorage this$0, ComponentDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        ArrayList<ComponentDescriptor> dependent = new ArrayList<ComponentDescriptor>();
        for (Type interfaceType : this$0.dependencies.get(it)) {
            ComponentRegistry componentRegistry = this$0.registry;
            Intrinsics.checkNotNull(interfaceType);
            for (ComponentDescriptor dependency : componentRegistry.tryGetEntry(interfaceType)) {
                dependent.add(dependency);
            }
        }
        return dependent;
    }
}

