/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.container.ComponentContainer;
import org.jetbrains.kotlin.container.ComponentDescriptor;
import org.jetbrains.kotlin.container.ComponentState;
import org.jetbrains.kotlin.container.ContainerConsistencyException;
import org.jetbrains.kotlin.container.ValueResolveContext;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0002H\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u000eH%\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0006J\u000f\u0010\u0012\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0013R\u001a\u0010\u0004\u001a\u00020\u00038\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\"\u0010\u001b\u001a\u00020\u001a8\u0005@\u0004X\u0085\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R!\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020!8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\u0014\u0010*\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)"}, d2={"Lorg/jetbrains/kotlin/container/SingletonDescriptor;", "Lorg/jetbrains/kotlin/container/ComponentDescriptor;", "Ljava/io/Closeable;", "Lorg/jetbrains/kotlin/container/ComponentContainer;", "container", "<init>", "(Lorg/jetbrains/kotlin/container/ComponentContainer;)V", "", "getValue", "()Ljava/lang/Object;", "ownedObject", "", "registerDisposableObject", "(Ljava/io/Closeable;)V", "Lorg/jetbrains/kotlin/container/ValueResolveContext;", "context", "createInstance", "(Lorg/jetbrains/kotlin/container/ValueResolveContext;)Ljava/lang/Object;", "disposeImpl", "()V", "close", "Lorg/jetbrains/kotlin/container/ComponentContainer;", "getContainer", "()Lorg/jetbrains/kotlin/container/ComponentContainer;", "instance", "Ljava/lang/Object;", "Lorg/jetbrains/kotlin/container/ComponentState;", "state", "Lorg/jetbrains/kotlin/container/ComponentState;", "getState", "()Lorg/jetbrains/kotlin/container/ComponentState;", "setState", "(Lorg/jetbrains/kotlin/container/ComponentState;)V", "Ljava/util/ArrayList;", "disposableObjects$delegate", "Lkotlin/Lazy;", "getDisposableObjects", "()Ljava/util/ArrayList;", "disposableObjects", "", "getShouldInjectProperties", "()Z", "shouldInjectProperties"})
public abstract class SingletonDescriptor
implements Closeable,
ComponentDescriptor {
    @NotNull
    private final ComponentContainer container;
    @Nullable
    private Object instance;
    @NotNull
    private ComponentState state;
    @NotNull
    private final Lazy disposableObjects$delegate;

    public SingletonDescriptor(@NotNull ComponentContainer container) {
        Intrinsics.checkNotNullParameter(container, "container");
        this.container = container;
        this.state = ComponentState.Null;
        this.disposableObjects$delegate = LazyKt.lazy(SingletonDescriptor::disposableObjects_delegate$lambda$0);
    }

    @NotNull
    public final ComponentContainer getContainer() {
        return this.container;
    }

    @NotNull
    protected final ComponentState getState() {
        return this.state;
    }

    protected final void setState(@NotNull ComponentState componentState) {
        Intrinsics.checkNotNullParameter((Object)componentState, "<set-?>");
        this.state = componentState;
    }

    private final ArrayList<Closeable> getDisposableObjects() {
        Lazy lazy = this.disposableObjects$delegate;
        return (ArrayList)lazy.getValue();
    }

    @Override
    @NotNull
    public Object getValue() {
        if (this.state == ComponentState.Corrupted) {
            throw new ContainerConsistencyException("Component descriptor " + this + " is corrupted and cannot be accessed");
        }
        if (this.state == ComponentState.Disposed) {
            throw new ContainerConsistencyException("Component descriptor " + this + " is disposed and cannot be accessed");
        }
        if (this.instance == null) {
            this.createInstance(this.container);
        }
        Object object = this.instance;
        Intrinsics.checkNotNull(object);
        return object;
    }

    protected final void registerDisposableObject(@NotNull Closeable ownedObject) {
        Intrinsics.checkNotNullParameter(ownedObject, "ownedObject");
        this.getDisposableObjects().add(ownedObject);
    }

    @NotNull
    protected abstract Object createInstance(@NotNull ValueResolveContext var1);

    private final void createInstance(ComponentContainer container) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                try {
                    this.instance = this.createInstance(container.createResolveContext(this));
                    return;
                }
                catch (Throwable ex) {
                    this.state = ComponentState.Corrupted;
                    Iterator<Closeable> iterator2 = this.getDisposableObjects().iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
                    Iterator<Closeable> iterator3 = iterator2;
                    while (iterator3.hasNext()) {
                        Closeable disposable;
                        Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                        disposable.close();
                    }
                    throw ex;
                }
            }
            case 2: {
                throw new ContainerConsistencyException("Could not create the component " + this + " because it is being initialized. Do we have undetected circular dependency?");
            }
            case 3: {
                throw new ContainerConsistencyException("Could not get the component " + this + ". Instance is null in Initialized state");
            }
            case 4: {
                throw new ContainerConsistencyException("Could not get the component " + this + " because it is corrupted");
            }
            case 5: {
                throw new ContainerConsistencyException("Could not get the component " + this + " because it is being disposed");
            }
            case 6: {
                throw new ContainerConsistencyException("Could not get the component " + this + " because it is already disposed");
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final void disposeImpl() {
        Object wereInstance = this.instance;
        this.state = ComponentState.Disposing;
        this.instance = null;
        try {
            if (wereInstance instanceof Closeable) {
                ((Closeable)wereInstance).close();
            }
            Iterator<Closeable> iterator2 = this.getDisposableObjects().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            Iterator<Closeable> iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Closeable disposable;
                Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                disposable.close();
            }
        }
        catch (Throwable ex) {
            this.state = ComponentState.Corrupted;
            throw ex;
        }
        this.state = ComponentState.Disposed;
    }

    @Override
    public void close() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 3: {
                this.disposeImpl();
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                throw new ContainerConsistencyException("The component is being initialized and cannot be disposed.");
            }
            case 5: {
                throw new ContainerConsistencyException("The component is already in disposing state.");
            }
            case 6: {
                throw new ContainerConsistencyException("The component has already been destroyed.");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public boolean getShouldInjectProperties() {
        return true;
    }

    private static final ArrayList disposableObjects_delegate$lambda$0() {
        return new ArrayList();
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ComponentState.values().length];
            try {
                nArray[ComponentState.Null.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComponentState.Initializing.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComponentState.Initialized.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComponentState.Corrupted.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComponentState.Disposing.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ComponentState.Disposed.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

