/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.io.Closeable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.CacheKt;
import org.jetbrains.kotlin.container.ClassInfo;
import org.jetbrains.kotlin.container.ComponentContainer;
import org.jetbrains.kotlin.container.ComponentState;
import org.jetbrains.kotlin.container.ConstructorBinding;
import org.jetbrains.kotlin.container.ConstructorInfo;
import org.jetbrains.kotlin.container.ResolveKt;
import org.jetbrains.kotlin.container.SetterInfo;
import org.jetbrains.kotlin.container.SingletonDescriptor;
import org.jetbrains.kotlin.container.ValueDescriptor;
import org.jetbrains.kotlin.container.ValueResolveContext;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0015\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0017\u00a2\u0006\u0004\b\u000f\u0010\u0010J#\u0010\u0011\u001a\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\t\u001a\u00020\bH\u0017\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0017\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b"}, d2={"Lorg/jetbrains/kotlin/container/SingletonTypeComponentDescriptor;", "Lorg/jetbrains/kotlin/container/SingletonDescriptor;", "Lorg/jetbrains/kotlin/container/ComponentContainer;", "container", "Ljava/lang/Class;", "klass", "<init>", "(Lorg/jetbrains/kotlin/container/ComponentContainer;Ljava/lang/Class;)V", "Lorg/jetbrains/kotlin/container/ValueResolveContext;", "context", "", "createInstance", "(Lorg/jetbrains/kotlin/container/ValueResolveContext;)Ljava/lang/Object;", "", "Ljava/lang/reflect/Type;", "getRegistrations", "()Ljava/lang/Iterable;", "createInstanceOf", "(Ljava/lang/Class;Lorg/jetbrains/kotlin/container/ValueResolveContext;)Ljava/lang/Object;", "", "getDependencies", "(Lorg/jetbrains/kotlin/container/ValueResolveContext;)Ljava/util/Collection;", "", "toString", "()Ljava/lang/String;", "Ljava/lang/Class;", "getKlass", "()Ljava/lang/Class;"})
public class SingletonTypeComponentDescriptor
extends SingletonDescriptor {
    @NotNull
    private final Class<?> klass;

    public SingletonTypeComponentDescriptor(@NotNull ComponentContainer container, @NotNull Class<?> klass) {
        Intrinsics.checkNotNullParameter(container, "container");
        Intrinsics.checkNotNullParameter(klass, "klass");
        super(container);
        this.klass = klass;
    }

    @NotNull
    public final Class<?> getKlass() {
        return this.klass;
    }

    @Override
    @NotNull
    protected Object createInstance(@NotNull ValueResolveContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        return this.createInstanceOf(this.klass, context);
    }

    @Override
    @NotNull
    public Iterable<Type> getRegistrations() {
        return CacheKt.getInfo(this.klass).getRegistrations();
    }

    private final Object createInstanceOf(Class<?> klass, ValueResolveContext context) {
        Object obj;
        ConstructorBinding binding = ResolveKt.bindToConstructor(klass, this.getContainer().getContainerId(), context);
        this.setState(ComponentState.Initializing);
        for (ValueDescriptor argumentDescriptor : binding.getArgumentDescriptors()) {
            if (!(argumentDescriptor instanceof Closeable) || argumentDescriptor instanceof SingletonDescriptor) continue;
            this.registerDisposableObject((Closeable)((Object)argumentDescriptor));
        }
        Constructor<?> constructor = binding.getConstructor();
        List<Object> arguments2 = ResolveKt.computeArguments(binding.getArgumentDescriptors());
        boolean $i$f$runWithUnwrappingInvocationException = false;
        try {
            boolean bl = false;
            Collection $this$toTypedArray$iv = arguments2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            Object obj2 = constructor.newInstance(Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNull(obj2);
            obj = obj2;
        }
        catch (InvocationTargetException e$iv) {
            Throwable throwable = e$iv.getTargetException();
            if (throwable == null) {
                throwable = e$iv;
            }
            throw throwable;
        }
        Object instance = obj;
        this.setState(ComponentState.Initialized);
        return instance;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<Type> getDependencies(@NotNull ValueResolveContext context) {
        Collection collection;
        List<SetterInfo> setterInfos;
        List<Type> constructorParameters;
        Intrinsics.checkNotNullParameter(context, "context");
        ClassInfo classInfo = CacheKt.getInfo(this.klass);
        ConstructorInfo constructorInfo = classInfo.getConstructorInfo();
        List<Type> list = constructorInfo != null ? constructorInfo.getParameters() : null;
        if (list == null) {
            list = constructorParameters = CollectionsKt.emptyList();
        }
        if ((setterInfos = classInfo.getSetterInfos()).isEmpty()) {
            collection = constructorParameters;
        } else {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Iterable iterable = setterInfos;
            Collection collection2 = constructorParameters;
            boolean $i$f$flatMap = false;
            void var7_8 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                SetterInfo it = (SetterInfo)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getParameters();
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            collection = CollectionsKt.plus(collection2, (Iterable)((List)destination$iv$iv));
        }
        return collection;
    }

    @NotNull
    public String toString() {
        return "Singleton: " + this.klass.getSimpleName();
    }
}

