/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import java.io.Closeable;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.container.ComponentContainer;
import org.jetbrains.kotlin.container.ComponentDescriptor;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.container.ComponentResolveContext;
import org.jetbrains.kotlin.container.ComponentStorage;
import org.jetbrains.kotlin.container.ConstructorBinding;
import org.jetbrains.kotlin.container.DynamicComponentDescriptor;
import org.jetbrains.kotlin.container.IterableDescriptor;
import org.jetbrains.kotlin.container.PlatformExtensionsClashResolver;
import org.jetbrains.kotlin.container.ResolveKt;
import org.jetbrains.kotlin.container.ValueDescriptor;
import org.jetbrains.kotlin.container.ValueResolveContext;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001b\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J!\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0019\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\u0017H\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001cJ!\u0010\u001d\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001bJ+\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\u001f2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u001e2\b\b\u0002\u0010\u0019\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b \u0010!J\u001d\u0010'\u001a\u00020\u00002\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0001\u00a2\u0006\u0004\b%\u0010&J!\u0010+\u001a\u00020\u00002\u0010\u0010)\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030(0\"H\u0001\u00a2\u0006\u0004\b*\u0010&J#\u0010-\u001a\u00028\u0000\"\u0004\b\u0000\u0010,2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH\u0016\u00a2\u0006\u0004\b-\u0010.J\u000f\u0010/\u001a\u00020\u0004H\u0017\u00a2\u0006\u0004\b/\u00100R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00101R\u001b\u00107\u001a\u0002028GX\u0087\u0084\u0002\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u00106R\u0014\u00109\u001a\u0002088\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0014\u0010<\u001a\u00020\u00048WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u00100"}, d2={"Lorg/jetbrains/kotlin/container/StorageComponentContainer;", "Lorg/jetbrains/kotlin/container/ComponentContainer;", "Lorg/jetbrains/kotlin/container/ComponentProvider;", "Ljava/io/Closeable;", "", "id", "parent", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/container/StorageComponentContainer;)V", "Lorg/jetbrains/kotlin/container/ValueDescriptor;", "requestingDescriptor", "Lorg/jetbrains/kotlin/container/ValueResolveContext;", "createResolveContext", "(Lorg/jetbrains/kotlin/container/ValueDescriptor;)Lorg/jetbrains/kotlin/container/ValueResolveContext;", "compose", "()Lorg/jetbrains/kotlin/container/StorageComponentContainer;", "Ljava/io/PrintStream;", "printer", "", "dump", "(Ljava/io/PrintStream;)V", "close", "()V", "Ljava/lang/reflect/Type;", "request", "context", "resolve", "(Ljava/lang/reflect/Type;Lorg/jetbrains/kotlin/container/ValueResolveContext;)Lorg/jetbrains/kotlin/container/ValueDescriptor;", "(Ljava/lang/reflect/Type;)Lorg/jetbrains/kotlin/container/ValueDescriptor;", "resolveIterable", "Ljava/lang/Class;", "", "resolveMultiple", "(Ljava/lang/Class;Lorg/jetbrains/kotlin/container/ValueResolveContext;)Ljava/lang/Iterable;", "", "Lorg/jetbrains/kotlin/container/ComponentDescriptor;", "descriptors", "registerDescriptors$container", "(Ljava/util/List;)Lorg/jetbrains/kotlin/container/StorageComponentContainer;", "registerDescriptors", "Lorg/jetbrains/kotlin/container/PlatformExtensionsClashResolver;", "resolvers", "registerClashResolvers$container", "registerClashResolvers", "T", "create", "(Ljava/lang/Class;)Ljava/lang/Object;", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "Lorg/jetbrains/kotlin/container/ComponentResolveContext;", "unknownContext$delegate", "Lkotlin/Lazy;", "getUnknownContext", "()Lorg/jetbrains/kotlin/container/ComponentResolveContext;", "unknownContext", "Lorg/jetbrains/kotlin/container/ComponentStorage;", "componentStorage", "Lorg/jetbrains/kotlin/container/ComponentStorage;", "getContainerId", "containerId"})
public final class StorageComponentContainer
implements Closeable,
ComponentContainer,
ComponentProvider {
    @NotNull
    private final String id;
    @NotNull
    private final Lazy unknownContext$delegate;
    @NotNull
    private final ComponentStorage componentStorage;

    public StorageComponentContainer(@NotNull String id, @Nullable StorageComponentContainer parent2) {
        Intrinsics.checkNotNullParameter(id, "id");
        this.id = id;
        this.unknownContext$delegate = LazyKt.lazy(() -> StorageComponentContainer.unknownContext_delegate$lambda$1(parent2, this));
        StorageComponentContainer storageComponentContainer = parent2;
        this.componentStorage = new ComponentStorage(this.id, storageComponentContainer != null ? storageComponentContainer.componentStorage : null);
    }

    public /* synthetic */ StorageComponentContainer(String string2, StorageComponentContainer storageComponentContainer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            storageComponentContainer = null;
        }
        this(string2, storageComponentContainer);
    }

    @NotNull
    public final ComponentResolveContext getUnknownContext() {
        Lazy lazy = this.unknownContext$delegate;
        return (ComponentResolveContext)lazy.getValue();
    }

    @Override
    @NotNull
    public ValueResolveContext createResolveContext(@NotNull ValueDescriptor requestingDescriptor) {
        Intrinsics.checkNotNullParameter(requestingDescriptor, "requestingDescriptor");
        if (Intrinsics.areEqual(requestingDescriptor, DynamicComponentDescriptor.INSTANCE)) {
            return this.getUnknownContext();
        }
        return new ComponentResolveContext(this, requestingDescriptor, null, 4, null);
    }

    @NotNull
    public final StorageComponentContainer compose() {
        this.componentStorage.compose(this.getUnknownContext());
        return this;
    }

    public final void dump(@NotNull PrintStream printer) {
        Intrinsics.checkNotNullParameter(printer, "printer");
        this.componentStorage.dump(printer);
    }

    @Override
    public void close() {
        this.componentStorage.dispose();
    }

    @Nullable
    public final ValueDescriptor resolve(@NotNull Type request, @NotNull ValueResolveContext context) {
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter(context, "context");
        ValueDescriptor valueDescriptor = this.componentStorage.resolve(request, context);
        if (valueDescriptor == null) {
            valueDescriptor = this.resolveIterable(request, context);
        }
        return valueDescriptor;
    }

    @Override
    @Nullable
    public ValueDescriptor resolve(@NotNull Type request) {
        Intrinsics.checkNotNullParameter(request, "request");
        return this.resolve(request, this.getUnknownContext());
    }

    private final ValueDescriptor resolveIterable(Type request, ValueResolveContext context) {
        Type type2;
        if (!(request instanceof ParameterizedType)) {
            return null;
        }
        Type rawType = ((ParameterizedType)request).getRawType();
        if (!Intrinsics.areEqual(rawType, Iterable.class)) {
            return null;
        }
        Type[] typeArguments = ((ParameterizedType)request).getActualTypeArguments();
        if (typeArguments.length != 1) {
            return null;
        }
        Type iterableTypeArgument = typeArguments[0];
        Type type3 = iterableTypeArgument;
        if (type3 instanceof WildcardType) {
            Type[] upperBounds2 = ((WildcardType)iterableTypeArgument).getUpperBounds();
            if (upperBounds2.length != 1) {
                return null;
            }
            type2 = upperBounds2[0];
        } else if (type3 instanceof Class) {
            type2 = iterableTypeArgument;
        } else if (type3 instanceof ParameterizedType) {
            type2 = iterableTypeArgument;
        } else {
            return null;
        }
        Type iterableType = type2;
        Intrinsics.checkNotNull(iterableType);
        return new IterableDescriptor(this.componentStorage.resolveMultiple(iterableType, context));
    }

    @NotNull
    public final Iterable<ValueDescriptor> resolveMultiple(@NotNull Class<?> request, @NotNull ValueResolveContext context) {
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter(context, "context");
        return this.componentStorage.resolveMultiple(request, context);
    }

    public static /* synthetic */ Iterable resolveMultiple$default(StorageComponentContainer storageComponentContainer, Class clazz, ValueResolveContext valueResolveContext, int n, Object object) {
        if ((n & 2) != 0) {
            valueResolveContext = storageComponentContainer.getUnknownContext();
        }
        return storageComponentContainer.resolveMultiple(clazz, valueResolveContext);
    }

    @NotNull
    public final StorageComponentContainer registerDescriptors$container(@NotNull List<? extends ComponentDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, "descriptors");
        this.componentStorage.registerDescriptors$container(this.getUnknownContext(), descriptors);
        return this;
    }

    @NotNull
    public final StorageComponentContainer registerClashResolvers$container(@NotNull List<? extends PlatformExtensionsClashResolver<?>> resolvers) {
        Intrinsics.checkNotNullParameter(resolvers, "resolvers");
        this.componentStorage.registerClashResolvers$container(resolvers);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T create(@NotNull Class<T> request) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(request, "request");
        ConstructorBinding constructorBinding = ResolveKt.bindToConstructor(request, this.getContainerId(), this.getUnknownContext());
        Iterable $this$map$iv = constructorBinding.getArgumentDescriptors();
        boolean $i$f$map = false;
        Iterable<Object> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ValueDescriptor valueDescriptor = (ValueDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Object[] args = thisCollection$iv.toArray(new Object[0]);
        boolean $i$f$runWithUnwrappingInvocationException = false;
        try {
            boolean bl = false;
            iterable = constructorBinding.getConstructor().newInstance(Arrays.copyOf(args, args.length));
        }
        catch (InvocationTargetException e$iv) {
            Throwable throwable = e$iv.getTargetException();
            if (throwable == null) {
                throwable = e$iv;
            }
            throw throwable;
        }
        return (T)iterable;
    }

    @Override
    @NotNull
    public String getContainerId() {
        return "Container: " + this.id;
    }

    @NotNull
    public String toString() {
        return this.getContainerId();
    }

    private static final ComponentResolveContext unknownContext_delegate$lambda$1(StorageComponentContainer $parent, StorageComponentContainer this$0) {
        ComponentResolveContext componentResolveContext;
        StorageComponentContainer storageComponentContainer = $parent;
        if (storageComponentContainer != null) {
            StorageComponentContainer it = storageComponentContainer;
            boolean bl = false;
            componentResolveContext = new ComponentResolveContext(it, DynamicComponentDescriptor.INSTANCE, null, 4, null);
        } else {
            componentResolveContext = null;
        }
        ComponentResolveContext parentContext = componentResolveContext;
        return new ComponentResolveContext(this$0, DynamicComponentDescriptor.INSTANCE, parentContext);
    }
}

