/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.ContextInfoToDataFlowInfoKt;
import org.jetbrains.kotlin.contracts.ESLambda;
import org.jetbrains.kotlin.contracts.EffectSystem$getContextInfoWhen$;
import org.jetbrains.kotlin.contracts.EffectsExtractingVisitor;
import org.jetbrains.kotlin.contracts.model.Computation;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESValue;
import org.jetbrains.kotlin.contracts.model.MutableContextInfo;
import org.jetbrains.kotlin.contracts.model.functors.EqualsFunctor;
import org.jetbrains.kotlin.contracts.model.structure.ESCalls;
import org.jetbrains.kotlin.contracts.model.structure.ESConstants;
import org.jetbrains.kotlin.contracts.model.structure.ESReturns;
import org.jetbrains.kotlin.contracts.model.structure.UNKNOWN_COMPUTATION;
import org.jetbrains.kotlin.contracts.model.visitors.InfoCollector;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ConditionalDataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ+\u0010\u0011\u001a\u00020\u00102\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J3\u0010\u0017\u001a\u00020\u00162\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J)\u0010\u001a\u001a\u00020\u00192\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001a\u0010\u001bJ1\u0010\u001f\u001a\u00020\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u001f\u0010 J/\u0010%\u001a\u00020$2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b%\u0010&J)\u0010)\u001a\u0004\u0018\u00010(2\u0006\u0010#\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b)\u0010*R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010+\u001a\u0004\b,\u0010-R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010.\u001a\u0004\b/\u00100R\u001a\u0010\u0007\u001a\u00020\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u00101\u001a\u0004\b2\u00103"}, d2={"Lorg/jetbrains/kotlin/contracts/EffectSystem;", "", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "builtIns", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "bindingTrace", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "moduleDescriptor", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getDataFlowInfoForFinishedCall", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "leftExpression", "rightExpression", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/ConditionalDataFlowInfo;", "getDataFlowInfoWhenEquals", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Lorg/jetbrains/kotlin/resolve/calls/smartcasts/ConditionalDataFlowInfo;", "", "recordDefiniteInvocations", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)V", "condition", "", "value", "extractDataFlowInfoFromCondition", "(Lorg/jetbrains/kotlin/psi/KtExpression;ZLorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "observedEffect", "expression", "Lorg/jetbrains/kotlin/contracts/model/MutableContextInfo;", "getContextInfoWhen", "(Lorg/jetbrains/kotlin/contracts/model/ESEffect;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Lorg/jetbrains/kotlin/contracts/model/MutableContextInfo;", "trace", "Lorg/jetbrains/kotlin/contracts/model/Computation;", "getNonTrivialComputation", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "getDataFlowValueFactory", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;"})
public final class EffectSystem {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;
    @NotNull
    private final KotlinBuiltIns builtIns;

    public EffectSystem(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(dataFlowValueFactory, "dataFlowValueFactory");
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = dataFlowValueFactory;
        this.builtIns = builtIns;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @NotNull
    public final DataFlowValueFactory getDataFlowValueFactory() {
        return this.dataFlowValueFactory;
    }

    @NotNull
    public final KotlinBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    @NotNull
    public final DataFlowInfo getDataFlowInfoForFinishedCall(@NotNull ResolvedCall<?> resolvedCall2, @NotNull BindingTrace bindingTrace, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(bindingTrace, "bindingTrace");
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        if (!this.languageVersionSettings.supportsFeature(LanguageFeature.UseReturnsEffect)) {
            return DataFlowInfo.Companion.getEMPTY();
        }
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        KtCallExpression ktCallExpression = ktElement instanceof KtCallExpression ? (KtCallExpression)ktElement : null;
        if (ktCallExpression == null) {
            return DataFlowInfo.Companion.getEMPTY();
        }
        KtCallExpression callExpression = ktCallExpression;
        if (callExpression instanceof KtDeclaration) {
            return DataFlowInfo.Companion.getEMPTY();
        }
        MutableContextInfo resultContextInfo = this.getContextInfoWhen(new ESReturns(ESConstants.INSTANCE.getWildcard()), callExpression, bindingTrace, moduleDescriptor);
        return ContextInfoToDataFlowInfoKt.toDataFlowInfo(resultContextInfo, this.languageVersionSettings, this.builtIns);
    }

    @NotNull
    public final ConditionalDataFlowInfo getDataFlowInfoWhenEquals(@Nullable KtExpression leftExpression, @Nullable KtExpression rightExpression, @NotNull BindingTrace bindingTrace, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter(bindingTrace, "bindingTrace");
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        if (!this.languageVersionSettings.supportsFeature(LanguageFeature.UseReturnsEffect)) {
            return ConditionalDataFlowInfo.Companion.getEMPTY();
        }
        if (leftExpression == null || rightExpression == null) {
            return ConditionalDataFlowInfo.Companion.getEMPTY();
        }
        Computation computation = this.getNonTrivialComputation(leftExpression, bindingTrace, moduleDescriptor);
        if (computation == null) {
            return ConditionalDataFlowInfo.Companion.getEMPTY();
        }
        Computation leftComputation = computation;
        Computation computation2 = this.getNonTrivialComputation(rightExpression, bindingTrace, moduleDescriptor);
        if (computation2 == null) {
            return ConditionalDataFlowInfo.Companion.getEMPTY();
        }
        Computation rightComputation = computation2;
        List<ESEffect> effects = new EqualsFunctor(false).invokeWithArguments(leftComputation, rightComputation);
        MutableContextInfo equalsContextInfo = new InfoCollector(new ESReturns(ESConstants.INSTANCE.getTrueValue()), this.builtIns).collectFromSchema(effects);
        MutableContextInfo notEqualsContextInfo = new InfoCollector(new ESReturns(ESConstants.INSTANCE.getFalseValue()), this.builtIns).collectFromSchema(effects);
        return new ConditionalDataFlowInfo(ContextInfoToDataFlowInfoKt.toDataFlowInfo(equalsContextInfo, this.languageVersionSettings, this.builtIns), ContextInfoToDataFlowInfoKt.toDataFlowInfo(notEqualsContextInfo, this.languageVersionSettings, this.builtIns));
    }

    public final void recordDefiniteInvocations(@NotNull ResolvedCall<?> resolvedCall2, @NotNull BindingTrace bindingTrace, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(bindingTrace, "bindingTrace");
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        if (!this.languageVersionSettings.supportsFeature(LanguageFeature.UseCallsInPlaceEffect)) {
            return;
        }
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        KtCallExpression ktCallExpression = ktElement instanceof KtCallExpression ? (KtCallExpression)ktElement : null;
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression callExpression = ktCallExpression;
        if (callExpression instanceof KtDeclaration) {
            return;
        }
        MutableContextInfo resultingContextInfo = this.getContextInfoWhen(new ESReturns(ESConstants.INSTANCE.getWildcard()), callExpression, bindingTrace, moduleDescriptor);
        for (ESEffect effect : resultingContextInfo.getFiredEffects()) {
            ESCalls callsEffect;
            ESValue eSValue;
            Object object;
            ESCalls eSCalls = effect instanceof ESCalls ? (ESCalls)effect : null;
            if (eSCalls == null || (object = (eSValue = (callsEffect = eSCalls).getCallable()) instanceof ESLambda ? (ESLambda)eSValue : null) == null || (object = ((ESLambda)object).getLambda()) == null) continue;
            Object lambdaExpression = object;
            bindingTrace.record(BindingContext.LAMBDA_INVOCATIONS, lambdaExpression, callsEffect.getKind());
        }
    }

    @NotNull
    public final DataFlowInfo extractDataFlowInfoFromCondition(@Nullable KtExpression condition, boolean value2, @NotNull BindingTrace bindingTrace, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter(bindingTrace, "bindingTrace");
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        if (!this.languageVersionSettings.supportsFeature(LanguageFeature.UseReturnsEffect)) {
            return DataFlowInfo.Companion.getEMPTY();
        }
        if (condition == null) {
            return DataFlowInfo.Companion.getEMPTY();
        }
        return ContextInfoToDataFlowInfoKt.toDataFlowInfo(this.getContextInfoWhen(new ESReturns(ESConstants.INSTANCE.booleanValue(value2)), condition, bindingTrace, moduleDescriptor), this.languageVersionSettings, moduleDescriptor.getBuiltIns());
    }

    /*
     * WARNING - void declaration
     */
    private final MutableContextInfo getContextInfoWhen(ESEffect observedEffect, KtExpression expression, BindingTrace bindingTrace, ModuleDescriptor moduleDescriptor) {
        boolean isInContractBlock;
        block3: {
            boolean bl;
            void $this$any$iv;
            Sequence<PsiElement> $this$filterIsInstance$iv = PsiUtilsKt.getParentsWithSelf(expression);
            boolean $i$f$filterIsInstance = false;
            Sequence<PsiElement> sequence2 = SequencesKt.filter($this$filterIsInstance$iv, getContextInfoWhen$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull(sequence2, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            $this$filterIsInstance$iv = sequence2;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                KtExpression it = (KtExpression)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual(bindingTrace.getBindingContext().get(BindingContext.IS_CONTRACT_DECLARATION_BLOCK, it), true)) continue;
                bl = true;
                break block3;
            }
            bl = isInContractBlock = false;
        }
        if (isInContractBlock) {
            return MutableContextInfo.Companion.getEMPTY();
        }
        Computation computation = this.getNonTrivialComputation(expression, bindingTrace, moduleDescriptor);
        if (computation == null) {
            return MutableContextInfo.Companion.getEMPTY();
        }
        Computation computation2 = computation;
        return new InfoCollector(observedEffect, this.builtIns).collectFromSchema(computation2.getEffects());
    }

    private final Computation getNonTrivialComputation(KtExpression expression, BindingTrace trace, ModuleDescriptor moduleDescriptor) {
        Computation computation;
        EffectsExtractingVisitor visitor2 = new EffectsExtractingVisitor(trace, moduleDescriptor, this.dataFlowValueFactory, this.languageVersionSettings);
        Computation it = computation = visitor2.extractOrGetCached(expression);
        boolean bl = false;
        return !Intrinsics.areEqual(it, UNKNOWN_COMPUTATION.INSTANCE) ? computation : null;
    }
}

