/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.description;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import org.jetbrains.kotlin.contracts.interpretation.ContractInterpretationDispatcher;
import org.jetbrains.kotlin.contracts.model.Functor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.storage.NullableLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fR \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0006\u001a\u00020\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u00168\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018"}, d2={"Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "", "", "Lorg/jetbrains/kotlin/contracts/description/EffectDeclaration;", "effects", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "ownerFunction", "Lorg/jetbrains/kotlin/storage/StorageManager;", "storageManager", "<init>", "(Ljava/util/List;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "usageModule", "Lorg/jetbrains/kotlin/contracts/model/Functor;", "getFunctor", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Lorg/jetbrains/kotlin/contracts/model/Functor;", "Ljava/util/List;", "getEffects", "()Ljava/util/List;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getOwnerFunction", "()Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/storage/NullableLazyValue;", "computeFunctor", "Lorg/jetbrains/kotlin/storage/NullableLazyValue;"})
public class ContractDescription {
    @NotNull
    private final List<EffectDeclaration> effects;
    @NotNull
    private final FunctionDescriptor ownerFunction;
    @NotNull
    private final NullableLazyValue<Functor> computeFunctor;

    public ContractDescription(@NotNull List<? extends EffectDeclaration> effects, @NotNull FunctionDescriptor ownerFunction, @NotNull StorageManager storageManager) {
        Intrinsics.checkNotNullParameter(effects, "effects");
        Intrinsics.checkNotNullParameter(ownerFunction, "ownerFunction");
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        this.effects = effects;
        this.ownerFunction = ownerFunction;
        this.computeFunctor = storageManager.createNullableLazyValue(() -> ContractDescription.computeFunctor$lambda$0(this));
    }

    @NotNull
    public final List<EffectDeclaration> getEffects() {
        return this.effects;
    }

    @NotNull
    public final FunctionDescriptor getOwnerFunction() {
        return this.ownerFunction;
    }

    @Nullable
    public final Functor getFunctor(@NotNull ModuleDescriptor usageModule) {
        Intrinsics.checkNotNullParameter(usageModule, "usageModule");
        return (Functor)this.computeFunctor.invoke();
    }

    private static final Functor computeFunctor$lambda$0(ContractDescription this$0) {
        return new ContractInterpretationDispatcher().convertContractDescriptorToFunctor(this$0);
    }
}

