/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.description;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.AbstractContractProvider;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\n\u001a\u0004\u0018\u00010\tH\u0017\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0010R\u001c\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0011R\u0016\u0010\u0013\u001a\u00020\u00128\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0018\u0010\f\u001a\u0004\u0018\u00010\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0015"}, d2={"Lorg/jetbrains/kotlin/contracts/description/LazyContractProvider;", "Lorg/jetbrains/kotlin/contracts/description/AbstractContractProvider;", "Lorg/jetbrains/kotlin/storage/StorageManager;", "storageManager", "Lkotlin/Function0;", "", "computation", "<init>", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lkotlin/jvm/functions/Function0;)V", "Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "getContractDescription", "()Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "contractDescription", "", "setContractDescription", "(Lorg/jetbrains/kotlin/contracts/description/ContractDescription;)V", "Lorg/jetbrains/kotlin/storage/StorageManager;", "Lkotlin/jvm/functions/Function0;", "", "isComputed", "Z", "Lorg/jetbrains/kotlin/contracts/description/ContractDescription;"})
public final class LazyContractProvider
extends AbstractContractProvider {
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final Function0<Object> computation;
    private volatile boolean isComputed;
    @Nullable
    private ContractDescription contractDescription;

    public LazyContractProvider(@NotNull StorageManager storageManager, @NotNull Function0<? extends Object> computation) {
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        Intrinsics.checkNotNullParameter(computation, "computation");
        this.storageManager = storageManager;
        this.computation = computation;
    }

    @Override
    @Nullable
    public ContractDescription getContractDescription() {
        if (!this.isComputed) {
            this.storageManager.compute(this.computation);
            boolean bl = this.isComputed;
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = "Computation of contract hasn't initialized contract properly";
                throw new AssertionError((Object)string2);
            }
        }
        return this.contractDescription;
    }

    public final void setContractDescription(@Nullable ContractDescription contractDescription) {
        this.contractDescription = contractDescription;
        this.isComputed = true;
    }
}

