/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.interpretation;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.ContractDescriptionVisitor;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanVariableReference;
import org.jetbrains.kotlin.contracts.description.expressions.IsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.expressions.IsNullPredicate;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalAnd;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalNot;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalOr;
import org.jetbrains.kotlin.contracts.interpretation.ContractInterpretationDispatcher;
import org.jetbrains.kotlin.contracts.model.ESExpression;
import org.jetbrains.kotlin.contracts.model.functors.IsFunctor;
import org.jetbrains.kotlin.contracts.model.structure.ESAnd;
import org.jetbrains.kotlin.contracts.model.structure.ESConstants;
import org.jetbrains.kotlin.contracts.model.structure.ESEqual;
import org.jetbrains.kotlin.contracts.model.structure.ESIs;
import org.jetbrains.kotlin.contracts.model.structure.ESNot;
import org.jetbrains.kotlin.contracts.model.structure.ESOr;
import org.jetbrains.kotlin.contracts.model.structure.ESVariable;
import org.jetbrains.kotlin.contracts.model.structure.TypesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J!\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ!\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b\u000f\u0010\u0010J!\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b\u0013\u0010\u0014J!\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b\u0017\u0010\u0018J!\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b\u001b\u0010\u001cJ!\u0010\u001f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\n\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b\u001f\u0010 J!\u0010#\u001a\u0004\u0018\u00010\u00022\u0006\u0010\"\u001a\u00020!2\u0006\u0010\n\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b#\u0010$R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010%"}, d2={"Lorg/jetbrains/kotlin/contracts/interpretation/ConditionInterpreter;", "Lorg/jetbrains/kotlin/contracts/description/ContractDescriptionVisitor;", "Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "", "Lorg/jetbrains/kotlin/contracts/interpretation/ContractInterpretationDispatcher;", "dispatcher", "<init>", "(Lorg/jetbrains/kotlin/contracts/interpretation/ContractInterpretationDispatcher;)V", "Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalOr;", "logicalOr", "data", "visitLogicalOr", "(Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalOr;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalAnd;", "logicalAnd", "visitLogicalAnd", "(Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalAnd;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalNot;", "logicalNot", "visitLogicalNot", "(Lorg/jetbrains/kotlin/contracts/description/expressions/LogicalNot;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "Lorg/jetbrains/kotlin/contracts/description/expressions/IsInstancePredicate;", "isInstancePredicate", "visitIsInstancePredicate", "(Lorg/jetbrains/kotlin/contracts/description/expressions/IsInstancePredicate;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "Lorg/jetbrains/kotlin/contracts/description/expressions/IsNullPredicate;", "isNullPredicate", "visitIsNullPredicate", "(Lorg/jetbrains/kotlin/contracts/description/expressions/IsNullPredicate;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "Lorg/jetbrains/kotlin/contracts/description/expressions/BooleanConstantReference;", "booleanConstantDescriptor", "visitBooleanConstantDescriptor", "(Lorg/jetbrains/kotlin/contracts/description/expressions/BooleanConstantReference;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "Lorg/jetbrains/kotlin/contracts/description/expressions/BooleanVariableReference;", "booleanVariableReference", "visitBooleanVariableReference", "(Lorg/jetbrains/kotlin/contracts/description/expressions/BooleanVariableReference;Lkotlin/Unit;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "Lorg/jetbrains/kotlin/contracts/interpretation/ContractInterpretationDispatcher;"})
public final class ConditionInterpreter
implements ContractDescriptionVisitor<ESExpression, Unit> {
    @NotNull
    private final ContractInterpretationDispatcher dispatcher;

    public ConditionInterpreter(@NotNull ContractInterpretationDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, "dispatcher");
        this.dispatcher = dispatcher;
    }

    @Override
    @Nullable
    public ESExpression visitLogicalOr(@NotNull LogicalOr logicalOr, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter(logicalOr, "logicalOr");
        Intrinsics.checkNotNullParameter(data2, "data");
        ESExpression eSExpression = (ESExpression)logicalOr.getLeft().accept(this, data2);
        if (eSExpression == null) {
            return null;
        }
        ESExpression left = eSExpression;
        ESExpression eSExpression2 = (ESExpression)logicalOr.getRight().accept(this, data2);
        if (eSExpression2 == null) {
            return null;
        }
        ESExpression right = eSExpression2;
        return new ESOr(left, right);
    }

    @Override
    @Nullable
    public ESExpression visitLogicalAnd(@NotNull LogicalAnd logicalAnd, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter(logicalAnd, "logicalAnd");
        Intrinsics.checkNotNullParameter(data2, "data");
        ESExpression eSExpression = (ESExpression)logicalAnd.getLeft().accept(this, data2);
        if (eSExpression == null) {
            return null;
        }
        ESExpression left = eSExpression;
        ESExpression eSExpression2 = (ESExpression)logicalAnd.getRight().accept(this, data2);
        if (eSExpression2 == null) {
            return null;
        }
        ESExpression right = eSExpression2;
        return new ESAnd(left, right);
    }

    @Override
    @Nullable
    public ESExpression visitLogicalNot(@NotNull LogicalNot logicalNot, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter(logicalNot, "logicalNot");
        Intrinsics.checkNotNullParameter(data2, "data");
        ESExpression eSExpression = (ESExpression)logicalNot.getArg().accept(this, data2);
        if (eSExpression == null) {
            return null;
        }
        ESExpression arg = eSExpression;
        return new ESNot(arg);
    }

    @Override
    @Nullable
    public ESExpression visitIsInstancePredicate(@NotNull IsInstancePredicate isInstancePredicate, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter(isInstancePredicate, "isInstancePredicate");
        Intrinsics.checkNotNullParameter(data2, "data");
        ESVariable eSVariable = this.dispatcher.interpretVariable$resolution(isInstancePredicate.getArg());
        if (eSVariable == null) {
            return null;
        }
        ESVariable esVariable = eSVariable;
        return new ESIs(esVariable, new IsFunctor(TypesKt.toESType(isInstancePredicate.getType()), isInstancePredicate.isNegated()));
    }

    @Override
    @Nullable
    public ESExpression visitIsNullPredicate(@NotNull IsNullPredicate isNullPredicate, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter(isNullPredicate, "isNullPredicate");
        Intrinsics.checkNotNullParameter(data2, "data");
        ESVariable eSVariable = this.dispatcher.interpretVariable$resolution(isNullPredicate.getArg());
        if (eSVariable == null) {
            return null;
        }
        ESVariable variable = eSVariable;
        return new ESEqual(variable, ESConstants.INSTANCE.getNullValue(), isNullPredicate.isNegated());
    }

    @Override
    @Nullable
    public ESExpression visitBooleanConstantDescriptor(@NotNull BooleanConstantReference booleanConstantDescriptor, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter(booleanConstantDescriptor, "booleanConstantDescriptor");
        Intrinsics.checkNotNullParameter(data2, "data");
        return this.dispatcher.interpretConstant$resolution(booleanConstantDescriptor);
    }

    @Override
    @Nullable
    public ESExpression visitBooleanVariableReference(@NotNull BooleanVariableReference booleanVariableReference, @NotNull Unit data2) {
        Intrinsics.checkNotNullParameter(booleanVariableReference, "booleanVariableReference");
        Intrinsics.checkNotNullParameter(data2, "data");
        return this.dispatcher.interpretVariable$resolution(booleanVariableReference);
    }
}

