/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.interpretation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.BooleanExpression;
import org.jetbrains.kotlin.contracts.description.ConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.VariableReference;
import org.jetbrains.kotlin.contracts.interpretation.CallsEffectInterpreter;
import org.jetbrains.kotlin.contracts.interpretation.ConditionInterpreter;
import org.jetbrains.kotlin.contracts.interpretation.ConditionalEffectInterpreter;
import org.jetbrains.kotlin.contracts.interpretation.ConstantValuesInterpreter;
import org.jetbrains.kotlin.contracts.interpretation.EffectDeclarationInterpreter;
import org.jetbrains.kotlin.contracts.interpretation.ReturnsEffectInterpreter;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESExpression;
import org.jetbrains.kotlin.contracts.model.Functor;
import org.jetbrains.kotlin.contracts.model.functors.SubstitutingFunctor;
import org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import org.jetbrains.kotlin.contracts.model.structure.ESVariable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\tH\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0016\u001a\u00020\u0015H\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0019\u0010 \u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001c\u001a\u00020\u001bH\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0014\u0010\"\u001a\u00020!8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020$8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010(\u001a\u00020'8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020+0*8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-"}, d2={"Lorg/jetbrains/kotlin/contracts/interpretation/ContractInterpretationDispatcher;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "contractDescription", "Lorg/jetbrains/kotlin/contracts/model/Functor;", "convertContractDescriptorToFunctor", "(Lorg/jetbrains/kotlin/contracts/description/ContractDescription;)Lorg/jetbrains/kotlin/contracts/model/Functor;", "Lorg/jetbrains/kotlin/contracts/description/EffectDeclaration;", "effectDeclaration", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "interpretEffect$resolution", "(Lorg/jetbrains/kotlin/contracts/description/EffectDeclaration;)Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "interpretEffect", "Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "constantReference", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "interpretConstant$resolution", "(Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;)Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "interpretConstant", "Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "booleanExpression", "Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "interpretCondition$resolution", "(Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "interpretCondition", "Lorg/jetbrains/kotlin/contracts/description/expressions/VariableReference;", "variableReference", "Lorg/jetbrains/kotlin/contracts/model/structure/ESVariable;", "interpretVariable$resolution", "(Lorg/jetbrains/kotlin/contracts/description/expressions/VariableReference;)Lorg/jetbrains/kotlin/contracts/model/structure/ESVariable;", "interpretVariable", "Lorg/jetbrains/kotlin/contracts/interpretation/ConstantValuesInterpreter;", "constantsInterpreter", "Lorg/jetbrains/kotlin/contracts/interpretation/ConstantValuesInterpreter;", "Lorg/jetbrains/kotlin/contracts/interpretation/ConditionInterpreter;", "conditionInterpreter", "Lorg/jetbrains/kotlin/contracts/interpretation/ConditionInterpreter;", "Lorg/jetbrains/kotlin/contracts/interpretation/ConditionalEffectInterpreter;", "conditionalEffectInterpreter", "Lorg/jetbrains/kotlin/contracts/interpretation/ConditionalEffectInterpreter;", "", "Lorg/jetbrains/kotlin/contracts/interpretation/EffectDeclarationInterpreter;", "effectsInterpreters", "Ljava/util/List;"})
public final class ContractInterpretationDispatcher {
    @NotNull
    private final ConstantValuesInterpreter constantsInterpreter = new ConstantValuesInterpreter();
    @NotNull
    private final ConditionInterpreter conditionInterpreter = new ConditionInterpreter(this);
    @NotNull
    private final ConditionalEffectInterpreter conditionalEffectInterpreter = new ConditionalEffectInterpreter(this);
    @NotNull
    private final List<EffectDeclarationInterpreter> effectsInterpreters;

    public ContractInterpretationDispatcher() {
        EffectDeclarationInterpreter[] effectDeclarationInterpreterArray = new EffectDeclarationInterpreter[]{new ReturnsEffectInterpreter(this), new CallsEffectInterpreter(this)};
        this.effectsInterpreters = CollectionsKt.listOf(effectDeclarationInterpreterArray);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Functor convertContractDescriptorToFunctor(@NotNull ContractDescription contractDescription) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(contractDescription, "contractDescription");
        Iterable $this$map$iv = contractDescription.getEffects();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ESEffect eSEffect;
            void effect;
            EffectDeclaration effectDeclaration = (EffectDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (effect instanceof ConditionalEffectDeclaration) {
                ConditionalEffect conditionalEffect = this.conditionalEffectInterpreter.interpret((ConditionalEffectDeclaration)effect);
                if (conditionalEffect == null) {
                    return null;
                }
                eSEffect = conditionalEffect;
            } else {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = this.effectsInterpreters;
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    ESEffect it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    EffectDeclarationInterpreter it = (EffectDeclarationInterpreter)element$iv$iv;
                    boolean bl3 = false;
                    if (it.tryInterpret((EffectDeclaration)effect) == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                eSEffect = (ESEffect)CollectionsKt.singleOrNull((List)destination$iv$iv2);
                if (eSEffect == null) {
                    return null;
                }
            }
            collection.add(eSEffect);
        }
        List resultingClauses = (List)destination$iv$iv;
        return new SubstitutingFunctor(resultingClauses, contractDescription.getOwnerFunction());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ESEffect interpretEffect$resolution(@NotNull EffectDeclaration effectDeclaration) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(effectDeclaration, "effectDeclaration");
        Iterable $this$mapNotNull$iv = this.effectsInterpreters;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ESEffect it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            EffectDeclarationInterpreter it = (EffectDeclarationInterpreter)element$iv$iv;
            boolean bl2 = false;
            if (it.tryInterpret(effectDeclaration) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List convertedFunctors = (List)destination$iv$iv;
        return (ESEffect)CollectionsKt.singleOrNull(convertedFunctors);
    }

    @Nullable
    public final ESConstant interpretConstant$resolution(@NotNull ConstantReference constantReference) {
        Intrinsics.checkNotNullParameter(constantReference, "constantReference");
        return this.constantsInterpreter.interpretConstant(constantReference);
    }

    @Nullable
    public final ESExpression interpretCondition$resolution(@NotNull BooleanExpression booleanExpression) {
        Intrinsics.checkNotNullParameter(booleanExpression, "booleanExpression");
        return (ESExpression)booleanExpression.accept(this.conditionInterpreter, Unit.INSTANCE);
    }

    @Nullable
    public final ESVariable interpretVariable$resolution(@NotNull VariableReference variableReference) {
        Intrinsics.checkNotNullParameter(variableReference, "variableReference");
        return new ESVariable(variableReference.getDescriptor());
    }
}

