/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.interpretation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ReturnsEffectDeclaration;
import org.jetbrains.kotlin.contracts.interpretation.ContractInterpretationDispatcher;
import org.jetbrains.kotlin.contracts.interpretation.EffectDeclarationInterpreter;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import org.jetbrains.kotlin.contracts.model.structure.ESReturns;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000b"}, d2={"Lorg/jetbrains/kotlin/contracts/interpretation/ReturnsEffectInterpreter;", "Lorg/jetbrains/kotlin/contracts/interpretation/EffectDeclarationInterpreter;", "Lorg/jetbrains/kotlin/contracts/interpretation/ContractInterpretationDispatcher;", "dispatcher", "<init>", "(Lorg/jetbrains/kotlin/contracts/interpretation/ContractInterpretationDispatcher;)V", "Lorg/jetbrains/kotlin/contracts/description/EffectDeclaration;", "effectDeclaration", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "tryInterpret", "(Lorg/jetbrains/kotlin/contracts/description/EffectDeclaration;)Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "Lorg/jetbrains/kotlin/contracts/interpretation/ContractInterpretationDispatcher;"})
public final class ReturnsEffectInterpreter
implements EffectDeclarationInterpreter {
    @NotNull
    private final ContractInterpretationDispatcher dispatcher;

    public ReturnsEffectInterpreter(@NotNull ContractInterpretationDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, "dispatcher");
        this.dispatcher = dispatcher;
    }

    @Override
    @Nullable
    public ESEffect tryInterpret(@NotNull EffectDeclaration effectDeclaration) {
        Intrinsics.checkNotNullParameter(effectDeclaration, "effectDeclaration");
        if (!(effectDeclaration instanceof ReturnsEffectDeclaration)) {
            return null;
        }
        ESConstant eSConstant = this.dispatcher.interpretConstant$resolution(((ReturnsEffectDeclaration)effectDeclaration).getValue());
        if (eSConstant == null) {
            return null;
        }
        ESConstant returnedValue = eSConstant;
        return new ESReturns(returnedValue);
    }
}

