/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.functors;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.model.AbstractFunctor;
import org.jetbrains.kotlin.contracts.model.Computation;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESTypeSubstitution;
import org.jetbrains.kotlin.contracts.model.ESValue;
import org.jetbrains.kotlin.contracts.model.structure.ESConstants;
import org.jetbrains.kotlin.contracts.model.structure.ESIs;
import org.jetbrains.kotlin.contracts.model.structure.ESKotlinType;
import org.jetbrains.kotlin.contracts.model.structure.ESReturns;
import org.jetbrains.kotlin.contracts.model.structure.ESType;
import org.jetbrains.kotlin.contracts.model.visitors.Reducer;
import org.jetbrains.kotlin.types.UnwrappedType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J3\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0015\u00a2\u0006\u0004\b\u0010\u0010\u0011J%\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J%\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\b2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b\u0005\u0010\u001e"}, d2={"Lorg/jetbrains/kotlin/contracts/model/functors/IsFunctor;", "Lorg/jetbrains/kotlin/contracts/model/AbstractFunctor;", "Lorg/jetbrains/kotlin/contracts/model/structure/ESType;", "type", "", "isNegated", "<init>", "(Lorg/jetbrains/kotlin/contracts/model/structure/ESType;Z)V", "", "Lorg/jetbrains/kotlin/contracts/model/Computation;", "arguments", "Lorg/jetbrains/kotlin/contracts/model/ESTypeSubstitution;", "typeSubstitution", "Lorg/jetbrains/kotlin/contracts/model/visitors/Reducer;", "reducer", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "doInvocation", "(Ljava/util/List;Lorg/jetbrains/kotlin/contracts/model/ESTypeSubstitution;Lorg/jetbrains/kotlin/contracts/model/visitors/Reducer;)Ljava/util/List;", "arg", "invokeWithArguments", "(Lorg/jetbrains/kotlin/contracts/model/Computation;Lorg/jetbrains/kotlin/contracts/model/ESTypeSubstitution;)Ljava/util/List;", "Lorg/jetbrains/kotlin/contracts/model/ESValue;", "value", "Lorg/jetbrains/kotlin/contracts/model/ConditionalEffect;", "invokeWithValue", "(Lorg/jetbrains/kotlin/contracts/model/ESValue;Lorg/jetbrains/kotlin/contracts/model/ESTypeSubstitution;)Ljava/util/List;", "Lorg/jetbrains/kotlin/contracts/model/structure/ESType;", "getType", "()Lorg/jetbrains/kotlin/contracts/model/structure/ESType;", "Z", "()Z"})
public final class IsFunctor
extends AbstractFunctor {
    @NotNull
    private final ESType type;
    private final boolean isNegated;

    public IsFunctor(@NotNull ESType type2, boolean isNegated) {
        Intrinsics.checkNotNullParameter(type2, "type");
        this.type = type2;
        this.isNegated = isNegated;
    }

    @NotNull
    public final ESType getType() {
        return this.type;
    }

    public final boolean isNegated() {
        return this.isNegated;
    }

    @Override
    @NotNull
    protected List<ESEffect> doInvocation(@NotNull List<? extends Computation> arguments2, @NotNull ESTypeSubstitution typeSubstitution, @NotNull Reducer reducer) {
        boolean bl;
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(typeSubstitution, "typeSubstitution");
        Intrinsics.checkNotNullParameter(reducer, "reducer");
        boolean bl2 = bl = arguments2.size() == 1;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Wrong size of arguments list for Unary operator: expected 1, got " + arguments2.size();
            throw new AssertionError((Object)string2);
        }
        return this.invokeWithArguments(arguments2.get(0), typeSubstitution);
    }

    @NotNull
    public final List<ESEffect> invokeWithArguments(@NotNull Computation arg, @NotNull ESTypeSubstitution typeSubstitution) {
        Intrinsics.checkNotNullParameter(arg, "arg");
        Intrinsics.checkNotNullParameter(typeSubstitution, "typeSubstitution");
        return arg instanceof ESValue ? this.invokeWithValue((ESValue)arg, typeSubstitution) : CollectionsKt.emptyList();
    }

    private final List<ConditionalEffect> invokeWithValue(ESValue value2, ESTypeSubstitution typeSubstitution) {
        UnwrappedType substitutedKotlinType = typeSubstitution.getSubstitutor().safeSubstitute(this.type.toKotlinType(typeSubstitution.getBuiltIns()).unwrap());
        ESKotlinType substitutedType = new ESKotlinType(substitutedKotlinType);
        ESIs trueIs = new ESIs(value2, new IsFunctor(substitutedType, this.isNegated));
        ESIs falseIs = new ESIs(value2, new IsFunctor(substitutedType, !this.isNegated));
        ConditionalEffect trueResult = new ConditionalEffect(trueIs, new ESReturns(ESConstants.INSTANCE.getTrueValue()));
        ConditionalEffect falseResult = new ConditionalEffect(falseIs, new ESReturns(ESConstants.INSTANCE.getFalseValue()));
        ConditionalEffect[] conditionalEffectArray = new ConditionalEffect[]{trueResult, falseResult};
        return CollectionsKt.listOf(conditionalEffectArray);
    }
}

