/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.functors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.model.AbstractFunctor;
import org.jetbrains.kotlin.contracts.model.Computation;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESTypeSubstitution;
import org.jetbrains.kotlin.contracts.model.ESValue;
import org.jetbrains.kotlin.contracts.model.SimpleEffect;
import org.jetbrains.kotlin.contracts.model.structure.ESCalls;
import org.jetbrains.kotlin.contracts.model.structure.ESReturns;
import org.jetbrains.kotlin.contracts.model.structure.ESVariable;
import org.jetbrains.kotlin.contracts.model.structure.ValuesKt;
import org.jetbrains.kotlin.contracts.model.visitors.Reducer;
import org.jetbrains.kotlin.contracts.model.visitors.Substitutor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ3\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00022\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0015\u00a2\u0006\u0004\b\u000f\u0010\u0010J#\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0002H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J!\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0013\u0010\u001a\u001a\u00020\u0011*\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001cR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001d"}, d2={"Lorg/jetbrains/kotlin/contracts/model/functors/SubstitutingFunctor;", "Lorg/jetbrains/kotlin/contracts/model/AbstractFunctor;", "", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "basicEffects", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "ownerFunction", "<init>", "(Ljava/util/List;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "Lorg/jetbrains/kotlin/contracts/model/Computation;", "arguments", "Lorg/jetbrains/kotlin/contracts/model/ESTypeSubstitution;", "typeSubstitution", "Lorg/jetbrains/kotlin/contracts/model/visitors/Reducer;", "reducer", "doInvocation", "(Ljava/util/List;Lorg/jetbrains/kotlin/contracts/model/ESTypeSubstitution;Lorg/jetbrains/kotlin/contracts/model/visitors/Reducer;)Ljava/util/List;", "Lorg/jetbrains/kotlin/contracts/model/structure/ESVariable;", "computeParameters", "(Ljava/util/List;)Ljava/util/List;", "Lorg/jetbrains/kotlin/contracts/model/SimpleEffect;", "effect", "substitutedCondition", "combine", "(Lorg/jetbrains/kotlin/contracts/model/SimpleEffect;Lorg/jetbrains/kotlin/contracts/model/ESEffect;)Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "Lorg/jetbrains/kotlin/descriptors/ValueDescriptor;", "toESVariable", "(Lorg/jetbrains/kotlin/descriptors/ValueDescriptor;)Lorg/jetbrains/kotlin/contracts/model/structure/ESVariable;", "Ljava/util/List;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;"})
public final class SubstitutingFunctor
extends AbstractFunctor {
    @NotNull
    private final List<ESEffect> basicEffects;
    @NotNull
    private final FunctionDescriptor ownerFunction;

    public SubstitutingFunctor(@NotNull List<? extends ESEffect> basicEffects, @NotNull FunctionDescriptor ownerFunction) {
        Intrinsics.checkNotNullParameter(basicEffects, "basicEffects");
        Intrinsics.checkNotNullParameter(ownerFunction, "ownerFunction");
        this.basicEffects = basicEffects;
        this.ownerFunction = ownerFunction;
    }

    @Override
    @NotNull
    protected List<ESEffect> doInvocation(@NotNull List<? extends Computation> arguments2, @NotNull ESTypeSubstitution typeSubstitution, @NotNull Reducer reducer) {
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(typeSubstitution, "typeSubstitution");
        Intrinsics.checkNotNullParameter(reducer, "reducer");
        if (this.basicEffects.isEmpty()) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        List<ESVariable> parameters2 = this.computeParameters(arguments2);
        Map substitutions = MapsKt.toMap(kotlin.collections.CollectionsKt.zip((Iterable)parameters2, (Iterable)arguments2));
        Substitutor substitutor2 = new Substitutor(substitutions, typeSubstitution, reducer);
        List substitutedClauses = new ArrayList();
        for (ESEffect effect : this.basicEffects) {
            ESEffect eSEffect = effect;
            if (eSEffect instanceof ConditionalEffect) {
                Object object = (Computation)((ConditionalEffect)effect).getCondition().accept(substitutor2);
                if (object != null && (object = object.getEffects()) != null) {
                    Iterable $this$forEach$iv = (Iterable)object;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ESEffect it = (ESEffect)element$iv;
                        boolean bl = false;
                        CollectionsKt.addIfNotNull(substitutedClauses, this.combine(((ConditionalEffect)effect).getSimpleEffect(), it));
                    }
                }
                continue;
            }
            if (eSEffect instanceof ESCalls) {
                ESValue substitutionForCallable;
                Object v = substitutions.get(((ESCalls)effect).getCallable());
                if ((v instanceof ESValue ? (ESValue)v : null) == null) continue;
                substitutionForCallable = substitutionForCallable;
                ((Collection)substitutedClauses).add(new ESCalls(substitutionForCallable, ((ESCalls)effect).getKind()));
                continue;
            }
            ((Collection)substitutedClauses).add(effect);
        }
        return substitutedClauses;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ESVariable> computeParameters(List<? extends Computation> arguments2) {
        ESVariable it;
        void $this$mapTo$iv$iv;
        ReceiverParameterDescriptor receiverParameterDescriptor = this.ownerFunction.getDispatchReceiverParameter();
        ESVariable dispatchReceiver = receiverParameterDescriptor != null ? this.toESVariable(receiverParameterDescriptor) : null;
        ReceiverParameterDescriptor receiverParameterDescriptor2 = this.ownerFunction.getExtensionReceiverParameter();
        ESVariable extensionReceiver = receiverParameterDescriptor2 != null ? this.toESVariable(receiverParameterDescriptor2) : null;
        ESVariable[] eSVariableArray = new ESVariable[]{dispatchReceiver, extensionReceiver};
        List<ESVariable> receivers = kotlin.collections.CollectionsKt.listOfNotNull(eSVariableArray);
        List<ValueParameterDescriptor> list = this.ownerFunction.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            collection.add(this.toESVariable((ValueDescriptor)((Object)it)));
        }
        List valueParameters2 = (List)destination$iv$iv;
        List<ESVariable> parameters2 = kotlin.collections.CollectionsKt.plus((Collection)receivers, (Iterable)valueParameters2);
        if (parameters2.size() == arguments2.size()) {
            return parameters2;
        }
        Object object = dispatchReceiver;
        if (object == null || (object = ((ESVariable)object).getDescriptor()) == null) {
            SubstitutingFunctor.computeParameters$fail(arguments2, parameters2);
            throw new KotlinNothingValueException();
        }
        Object dispatchParameterDescriptor = object;
        if (dispatchParameterDescriptor instanceof ReceiverParameterDescriptor) {
            Object object2 = ((ReceiverParameterDescriptor)dispatchParameterDescriptor).getValue();
            Object object3 = object2 instanceof ImplicitClassReceiver ? (ImplicitClassReceiver)object2 : null;
            if (object3 == null || (object3 = ((ImplicitClassReceiver)object3).getClassDescriptor()) == null) {
                SubstitutingFunctor.computeParameters$fail(arguments2, parameters2);
                throw new KotlinNothingValueException();
            }
            Object classDescriptor = object3;
            if (classDescriptor.getKind() == ClassKind.OBJECT) {
                Object $this$computeParameters_u24lambda_u243 = object2 = kotlin.collections.CollectionsKt.createListBuilder();
                boolean bl = false;
                ESVariable eSVariable = extensionReceiver;
                if (eSVariable != null) {
                    it = eSVariable;
                    boolean bl2 = false;
                    $this$computeParameters_u24lambda_u243.add(it);
                }
                $this$computeParameters_u24lambda_u243.addAll(valueParameters2);
                List<ESVariable> parametersWithoutDispatch = kotlin.collections.CollectionsKt.build(object2);
                if (parametersWithoutDispatch.size() != arguments2.size()) {
                    SubstitutingFunctor.computeParameters$fail(arguments2, parameters2);
                    throw new KotlinNothingValueException();
                }
                return parametersWithoutDispatch;
            }
        }
        SubstitutingFunctor.computeParameters$fail(arguments2, parameters2);
        throw new KotlinNothingValueException();
    }

    private final ESEffect combine(SimpleEffect effect, ESEffect substitutedCondition) {
        if (!(substitutedCondition instanceof ConditionalEffect)) {
            return null;
        }
        SimpleEffect effectFromCondition = ((ConditionalEffect)substitutedCondition).getSimpleEffect();
        if (!(effectFromCondition instanceof ESReturns) || ValuesKt.isWildcard(((ESReturns)effectFromCondition).getValue())) {
            return substitutedCondition;
        }
        if (!ValuesKt.isTrue(((ESReturns)effectFromCondition).getValue())) {
            return null;
        }
        return new ConditionalEffect(((ConditionalEffect)substitutedCondition).getCondition(), effect);
    }

    private final ESVariable toESVariable(ValueDescriptor $this$toESVariable) {
        return new ESVariable($this$toESVariable);
    }

    private static final Void computeParameters$fail(List<? extends Computation> $arguments, List<? extends ESVariable> parameters2) {
        throw new IllegalStateException(("Arguments and parameters size mismatch: arguments.size = " + $arguments.size() + ", parameters.size = " + parameters2.size()).toString());
    }
}

