/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.structure;

import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.model.ESExpressionVisitor;
import org.jetbrains.kotlin.contracts.model.structure.AbstractESValue;
import org.jetbrains.kotlin.contracts.model.structure.ESType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J#\u0010\u000b\u001a\u00028\u0000\"\u0004\b\u0000\u0010\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0096\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0017\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0018\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0005\u001a\u00020\u00048\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f"}, d2={"Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "Lorg/jetbrains/kotlin/contracts/model/structure/AbstractESValue;", "Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "constantReference", "Lorg/jetbrains/kotlin/contracts/model/structure/ESType;", "type", "<init>", "(Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;Lorg/jetbrains/kotlin/contracts/model/structure/ESType;)V", "T", "Lorg/jetbrains/kotlin/contracts/model/ESExpressionVisitor;", "visitor", "accept", "(Lorg/jetbrains/kotlin/contracts/model/ESExpressionVisitor;)Ljava/lang/Object;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "isNullConstant", "()Z", "Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "getConstantReference", "()Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "Lorg/jetbrains/kotlin/contracts/model/structure/ESType;", "getType", "()Lorg/jetbrains/kotlin/contracts/model/structure/ESType;"})
public final class ESConstant
extends AbstractESValue {
    @NotNull
    private final ConstantReference constantReference;
    @NotNull
    private final ESType type;

    public ESConstant(@NotNull ConstantReference constantReference, @NotNull ESType type2) {
        Intrinsics.checkNotNullParameter(constantReference, "constantReference");
        Intrinsics.checkNotNullParameter(type2, "type");
        super(type2);
        this.constantReference = constantReference;
        this.type = type2;
    }

    @NotNull
    public final ConstantReference getConstantReference() {
        return this.constantReference;
    }

    @Override
    @NotNull
    public ESType getType() {
        return this.type;
    }

    @Override
    public <T> T accept(@NotNull ESExpressionVisitor<? extends T> visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitConstant(this);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ESConstant && Intrinsics.areEqual(this.constantReference, ((ESConstant)other).constantReference);
    }

    public int hashCode() {
        return Objects.hashCode(this.constantReference);
    }

    @NotNull
    public String toString() {
        return this.constantReference.getName();
    }

    public final boolean isNullConstant() {
        return Intrinsics.areEqual(this.constantReference, ConstantReference.Companion.getNULL()) || Intrinsics.areEqual(this.constantReference, ConstantReference.Companion.getNOT_NULL());
    }
}

