/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.visitors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.contracts.model.ConditionalEffect;
import org.jetbrains.kotlin.contracts.model.ESEffect;
import org.jetbrains.kotlin.contracts.model.ESExpression;
import org.jetbrains.kotlin.contracts.model.ESExpressionVisitor;
import org.jetbrains.kotlin.contracts.model.ESValue;
import org.jetbrains.kotlin.contracts.model.structure.ESAnd;
import org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import org.jetbrains.kotlin.contracts.model.structure.ESConstants;
import org.jetbrains.kotlin.contracts.model.structure.ESEqual;
import org.jetbrains.kotlin.contracts.model.structure.ESIs;
import org.jetbrains.kotlin.contracts.model.structure.ESNot;
import org.jetbrains.kotlin.contracts.model.structure.ESOr;
import org.jetbrains.kotlin.contracts.model.structure.ESReceiver;
import org.jetbrains.kotlin.contracts.model.structure.ESType;
import org.jetbrains.kotlin.contracts.model.structure.ESVariable;
import org.jetbrains.kotlin.contracts.model.structure.ValuesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J#\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000fH\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0019\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u0013H\u0017\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0019\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0018\u001a\u00020\u0017H\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0019\u0010\u001d\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001c\u001a\u00020\u001bH\u0017\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0019\u0010!\u001a\u0004\u0018\u00010\u00022\u0006\u0010 \u001a\u00020\u001fH\u0017\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010%\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0017\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010)\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0017\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010-\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0017\u00a2\u0006\u0004\b-\u0010.J\u0019\u00101\u001a\u0004\u0018\u00010\u00022\u0006\u00100\u001a\u00020/H\u0017\u00a2\u0006\u0004\b1\u00102R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u00103"}, d2={"Lorg/jetbrains/kotlin/contracts/model/visitors/Reducer;", "Lorg/jetbrains/kotlin/contracts/model/ESExpressionVisitor;", "Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "builtIns", "<init>", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "", "Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "schema", "reduceEffects", "(Ljava/util/List;)Ljava/util/List;", "effect", "reduceEffect", "(Lorg/jetbrains/kotlin/contracts/model/ESEffect;)Lorg/jetbrains/kotlin/contracts/model/ESEffect;", "Lorg/jetbrains/kotlin/contracts/model/structure/ESIs;", "isOperator", "visitIs", "(Lorg/jetbrains/kotlin/contracts/model/structure/ESIs;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "Lorg/jetbrains/kotlin/contracts/model/structure/ESEqual;", "equal", "visitEqual", "(Lorg/jetbrains/kotlin/contracts/model/structure/ESEqual;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "Lorg/jetbrains/kotlin/contracts/model/structure/ESAnd;", "and", "visitAnd", "(Lorg/jetbrains/kotlin/contracts/model/structure/ESAnd;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "Lorg/jetbrains/kotlin/contracts/model/structure/ESOr;", "or", "visitOr", "(Lorg/jetbrains/kotlin/contracts/model/structure/ESOr;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "Lorg/jetbrains/kotlin/contracts/model/structure/ESNot;", "not", "visitNot", "(Lorg/jetbrains/kotlin/contracts/model/structure/ESNot;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "Lorg/jetbrains/kotlin/contracts/model/structure/ESVariable;", "esVariable", "visitVariable", "(Lorg/jetbrains/kotlin/contracts/model/structure/ESVariable;)Lorg/jetbrains/kotlin/contracts/model/structure/ESVariable;", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "esConstant", "visitConstant", "(Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;)Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "Lorg/jetbrains/kotlin/contracts/model/structure/ESReceiver;", "esReceiver", "visitReceiver", "(Lorg/jetbrains/kotlin/contracts/model/structure/ESReceiver;)Lorg/jetbrains/kotlin/contracts/model/structure/ESReceiver;", "Lorg/jetbrains/kotlin/contracts/model/ESValue;", "lambda", "visitLambda", "(Lorg/jetbrains/kotlin/contracts/model/ESValue;)Lorg/jetbrains/kotlin/contracts/model/ESExpression;", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;"})
public final class Reducer
implements ESExpressionVisitor<ESExpression> {
    @NotNull
    private final KotlinBuiltIns builtIns;

    public Reducer(@NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        this.builtIns = builtIns;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ESEffect> reduceEffects(@NotNull List<? extends ESEffect> schema) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(schema, "schema");
        Iterable $this$mapNotNull$iv = schema;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ESEffect it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ESEffect it = (ESEffect)element$iv$iv;
            boolean bl2 = false;
            if (this.reduceEffect(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ESEffect reduceEffect(ESEffect effect) {
        if (effect instanceof ConditionalEffect) {
            ESExpression eSExpression = (ESExpression)((ConditionalEffect)effect).getCondition().accept(this);
            if (eSExpression == null) {
                return null;
            }
            ESExpression reducedCondition = eSExpression;
            if (ValuesKt.isFalse(reducedCondition)) {
                return null;
            }
            if (ValuesKt.isTrue(reducedCondition)) {
                return ((ConditionalEffect)effect).getSimpleEffect();
            }
            return effect;
        }
        return effect;
    }

    @Override
    @NotNull
    public ESExpression visitIs(@NotNull ESIs isOperator) {
        Boolean result2;
        Boolean bl;
        Intrinsics.checkNotNullParameter(isOperator, "isOperator");
        Object t = isOperator.getLeft().accept(this);
        Intrinsics.checkNotNull(t, "null cannot be cast to non-null type org.jetbrains.kotlin.contracts.model.ESValue");
        ESValue reducedArg = (ESValue)t;
        ESType eSType = reducedArg.getType();
        KotlinType argType = eSType != null ? eSType.toKotlinType(this.builtIns) : null;
        KotlinType isType = isOperator.getFunctor().getType().toKotlinType(this.builtIns);
        ESValue eSValue = reducedArg;
        if (eSValue instanceof ESConstant) {
            KotlinType kotlinType = argType;
            Intrinsics.checkNotNull(kotlinType);
            bl = TypeUtilsKt.isSubtypeOf(kotlinType, isType);
        } else if (eSValue instanceof ESVariable || eSValue instanceof ESReceiver) {
            KotlinType kotlinType = argType;
            bl = (kotlinType != null ? TypeUtilsKt.isSubtypeOf(kotlinType, isType) : false) ? Boolean.valueOf(true) : null;
        } else {
            throw new IllegalStateException("Unknown ESValue: " + reducedArg);
        }
        Boolean bl2 = result2 = bl;
        if (bl2 == null) {
            return new ESIs(reducedArg, isOperator.getFunctor());
        }
        bl2.booleanValue();
        return ESConstants.INSTANCE.booleanValue(result2 ^ isOperator.getFunctor().isNegated());
    }

    @Override
    @Nullable
    public ESExpression visitEqual(@NotNull ESEqual equal) {
        Intrinsics.checkNotNullParameter(equal, "equal");
        ESValue eSValue = (ESValue)equal.getLeft().accept(this);
        if (eSValue == null) {
            return null;
        }
        ESValue reducedLeft = eSValue;
        ESValue reducedRight = equal.getRight();
        if (reducedLeft instanceof ESConstant) {
            return ESConstants.INSTANCE.booleanValue(Intrinsics.areEqual(reducedLeft, reducedRight) ^ equal.getFunctor().isNegated());
        }
        return new ESEqual(reducedLeft, reducedRight, equal.getFunctor().isNegated());
    }

    @Override
    @Nullable
    public ESExpression visitAnd(@NotNull ESAnd and2) {
        Intrinsics.checkNotNullParameter(and2, "and");
        ESExpression eSExpression = (ESExpression)and2.getLeft().accept(this);
        if (eSExpression == null) {
            return null;
        }
        ESExpression reducedLeft = eSExpression;
        ESExpression eSExpression2 = (ESExpression)and2.getRight().accept(this);
        if (eSExpression2 == null) {
            return null;
        }
        ESExpression reducedRight = eSExpression2;
        return ValuesKt.isFalse(reducedLeft) || ValuesKt.isFalse(reducedRight) ? reducedLeft : (ValuesKt.isTrue(reducedLeft) ? reducedRight : (ValuesKt.isTrue(reducedRight) ? reducedLeft : (ESExpression)new ESAnd(reducedLeft, reducedRight)));
    }

    @Override
    @Nullable
    public ESExpression visitOr(@NotNull ESOr or2) {
        Intrinsics.checkNotNullParameter(or2, "or");
        ESExpression eSExpression = (ESExpression)or2.getLeft().accept(this);
        if (eSExpression == null) {
            return null;
        }
        ESExpression reducedLeft = eSExpression;
        ESExpression eSExpression2 = (ESExpression)or2.getRight().accept(this);
        if (eSExpression2 == null) {
            return null;
        }
        ESExpression reducedRight = eSExpression2;
        return ValuesKt.isTrue(reducedLeft) || ValuesKt.isTrue(reducedRight) ? reducedLeft : (ValuesKt.isFalse(reducedLeft) ? reducedRight : (ValuesKt.isFalse(reducedRight) ? reducedLeft : (ESExpression)new ESOr(reducedLeft, reducedRight)));
    }

    @Override
    @Nullable
    public ESExpression visitNot(@NotNull ESNot not) {
        Intrinsics.checkNotNullParameter(not, "not");
        ESExpression eSExpression = (ESExpression)not.getArg().accept(this);
        if (eSExpression == null) {
            return null;
        }
        ESExpression reducedArg = eSExpression;
        return ValuesKt.isTrue(reducedArg) ? (ESExpression)ESConstants.INSTANCE.getFalseValue() : (ValuesKt.isFalse(reducedArg) ? (ESExpression)ESConstants.INSTANCE.getTrueValue() : reducedArg);
    }

    @Override
    @NotNull
    public ESVariable visitVariable(@NotNull ESVariable esVariable) {
        Intrinsics.checkNotNullParameter(esVariable, "esVariable");
        return esVariable;
    }

    @Override
    @NotNull
    public ESConstant visitConstant(@NotNull ESConstant esConstant) {
        Intrinsics.checkNotNullParameter(esConstant, "esConstant");
        return esConstant;
    }

    @Override
    @NotNull
    public ESReceiver visitReceiver(@NotNull ESReceiver esReceiver) {
        Intrinsics.checkNotNullParameter(esReceiver, "esReceiver");
        return esReceiver;
    }

    @Override
    @Nullable
    public ESExpression visitLambda(@NotNull ESValue lambda) {
        Intrinsics.checkNotNullParameter(lambda, "lambda");
        return null;
    }
}

