/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.model.visitors;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.model.Computation;
import org.jetbrains.kotlin.contracts.model.ESExpressionVisitor;
import org.jetbrains.kotlin.contracts.model.ESTypeSubstitution;
import org.jetbrains.kotlin.contracts.model.ESValue;
import org.jetbrains.kotlin.contracts.model.structure.CallComputation;
import org.jetbrains.kotlin.contracts.model.structure.ESAnd;
import org.jetbrains.kotlin.contracts.model.structure.ESBooleanType;
import org.jetbrains.kotlin.contracts.model.structure.ESConstant;
import org.jetbrains.kotlin.contracts.model.structure.ESEqual;
import org.jetbrains.kotlin.contracts.model.structure.ESIs;
import org.jetbrains.kotlin.contracts.model.structure.ESNot;
import org.jetbrains.kotlin.contracts.model.structure.ESOr;
import org.jetbrains.kotlin.contracts.model.structure.ESReceiver;
import org.jetbrains.kotlin.contracts.model.structure.ESVariable;
import org.jetbrains.kotlin.contracts.model.visitors.Reducer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B+\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\fH\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u0010H\u0017\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0019\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u0014H\u0017\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0019\u001a\u00020\u0018H\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0019\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001d\u001a\u00020\u001cH\u0017\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u0004H\u0017\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010%\u001a\u00020\u00022\u0006\u0010$\u001a\u00020#H\u0017\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010)\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0017\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010-\u001a\u00020\u00022\u0006\u0010,\u001a\u00020+H\u0017\u00a2\u0006\u0004\b-\u0010.R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010/R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00100R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u00101"}, d2={"Lorg/jetbrains/kotlin/contracts/model/visitors/Substitutor;", "Lorg/jetbrains/kotlin/contracts/model/ESExpressionVisitor;", "Lorg/jetbrains/kotlin/contracts/model/Computation;", "", "Lorg/jetbrains/kotlin/contracts/model/structure/ESVariable;", "substitutions", "Lorg/jetbrains/kotlin/contracts/model/ESTypeSubstitution;", "typeSubstitution", "Lorg/jetbrains/kotlin/contracts/model/visitors/Reducer;", "reducer", "<init>", "(Ljava/util/Map;Lorg/jetbrains/kotlin/contracts/model/ESTypeSubstitution;Lorg/jetbrains/kotlin/contracts/model/visitors/Reducer;)V", "Lorg/jetbrains/kotlin/contracts/model/structure/ESIs;", "isOperator", "visitIs", "(Lorg/jetbrains/kotlin/contracts/model/structure/ESIs;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "Lorg/jetbrains/kotlin/contracts/model/structure/ESNot;", "not", "visitNot", "(Lorg/jetbrains/kotlin/contracts/model/structure/ESNot;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "Lorg/jetbrains/kotlin/contracts/model/structure/ESEqual;", "equal", "visitEqual", "(Lorg/jetbrains/kotlin/contracts/model/structure/ESEqual;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "Lorg/jetbrains/kotlin/contracts/model/structure/ESAnd;", "and", "visitAnd", "(Lorg/jetbrains/kotlin/contracts/model/structure/ESAnd;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "Lorg/jetbrains/kotlin/contracts/model/structure/ESOr;", "or", "visitOr", "(Lorg/jetbrains/kotlin/contracts/model/structure/ESOr;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "esVariable", "visitVariable", "(Lorg/jetbrains/kotlin/contracts/model/structure/ESVariable;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;", "esConstant", "visitConstant", "(Lorg/jetbrains/kotlin/contracts/model/structure/ESConstant;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "Lorg/jetbrains/kotlin/contracts/model/structure/ESReceiver;", "esReceiver", "visitReceiver", "(Lorg/jetbrains/kotlin/contracts/model/structure/ESReceiver;)Lorg/jetbrains/kotlin/contracts/model/structure/ESReceiver;", "Lorg/jetbrains/kotlin/contracts/model/ESValue;", "lambda", "visitLambda", "(Lorg/jetbrains/kotlin/contracts/model/ESValue;)Lorg/jetbrains/kotlin/contracts/model/Computation;", "Ljava/util/Map;", "Lorg/jetbrains/kotlin/contracts/model/ESTypeSubstitution;", "Lorg/jetbrains/kotlin/contracts/model/visitors/Reducer;"})
public final class Substitutor
implements ESExpressionVisitor<Computation> {
    @NotNull
    private final Map<ESVariable, Computation> substitutions;
    @NotNull
    private final ESTypeSubstitution typeSubstitution;
    @NotNull
    private final Reducer reducer;

    public Substitutor(@NotNull Map<ESVariable, ? extends Computation> substitutions, @NotNull ESTypeSubstitution typeSubstitution, @NotNull Reducer reducer) {
        Intrinsics.checkNotNullParameter(substitutions, "substitutions");
        Intrinsics.checkNotNullParameter(typeSubstitution, "typeSubstitution");
        Intrinsics.checkNotNullParameter(reducer, "reducer");
        this.substitutions = substitutions;
        this.typeSubstitution = typeSubstitution;
        this.reducer = reducer;
    }

    @Override
    @Nullable
    public Computation visitIs(@NotNull ESIs isOperator) {
        Intrinsics.checkNotNullParameter(isOperator, "isOperator");
        Computation computation = (Computation)isOperator.getLeft().accept(this);
        if (computation == null) {
            return null;
        }
        Computation arg = computation;
        return new CallComputation(ESBooleanType.INSTANCE, isOperator.getFunctor().invokeWithArguments(arg, this.typeSubstitution));
    }

    @Override
    @Nullable
    public Computation visitNot(@NotNull ESNot not) {
        Intrinsics.checkNotNullParameter(not, "not");
        Computation computation = (Computation)not.getArg().accept(this);
        if (computation == null) {
            return null;
        }
        Computation arg = computation;
        return new CallComputation(ESBooleanType.INSTANCE, not.getFunctor().invokeWithArguments(arg));
    }

    @Override
    @Nullable
    public Computation visitEqual(@NotNull ESEqual equal) {
        Intrinsics.checkNotNullParameter(equal, "equal");
        Computation computation = (Computation)equal.getLeft().accept(this);
        if (computation == null) {
            return null;
        }
        Computation left = computation;
        Computation computation2 = (Computation)equal.getRight().accept(this);
        if (computation2 == null) {
            return null;
        }
        Computation right = computation2;
        Computation[] computationArray = new Computation[]{left, right};
        return new CallComputation(ESBooleanType.INSTANCE, equal.getFunctor().invokeWithArguments(CollectionsKt.listOf(computationArray), this.typeSubstitution, this.reducer));
    }

    @Override
    @Nullable
    public Computation visitAnd(@NotNull ESAnd and2) {
        Intrinsics.checkNotNullParameter(and2, "and");
        Computation computation = (Computation)and2.getLeft().accept(this);
        if (computation == null) {
            return null;
        }
        Computation left = computation;
        Computation computation2 = (Computation)and2.getRight().accept(this);
        if (computation2 == null) {
            return null;
        }
        Computation right = computation2;
        return new CallComputation(ESBooleanType.INSTANCE, and2.getFunctor().invokeWithArguments(left, right));
    }

    @Override
    @Nullable
    public Computation visitOr(@NotNull ESOr or2) {
        Intrinsics.checkNotNullParameter(or2, "or");
        Computation computation = (Computation)or2.getLeft().accept(this);
        if (computation == null) {
            return null;
        }
        Computation left = computation;
        Computation computation2 = (Computation)or2.getRight().accept(this);
        if (computation2 == null) {
            return null;
        }
        Computation right = computation2;
        return new CallComputation(ESBooleanType.INSTANCE, or2.getFunctor().invokeWithArguments(left, right));
    }

    @Override
    @NotNull
    public Computation visitVariable(@NotNull ESVariable esVariable) {
        Intrinsics.checkNotNullParameter(esVariable, "esVariable");
        Computation computation = this.substitutions.get(esVariable);
        if (computation == null) {
            computation = esVariable;
        }
        return computation;
    }

    @Override
    @NotNull
    public Computation visitConstant(@NotNull ESConstant esConstant) {
        Intrinsics.checkNotNullParameter(esConstant, "esConstant");
        return esConstant;
    }

    @Override
    @NotNull
    public ESReceiver visitReceiver(@NotNull ESReceiver esReceiver) {
        Intrinsics.checkNotNullParameter(esReceiver, "esReceiver");
        return esReceiver;
    }

    @Override
    @NotNull
    public Computation visitLambda(@NotNull ESValue lambda) {
        Intrinsics.checkNotNullParameter(lambda, "lambda");
        return lambda;
    }
}

