/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.parsing;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.LazyContractProvider;
import org.jetbrains.kotlin.contracts.parsing.ContractCallContext;
import org.jetbrains.kotlin.contracts.parsing.ContractParsingDiagnosticsCollector;
import org.jetbrains.kotlin.contracts.parsing.PsiContractParserDispatcher;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.contracts.parsing.TraceBasedCollector;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0013\u0010\u0013\u001a\u00020\u0012*\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0019\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0015\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001b\u0010\u0013\u001a\u00020\u0012*\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u001fR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010 \u001a\u0004\b!\u0010\"R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010#"}, d2={"Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingServices;", "", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "Lorg/jetbrains/kotlin/storage/StorageManager;", "storageManager", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "ownerDescriptor", "", "checkContractAndRecordIfPresent", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;", "", "isContractDescriptionCallPreciseCheck", "(Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;)Z", "callContext", "Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "parseContractAndReportErrors", "(Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;)Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingDiagnosticsCollector;", "collector", "checkFeatureEnabled", "(Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingDiagnosticsCollector;)V", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "context", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/BindingContext;)Z", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "Lorg/jetbrains/kotlin/storage/StorageManager;"})
public final class ContractParsingServices {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final StorageManager storageManager;

    public ContractParsingServices(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull StorageManager storageManager) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        this.languageVersionSettings = languageVersionSettings;
        this.storageManager = storageManager;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkContractAndRecordIfPresent(@NotNull KtExpression expression, @NotNull BindingTrace trace, @NotNull FunctionDescriptor ownerDescriptor) {
        ContractDescription resultingContractDescription;
        LazyContractProvider contractProviderIfAny;
        ContractCallContext callContext;
        block7: {
            LazyContractProvider lazyContractProvider;
            Intrinsics.checkNotNullParameter(expression, "expression");
            Intrinsics.checkNotNullParameter(trace, "trace");
            Intrinsics.checkNotNullParameter(ownerDescriptor, "ownerDescriptor");
            if (!KtPsiUtilKt.isContractDescriptionCallPsiCheck(expression)) {
                return;
            }
            callContext = new ContractCallContext(expression, ownerDescriptor, trace, this.languageVersionSettings);
            Object v = ownerDescriptor.getUserData(ContractProviderKey.INSTANCE);
            contractProviderIfAny = v instanceof LazyContractProvider ? (LazyContractProvider)v : null;
            resultingContractDescription = null;
            try {
                if (this.isContractDescriptionCallPreciseCheck(callContext)) break block7;
                lazyContractProvider = contractProviderIfAny;
            }
            catch (Throwable throwable) {
                LazyContractProvider lazyContractProvider2 = contractProviderIfAny;
                if (lazyContractProvider2 != null) {
                    lazyContractProvider2.setContractDescription(resultingContractDescription);
                }
                throw throwable;
            }
            if (lazyContractProvider != null) {
                lazyContractProvider.setContractDescription(resultingContractDescription);
            }
            return;
        }
        resultingContractDescription = this.parseContractAndReportErrors(callContext);
        LazyContractProvider lazyContractProvider = contractProviderIfAny;
        if (lazyContractProvider != null) {
            lazyContractProvider.setContractDescription(resultingContractDescription);
        }
    }

    private final boolean isContractDescriptionCallPreciseCheck(ContractCallContext $this$isContractDescriptionCallPreciseCheck) {
        return this.isContractDescriptionCallPreciseCheck($this$isContractDescriptionCallPreciseCheck.getContractCallExpression(), $this$isContractDescriptionCallPreciseCheck.getBindingContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ContractDescription parseContractAndReportErrors(ContractCallContext callContext) {
        TraceBasedCollector collector2 = new TraceBasedCollector(callContext);
        try {
            ContractDescription contractDescription;
            ContractDescription contractDescription2;
            this.checkFeatureEnabled(collector2);
            boolean contractNotAllowed = Intrinsics.areEqual(callContext.getBindingContext().get(BindingContext.CONTRACT_NOT_ALLOWED, callContext.getContractCallExpression()), true);
            if (collector2.hasErrors() || contractNotAllowed) {
                ContractDescription contractDescription3 = null;
                return contractDescription3;
            }
            ContractDescription parsedContract = new PsiContractParserDispatcher(collector2, callContext, this.storageManager).parseContract();
            if (parsedContract == null) {
                collector2.addFallbackErrorIfNecessary();
            }
            ContractDescription contractDescription4 = parsedContract;
            if (contractDescription4 != null) {
                ContractDescription it = contractDescription2 = contractDescription4;
                boolean bl = false;
                contractDescription = !collector2.hasErrors() ? contractDescription2 : null;
            } else {
                contractDescription = null;
            }
            contractDescription2 = contractDescription;
            return contractDescription2;
        }
        finally {
            collector2.flushDiagnostics();
        }
    }

    private final void checkFeatureEnabled(ContractParsingDiagnosticsCollector collector2) {
        boolean isFeatureTurnedOn = this.languageVersionSettings.supportsFeature(LanguageFeature.AllowContractsForCustomFunctions);
        if (!isFeatureTurnedOn) {
            collector2.unsupportedFeature(this.languageVersionSettings);
        }
    }

    private final boolean isContractDescriptionCallPreciseCheck(KtExpression $this$isContractDescriptionCallPreciseCheck, BindingContext context) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($this$isContractDescriptionCallPreciseCheck, context);
        return resolvedCall2 != null && (resolvedCall2 = resolvedCall2.getResultingDescriptor()) != null ? PsiContractsUtilsKt.isContractCallDescriptor((DeclarationDescriptor)((Object)resolvedCall2)) : false;
    }
}

