/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.parsing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.contracts.description.BooleanExpression;
import org.jetbrains.kotlin.contracts.description.CallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanVariableReference;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.ContractDescriptionValue;
import org.jetbrains.kotlin.contracts.description.expressions.VariableReference;
import org.jetbrains.kotlin.contracts.parsing.ContractCallContext;
import org.jetbrains.kotlin.contracts.parsing.ContractParsingDiagnosticsCollector;
import org.jetbrains.kotlin.contracts.parsing.ContractsDslNames;
import org.jetbrains.kotlin.contracts.parsing.PsiConditionParser;
import org.jetbrains.kotlin.contracts.parsing.PsiConstantParser;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.contracts.parsing.PsiEffectParser;
import org.jetbrains.kotlin.contracts.parsing.effects.PsiCallsEffectParser;
import org.jetbrains.kotlin.contracts.parsing.effects.PsiConditionalEffectParser;
import org.jetbrains.kotlin.contracts.parsing.effects.PsiReturnsEffectParser;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0011\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J+\u0010\u0019\u001a\u00020\u00182\u001a\u0010\u0017\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\r0\u00160\u0015H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001b\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0004\b\u001f\u0010 J\u001b\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0004\b\"\u0010#J\u001b\u0010%\u001a\u0004\u0018\u00010$2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0004\b%\u0010&R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010'R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010(R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010)R\u0014\u0010+\u001a\u00020*8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0014\u0010.\u001a\u00020-8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R \u00103\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u000202008\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104"}, d2={"Lorg/jetbrains/kotlin/contracts/parsing/PsiContractParserDispatcher;", "", "Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingDiagnosticsCollector;", "collector", "Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;", "callContext", "Lorg/jetbrains/kotlin/storage/StorageManager;", "storageManager", "<init>", "(Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingDiagnosticsCollector;Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "parseContract", "()Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "parseCondition", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "Lorg/jetbrains/kotlin/contracts/description/EffectDeclaration;", "parseEffect", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/contracts/description/EffectDeclaration;", "", "Lkotlin/Pair;", "effects", "", "checkDuplicatedCallsEffectsAndReport", "(Ljava/util/List;)V", "", "isValidEffectDeclaration", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Z", "Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "parseConstant", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "Lorg/jetbrains/kotlin/contracts/description/expressions/VariableReference;", "parseVariable", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/contracts/description/expressions/VariableReference;", "Lorg/jetbrains/kotlin/contracts/description/expressions/ContractDescriptionValue;", "parseValue", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/contracts/description/expressions/ContractDescriptionValue;", "Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingDiagnosticsCollector;", "Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;", "Lorg/jetbrains/kotlin/storage/StorageManager;", "Lorg/jetbrains/kotlin/contracts/parsing/PsiConditionParser;", "conditionParser", "Lorg/jetbrains/kotlin/contracts/parsing/PsiConditionParser;", "Lorg/jetbrains/kotlin/contracts/parsing/PsiConstantParser;", "constantParser", "Lorg/jetbrains/kotlin/contracts/parsing/PsiConstantParser;", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/contracts/parsing/PsiEffectParser;", "effectsParsers", "Ljava/util/Map;"})
public final class PsiContractParserDispatcher {
    @NotNull
    private final ContractParsingDiagnosticsCollector collector;
    @NotNull
    private final ContractCallContext callContext;
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final PsiConditionParser conditionParser;
    @NotNull
    private final PsiConstantParser constantParser;
    @NotNull
    private final Map<Name, PsiEffectParser> effectsParsers;

    public PsiContractParserDispatcher(@NotNull ContractParsingDiagnosticsCollector collector2, @NotNull ContractCallContext callContext, @NotNull StorageManager storageManager) {
        Intrinsics.checkNotNullParameter(collector2, "collector");
        Intrinsics.checkNotNullParameter(callContext, "callContext");
        Intrinsics.checkNotNullParameter(storageManager, "storageManager");
        this.collector = collector2;
        this.callContext = callContext;
        this.storageManager = storageManager;
        this.conditionParser = new PsiConditionParser(this.collector, this.callContext, this);
        this.constantParser = new PsiConstantParser(this.callContext);
        Pair[] pairArray = new Pair[]{TuplesKt.to(ContractsDslNames.INSTANCE.getRETURNS_EFFECT(), new PsiReturnsEffectParser(this.collector, this.callContext, this)), TuplesKt.to(ContractsDslNames.INSTANCE.getRETURNS_NOT_NULL_EFFECT(), new PsiReturnsEffectParser(this.collector, this.callContext, this)), TuplesKt.to(ContractsDslNames.INSTANCE.getCALLS_IN_PLACE_EFFECT(), new PsiCallsEffectParser(this.collector, this.callContext, this)), TuplesKt.to(ContractsDslNames.INSTANCE.getCONDITIONAL_EFFECT(), new PsiConditionalEffectParser(this.collector, this.callContext, this))};
        this.effectsParsers = MapsKt.mapOf(pairArray);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ContractDescription parseContract() {
        void $this$mapNotNullTo$iv$iv;
        Collection destination$iv$iv;
        Iterable $this$map$iv;
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(this.callContext.getContractCallExpression(), this.callContext.getBindingContext());
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        KtExpression firstArgumentExpression = PsiContractsUtilsKt.firstArgumentAsExpressionOrNull(resolvedCall3);
        if (!(firstArgumentExpression instanceof KtLambdaExpression)) {
            KtExpression ktExpression = firstArgumentExpression;
            if (ktExpression == null) {
                ktExpression = this.callContext.getContractCallExpression();
            }
            KtExpression reportOn = ktExpression;
            this.collector.badDescription("first argument of 'contract'-call should be a lambda expression", reportOn);
            return null;
        }
        KtLambdaExpression lambda = (KtLambdaExpression)firstArgumentExpression;
        Object object = lambda.getBodyExpression();
        if (object != null && (object = ((KtBlockExpression)object).getStatements()) != null) {
            void $this$mapTo$iv$iv;
            $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtExpression ktExpression = (KtExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to(this.parseEffect((KtExpression)it), it));
            }
        } else {
            return null;
        }
        List effectsWithExpression = (List)destination$iv$iv;
        this.checkDuplicatedCallsEffectsAndReport(effectsWithExpression);
        Iterable $this$mapNotNull$iv = effectsWithExpression;
        boolean $i$f$mapNotNull = false;
        $this$map$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            EffectDeclaration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Pair it = (Pair)element$iv$iv;
            boolean bl2 = false;
            if ((EffectDeclaration)it.getFirst() == null) continue;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List effects = (List)destination$iv$iv2;
        if (effects.isEmpty()) {
            return null;
        }
        return new ContractDescription(effects, this.callContext.getFunctionDescriptor(), this.storageManager);
    }

    @Nullable
    public final BooleanExpression parseCondition(@Nullable KtExpression expression) {
        KtExpression ktExpression = expression;
        return ktExpression != null ? (BooleanExpression)ktExpression.accept(this.conditionParser, Unit.INSTANCE) : null;
    }

    @Nullable
    public final EffectDeclaration parseEffect(@Nullable KtExpression expression) {
        if (expression == null) {
            return null;
        }
        if (!this.isValidEffectDeclaration(expression)) {
            return null;
        }
        KotlinType kotlinType = CallUtilKt.getType(expression, this.callContext.getBindingContext());
        if (kotlinType == null) {
            return null;
        }
        KotlinType returnType = kotlinType;
        Map<Name, PsiEffectParser> map2 = this.effectsParsers;
        ClassifierDescriptor classifierDescriptor = returnType.getConstructor().getDeclarationDescriptor();
        PsiEffectParser parser = map2.get(classifierDescriptor != null ? classifierDescriptor.getName() : null);
        if (parser == null) {
            this.collector.badDescription("unrecognized effect", expression);
            return null;
        }
        return parser.tryParseEffect(expression);
    }

    private final void checkDuplicatedCallsEffectsAndReport(List<? extends Pair<? extends EffectDeclaration, ? extends KtExpression>> effects) {
        Set descriptorsWithCallsEffect = new LinkedHashSet();
        for (Pair<? extends EffectDeclaration, ? extends KtExpression> pair : effects) {
            EffectDeclaration effect = pair.component1();
            KtExpression expression = pair.component2();
            if (!(effect instanceof CallsEffectDeclaration)) continue;
            ParameterDescriptor descriptor2 = ((CallsEffectDeclaration)effect).getVariableReference().getDescriptor();
            if (descriptorsWithCallsEffect.contains(descriptor2)) {
                this.collector.badDescription("Duplicated contract for " + descriptor2.getName() + ". Only one `callsInPlace` contract per parameter is allowed.", expression);
                continue;
            }
            descriptorsWithCallsEffect.add(descriptor2);
        }
    }

    private final boolean isValidEffectDeclaration(KtExpression expression) {
        if (!(expression instanceof KtCallExpression) && !(expression instanceof KtBinaryExpression)) {
            this.collector.badDescription("unexpected construction in contract description", expression);
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression, this.callContext.getBindingContext());
        if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resultingDescriptor = resolvedCall2;
        if (!PsiContractsUtilsKt.isFromContractDsl((DeclarationDescriptor)((Object)resultingDescriptor))) {
            this.collector.badDescription("effects can be produced only by direct calls to ContractsDSL", expression);
            return false;
        }
        return true;
    }

    @Nullable
    public final ConstantReference parseConstant(@Nullable KtExpression expression) {
        if (expression == null) {
            return null;
        }
        return (ConstantReference)expression.accept(this.constantParser, Unit.INSTANCE);
    }

    @Nullable
    public final VariableReference parseVariable(@Nullable KtExpression expression) {
        CallableDescriptor descriptor2;
        if (expression == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression, this.callContext.getBindingContext());
        CallableDescriptor callableDescriptor = descriptor2 = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
        if (!(descriptor2 instanceof ParameterDescriptor)) {
            if (!(expression instanceof KtConstantExpression)) {
                this.collector.badDescription("only references to parameters are allowed in contract description", expression);
            }
            return null;
        }
        if (descriptor2 instanceof ReceiverParameterDescriptor) {
            ReceiverParameterDescriptor directReceiver;
            ClassifierDescriptor classifierDescriptor = ((ReceiverParameterDescriptor)descriptor2).getType().getConstructor().getDeclarationDescriptor();
            boolean bl = classifierDescriptor != null ? PsiContractsUtilsKt.isFromContractDsl(classifierDescriptor) : false;
            if (bl) {
                this.collector.badDescription("only references to parameters are allowed. Did you miss label on <this>?", expression);
                return null;
            }
            FunctionDescriptor it = this.callContext.getFunctionDescriptor();
            boolean bl2 = false;
            ReceiverParameterDescriptor receiverParameterDescriptor = it.getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null) {
                receiverParameterDescriptor = it.getDispatchReceiverParameter();
            }
            if (!Intrinsics.areEqual(descriptor2, directReceiver = receiverParameterDescriptor)) {
                this.collector.badDescription("only references to direct <this> are allowed", expression);
                return null;
            }
        }
        return KotlinBuiltIns.isBoolean(((ParameterDescriptor)descriptor2).getType()) ? (VariableReference)new BooleanVariableReference((ParameterDescriptor)descriptor2) : new VariableReference((ParameterDescriptor)descriptor2);
    }

    @Nullable
    public final ContractDescriptionValue parseValue(@Nullable KtExpression expression) {
        VariableReference variable = this.parseVariable(expression);
        if (variable != null) {
            return variable;
        }
        return this.parseConstant(expression);
    }
}

