/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.parsing;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.parsing.ContractCallContext;
import org.jetbrains.kotlin.contracts.parsing.ContractParsingDiagnosticsCollector;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0012\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u000f\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001eR\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$"}, d2={"Lorg/jetbrains/kotlin/contracts/parsing/TraceBasedCollector;", "Lorg/jetbrains/kotlin/contracts/parsing/ContractParsingDiagnosticsCollector;", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "bindingTrace", "Lorg/jetbrains/kotlin/psi/KtExpression;", "mainCall", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;", "callContext", "(Lorg/jetbrains/kotlin/contracts/parsing/ContractCallContext;)V", "", "message", "", "contractNotAllowed", "(Ljava/lang/String;)V", "Lorg/jetbrains/kotlin/psi/KtElement;", "reportOn", "badDescription", "(Ljava/lang/String;Lorg/jetbrains/kotlin/psi/KtElement;)V", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "unsupportedFeature", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "addFallbackErrorIfNecessary", "()V", "flushDiagnostics", "", "hasErrors", "()Z", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "reportedErrors", "Ljava/util/List;", "mainCallReportTarget", "Lorg/jetbrains/kotlin/psi/KtExpression;"})
public final class TraceBasedCollector
implements ContractParsingDiagnosticsCollector {
    @NotNull
    private final BindingTrace bindingTrace;
    @NotNull
    private final List<Diagnostic> reportedErrors;
    @NotNull
    private final KtExpression mainCallReportTarget;

    public TraceBasedCollector(@NotNull BindingTrace bindingTrace, @NotNull KtExpression mainCall) {
        Intrinsics.checkNotNullParameter(bindingTrace, "bindingTrace");
        Intrinsics.checkNotNullParameter(mainCall, "mainCall");
        this.bindingTrace = bindingTrace;
        this.reportedErrors = new ArrayList();
        KtExpression ktExpression = mainCall instanceof KtCallExpression ? (KtCallExpression)mainCall : null;
        if (ktExpression == null || (ktExpression = ktExpression.getCalleeExpression()) == null) {
            ktExpression = mainCall;
        }
        this.mainCallReportTarget = ktExpression;
    }

    public TraceBasedCollector(@NotNull ContractCallContext callContext) {
        Intrinsics.checkNotNullParameter(callContext, "callContext");
        this(callContext.getTrace(), callContext.getContractCallExpression());
    }

    @Override
    public void contractNotAllowed(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        ((Collection)this.reportedErrors).add(Errors.CONTRACT_NOT_ALLOWED.on((KtElement)((PsiElement)this.mainCallReportTarget), message));
    }

    @Override
    public void badDescription(@NotNull String message, @NotNull KtElement reportOn) {
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        ((Collection)this.reportedErrors).add(Errors.ERROR_IN_CONTRACT_DESCRIPTION.on((KtElement)((PsiElement)reportOn), message));
    }

    @Override
    public void unsupportedFeature(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        ((Collection)this.reportedErrors).add(Errors.UNSUPPORTED_FEATURE.on(this.mainCallReportTarget, TuplesKt.to(LanguageFeature.AllowContractsForCustomFunctions, languageVersionSettings)));
    }

    @Override
    public void addFallbackErrorIfNecessary() {
        if (this.reportedErrors.isEmpty()) {
            ((Collection)this.reportedErrors).add(Errors.ERROR_IN_CONTRACT_DESCRIPTION.on((KtElement)((PsiElement)this.mainCallReportTarget), "Error in contract description"));
        }
    }

    @Override
    public void flushDiagnostics() {
        Iterable $this$forEach$iv = this.reportedErrors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Diagnostic it = (Diagnostic)element$iv;
            boolean bl = false;
            this.bindingTrace.report(it);
        }
    }

    @Override
    public boolean hasErrors() {
        return !((Collection)this.reportedErrors).isEmpty();
    }
}

