/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibility;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001:\t\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ!\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0001\u00a2\u0006\u0004\b\n\u0010\tJ\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fR \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u00108\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0014\u001a\u00020\u00138\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017"}, d2={"Lorg/jetbrains/kotlin/descriptors/Visibilities;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "first", "second", "", "compare", "(Lorg/jetbrains/kotlin/descriptors/Visibility;Lorg/jetbrains/kotlin/descriptors/Visibility;)Ljava/lang/Integer;", "compareLocal$compiler_common", "compareLocal", "visibility", "", "isPrivate", "(Lorg/jetbrains/kotlin/descriptors/Visibility;)Z", "", "ORDERED_VISIBILITIES", "Ljava/util/Map;", "Lorg/jetbrains/kotlin/descriptors/Visibilities$Public;", "DEFAULT_VISIBILITY", "Lorg/jetbrains/kotlin/descriptors/Visibilities$Public;", "getDEFAULT_VISIBILITY", "()Lorg/jetbrains/kotlin/descriptors/Visibilities$Public;", "Private", "PrivateToThis", "Protected", "Internal", "Public", "Local", "Inherited", "InvisibleFake", "Unknown"})
public final class Visibilities {
    @NotNull
    public static final Visibilities INSTANCE;
    @NotNull
    private static final Map<Visibility, Integer> ORDERED_VISIBILITIES;
    @NotNull
    private static final Public DEFAULT_VISIBILITY;

    private Visibilities() {
    }

    @Nullable
    public final Integer compare(@NotNull Visibility first2, @NotNull Visibility second2) {
        Intrinsics.checkNotNullParameter(first2, "first");
        Intrinsics.checkNotNullParameter(second2, "second");
        Integer result2 = first2.compareTo(second2);
        if (result2 != null) {
            return result2;
        }
        Integer oppositeResult = second2.compareTo(first2);
        return oppositeResult != null ? Integer.valueOf(-oppositeResult.intValue()) : null;
    }

    @Nullable
    public final Integer compareLocal$compiler_common(@NotNull Visibility first2, @NotNull Visibility second2) {
        Intrinsics.checkNotNullParameter(first2, "first");
        Intrinsics.checkNotNullParameter(second2, "second");
        if (first2 == second2) {
            return 0;
        }
        Integer firstIndex = ORDERED_VISIBILITIES.get(first2);
        Integer secondIndex = ORDERED_VISIBILITIES.get(second2);
        return firstIndex == null || secondIndex == null || Intrinsics.areEqual(firstIndex, secondIndex) ? null : Integer.valueOf(firstIndex - secondIndex);
    }

    public final boolean isPrivate(@NotNull Visibility visibility) {
        Intrinsics.checkNotNullParameter(visibility, "visibility");
        return visibility == Private.INSTANCE || visibility == PrivateToThis.INSTANCE;
    }

    @NotNull
    public final Public getDEFAULT_VISIBILITY() {
        return DEFAULT_VISIBILITY;
    }

    static {
        Map<Visibility, Integer> map2;
        INSTANCE = new Visibilities();
        Map<Visibility, Integer> $this$ORDERED_VISIBILITIES_u24lambda_u240 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        $this$ORDERED_VISIBILITIES_u24lambda_u240.put(PrivateToThis.INSTANCE, 0);
        $this$ORDERED_VISIBILITIES_u24lambda_u240.put(Private.INSTANCE, 0);
        $this$ORDERED_VISIBILITIES_u24lambda_u240.put(Internal.INSTANCE, 1);
        $this$ORDERED_VISIBILITIES_u24lambda_u240.put(Protected.INSTANCE, 1);
        $this$ORDERED_VISIBILITIES_u24lambda_u240.put(Public.INSTANCE, 2);
        ORDERED_VISIBILITIES = MapsKt.build(map2);
        DEFAULT_VISIBILITY = Public.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006"}, d2={"Lorg/jetbrains/kotlin/descriptors/Visibilities$Inherited;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "<init>", "()V", "", "mustCheckInImports", "()Z"})
    public static final class Inherited
    extends Visibility {
        @NotNull
        public static final Inherited INSTANCE = new Inherited();

        private Inherited() {
            super("inherited", false);
        }

        @Override
        public boolean mustCheckInImports() {
            throw new IllegalStateException("This method shouldn't be invoked for INHERITED visibility");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006"}, d2={"Lorg/jetbrains/kotlin/descriptors/Visibilities$Internal;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "<init>", "()V", "", "mustCheckInImports", "()Z"})
    public static final class Internal
    extends Visibility {
        @NotNull
        public static final Internal INSTANCE = new Internal();

        private Internal() {
            super("internal", false);
        }

        @Override
        public boolean mustCheckInImports() {
            return true;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\n\u001a\u00020\u00078WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t"}, d2={"Lorg/jetbrains/kotlin/descriptors/Visibilities$InvisibleFake;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "<init>", "()V", "", "mustCheckInImports", "()Z", "", "getExternalDisplayName", "()Ljava/lang/String;", "externalDisplayName"})
    public static final class InvisibleFake
    extends Visibility {
        @NotNull
        public static final InvisibleFake INSTANCE = new InvisibleFake();

        private InvisibleFake() {
            super("invisible_fake", false);
        }

        @Override
        public boolean mustCheckInImports() {
            return true;
        }

        @Override
        @NotNull
        public String getExternalDisplayName() {
            return "invisible (private in a supertype)";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006"}, d2={"Lorg/jetbrains/kotlin/descriptors/Visibilities$Local;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "<init>", "()V", "", "mustCheckInImports", "()Z"})
    public static final class Local
    extends Visibility {
        @NotNull
        public static final Local INSTANCE = new Local();

        private Local() {
            super("local", false);
        }

        @Override
        public boolean mustCheckInImports() {
            return true;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006"}, d2={"Lorg/jetbrains/kotlin/descriptors/Visibilities$Private;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "<init>", "()V", "", "mustCheckInImports", "()Z"})
    public static final class Private
    extends Visibility {
        @NotNull
        public static final Private INSTANCE = new Private();

        private Private() {
            super("private", false);
        }

        @Override
        public boolean mustCheckInImports() {
            return true;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\n\u001a\u00020\u00078WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t"}, d2={"Lorg/jetbrains/kotlin/descriptors/Visibilities$PrivateToThis;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "<init>", "()V", "", "mustCheckInImports", "()Z", "", "getInternalDisplayName", "()Ljava/lang/String;", "internalDisplayName"})
    public static final class PrivateToThis
    extends Visibility {
        @NotNull
        public static final PrivateToThis INSTANCE = new PrivateToThis();

        private PrivateToThis() {
            super("private_to_this", false);
        }

        @Override
        @NotNull
        public String getInternalDisplayName() {
            return "private/*private to this*/";
        }

        @Override
        public boolean mustCheckInImports() {
            return true;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006"}, d2={"Lorg/jetbrains/kotlin/descriptors/Visibilities$Protected;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "<init>", "()V", "", "mustCheckInImports", "()Z"})
    public static final class Protected
    extends Visibility {
        @NotNull
        public static final Protected INSTANCE = new Protected();

        private Protected() {
            super("protected", true);
        }

        @Override
        public boolean mustCheckInImports() {
            return false;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006"}, d2={"Lorg/jetbrains/kotlin/descriptors/Visibilities$Public;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "<init>", "()V", "", "mustCheckInImports", "()Z"})
    public static final class Public
    extends Visibility {
        @NotNull
        public static final Public INSTANCE = new Public();

        private Public() {
            super("public", true);
        }

        @Override
        public boolean mustCheckInImports() {
            return false;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006"}, d2={"Lorg/jetbrains/kotlin/descriptors/Visibilities$Unknown;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "<init>", "()V", "", "mustCheckInImports", "()Z"})
    public static final class Unknown
    extends Visibility {
        @NotNull
        public static final Unknown INSTANCE = new Unknown();

        private Unknown() {
            super("unknown", false);
        }

        @Override
        public boolean mustCheckInImports() {
            throw new IllegalStateException("This method shouldn't be invoked for UNKNOWN visibility");
        }
    }
}

