/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.java;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Lorg/jetbrains/kotlin/descriptors/java/JavaVisibilities;", "", "<init>", "()V", "PackageVisibility", "ProtectedStaticVisibility", "ProtectedAndPackage"})
public final class JavaVisibilities {
    @NotNull
    public static final JavaVisibilities INSTANCE = new JavaVisibilities();

    private JavaVisibilities() {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0001H\u0017\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0001H\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0011\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0018\u001a\u00020\u00158WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u00158WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017"}, d2={"Lorg/jetbrains/kotlin/descriptors/java/JavaVisibilities$PackageVisibility;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "<init>", "()V", "", "mustCheckInImports", "()Z", "visibility", "", "compareTo", "(Lorg/jetbrains/kotlin/descriptors/Visibility;)Ljava/lang/Integer;", "normalize", "()Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "customEffectiveVisibility", "()Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "Lorg/jetbrains/kotlin/name/FqName;", "fromPackage", "myPackage", "visibleFromPackage", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;)Z", "", "getInternalDisplayName", "()Ljava/lang/String;", "internalDisplayName", "getExternalDisplayName", "externalDisplayName"})
    public static final class PackageVisibility
    extends Visibility {
        @NotNull
        public static final PackageVisibility INSTANCE = new PackageVisibility();

        private PackageVisibility() {
            super("package", false);
        }

        @Override
        public boolean mustCheckInImports() {
            return true;
        }

        @Override
        @Nullable
        public Integer compareTo(@NotNull Visibility visibility) {
            Intrinsics.checkNotNullParameter(visibility, "visibility");
            if (this == visibility) {
                return 0;
            }
            if (Visibilities.INSTANCE.isPrivate(visibility)) {
                return 1;
            }
            return -1;
        }

        @Override
        @NotNull
        public Visibility normalize() {
            return Visibilities.Protected.INSTANCE;
        }

        @Override
        @NotNull
        public String getInternalDisplayName() {
            return "public/*package*/";
        }

        @Override
        @NotNull
        public String getExternalDisplayName() {
            return "package-private";
        }

        @Override
        @Nullable
        public EffectiveVisibility customEffectiveVisibility() {
            return EffectiveVisibility.PackagePrivate.INSTANCE;
        }

        @Override
        public boolean visibleFromPackage(@NotNull FqName fromPackage, @NotNull FqName myPackage) {
            Intrinsics.checkNotNullParameter(fromPackage, "fromPackage");
            Intrinsics.checkNotNullParameter(myPackage, "myPackage");
            return Intrinsics.areEqual(fromPackage, myPackage);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0004\u001a\u00020\u0001H\u0017\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0001H\u0017\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u0010\u001a\u00020\r8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\r8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/descriptors/java/JavaVisibilities$ProtectedAndPackage;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "<init>", "()V", "visibility", "", "compareTo", "(Lorg/jetbrains/kotlin/descriptors/Visibility;)Ljava/lang/Integer;", "normalize", "()Lorg/jetbrains/kotlin/descriptors/Visibility;", "", "mustCheckInImports", "()Z", "", "getInternalDisplayName", "()Ljava/lang/String;", "internalDisplayName", "getExternalDisplayName", "externalDisplayName"})
    public static final class ProtectedAndPackage
    extends Visibility {
        @NotNull
        public static final ProtectedAndPackage INSTANCE = new ProtectedAndPackage();

        private ProtectedAndPackage() {
            super("protected_and_package", true);
        }

        @Override
        @Nullable
        public Integer compareTo(@NotNull Visibility visibility) {
            Intrinsics.checkNotNullParameter(visibility, "visibility");
            if (Intrinsics.areEqual(this, visibility)) {
                return 0;
            }
            if (visibility == Visibilities.Internal.INSTANCE) {
                return null;
            }
            return Visibilities.INSTANCE.isPrivate(visibility) ? Integer.valueOf(1) : Integer.valueOf(-1);
        }

        @Override
        @NotNull
        public Visibility normalize() {
            return Visibilities.Protected.INSTANCE;
        }

        @Override
        public boolean mustCheckInImports() {
            return false;
        }

        @Override
        @NotNull
        public String getInternalDisplayName() {
            return "protected/*protected and package*/";
        }

        @Override
        @NotNull
        public String getExternalDisplayName() {
            return "protected";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0001H\u0017\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\f\u001a\u00020\t8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\t8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b"}, d2={"Lorg/jetbrains/kotlin/descriptors/java/JavaVisibilities$ProtectedStaticVisibility;", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "<init>", "()V", "", "mustCheckInImports", "()Z", "normalize", "()Lorg/jetbrains/kotlin/descriptors/Visibility;", "", "getInternalDisplayName", "()Ljava/lang/String;", "internalDisplayName", "getExternalDisplayName", "externalDisplayName"})
    public static final class ProtectedStaticVisibility
    extends Visibility {
        @NotNull
        public static final ProtectedStaticVisibility INSTANCE = new ProtectedStaticVisibility();

        private ProtectedStaticVisibility() {
            super("protected_static", true);
        }

        @Override
        public boolean mustCheckInImports() {
            return false;
        }

        @Override
        @NotNull
        public Visibility normalize() {
            return Visibilities.Protected.INSTANCE;
        }

        @Override
        @NotNull
        public String getInternalDisplayName() {
            return "protected/*protected static*/";
        }

        @Override
        @NotNull
        public String getExternalDisplayName() {
            return "protected";
        }
    }
}

