/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.runtime.structure;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.runtime.structure.Java16SealedRecordLoader;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectClassUtilKt;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaAnnotationOwner;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaClass;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaClassifierType;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaConstructor;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaElement;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaField;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaMethod;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaModifierListOwner;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaRecordComponent;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaRecordComponent;
import org.jetbrains.kotlin.load.java.structure.LightClassOriginKind;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0013\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\u000b\u001a\u0004\u0018\u00010\u00002\u0006\u0010\n\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0096\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\u001bH\u0017\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0018\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001eR\u0018\u0010!\u001a\u0006\u0012\u0002\b\u00030\u00058WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010#\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001aR\u0014\u0010$\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0013R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\t0%8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010,\u001a\u00020)8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0016\u0010/\u001a\u0004\u0018\u00010\u00008WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u001a\u00104\u001a\b\u0012\u0004\u0012\u000201008WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u001a\u00107\u001a\b\u0012\u0004\u0012\u0002050%8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010'R\u001a\u0010:\u001a\b\u0012\u0004\u0012\u0002080%8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010'R\u001a\u0010=\u001a\b\u0012\u0004\u0012\u00020;0%8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010'R\u0016\u0010A\u001a\u0004\u0018\u00010>8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0014\u0010\n\u001a\u00020\t8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u001a\u0010F\u001a\b\u0012\u0004\u0012\u00020D0%8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bE\u0010'R\u0014\u0010G\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010\u0013R\u0014\u0010H\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u0013R\u0014\u0010I\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010\u0013R\u0014\u0010J\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bJ\u0010\u0013R\u001a\u0010M\u001a\b\u0012\u0004\u0012\u00020K008WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u00103R\u0014\u0010N\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010\u0013R\u001a\u0010R\u001a\b\u0012\u0004\u0012\u0002010O8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010Q"}, d2={"Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaClass;", "Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaElement;", "Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaAnnotationOwner;", "Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaModifierListOwner;", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "Ljava/lang/Class;", "klass", "<init>", "(Ljava/lang/Class;)V", "Lorg/jetbrains/kotlin/name/Name;", "name", "findInnerClass", "(Lorg/jetbrains/kotlin/name/Name;)Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaClass;", "Ljava/lang/reflect/Method;", "method", "", "isEnumValuesOrValueOf", "(Ljava/lang/reflect/Method;)Z", "hasDefaultConstructor", "()Z", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/lang/Class;", "getElement", "()Ljava/lang/Class;", "element", "getModifiers", "modifiers", "isFromSource", "", "getInnerClassNames", "()Ljava/util/List;", "innerClassNames", "Lorg/jetbrains/kotlin/name/FqName;", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "fqName", "getOuterClass", "()Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaClass;", "outerClass", "", "Lorg/jetbrains/kotlin/load/java/structure/JavaClassifierType;", "getSupertypes", "()Ljava/util/Collection;", "supertypes", "Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaMethod;", "getMethods", "methods", "Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaField;", "getFields", "fields", "Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaConstructor;", "getConstructors", "constructors", "Lorg/jetbrains/kotlin/load/java/structure/LightClassOriginKind;", "getLightClassOriginKind", "()Lorg/jetbrains/kotlin/load/java/structure/LightClassOriginKind;", "lightClassOriginKind", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaTypeParameter;", "getTypeParameters", "typeParameters", "isInterface", "isAnnotationType", "isEnum", "isRecord", "Lorg/jetbrains/kotlin/load/java/structure/JavaRecordComponent;", "getRecordComponents", "recordComponents", "isSealed", "Lkotlin/sequences/Sequence;", "getPermittedTypes", "()Lkotlin/sequences/Sequence;", "permittedTypes"})
public final class ReflectJavaClass
extends ReflectJavaElement
implements ReflectJavaAnnotationOwner,
ReflectJavaModifierListOwner,
JavaClass {
    @NotNull
    private final Class<?> klass;

    public ReflectJavaClass(@NotNull Class<?> klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        this.klass = klass;
    }

    @Override
    @NotNull
    public Class<?> getElement() {
        return this.klass;
    }

    @Override
    public int getModifiers() {
        return this.klass.getModifiers();
    }

    @Override
    public boolean isFromSource() {
        return false;
    }

    @NotNull
    public List<Name> getInnerClassNames() {
        Class<?>[] classArray = this.klass.getDeclaredClasses();
        Intrinsics.checkNotNullExpressionValue(classArray, "getDeclaredClasses(...)");
        return SequencesKt.toList(SequencesKt.mapNotNull(SequencesKt.filterNot(ArraysKt.asSequence((Object[])classArray), ReflectJavaClass::_get_innerClassNames_$lambda$0), ReflectJavaClass::_get_innerClassNames_$lambda$2));
    }

    @Override
    @Nullable
    public ReflectJavaClass findInnerClass(@NotNull Name name) {
        ReflectJavaClass reflectJavaClass;
        Object object;
        block3: {
            Intrinsics.checkNotNullParameter(name, "name");
            Class<?>[] classArray = this.klass.getDeclaredClasses();
            Intrinsics.checkNotNullExpressionValue(classArray, "getDeclaredClasses(...)");
            Sequence<Object> $this$firstOrNull$iv = ArraysKt.asSequence((Object[])classArray);
            boolean $i$f$firstOrNull = false;
            Iterator<Object> iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                Class it = (Class)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getSimpleName(), name.asString())) continue;
                object = element$iv;
                break block3;
            }
            object = null;
        }
        Class clazz = (Class)object;
        if (clazz != null) {
            Class p0 = clazz;
            boolean bl = false;
            reflectJavaClass = new ReflectJavaClass(p0);
        } else {
            reflectJavaClass = null;
        }
        return reflectJavaClass;
    }

    @Override
    @NotNull
    public FqName getFqName() {
        return ReflectClassUtilKt.getClassId(this.klass).asSingleFqName();
    }

    @Override
    @Nullable
    public ReflectJavaClass getOuterClass() {
        ReflectJavaClass reflectJavaClass;
        Class<?> clazz = this.klass.getDeclaringClass();
        if (clazz != null) {
            Class<?> p0 = clazz;
            boolean bl = false;
            reflectJavaClass = new ReflectJavaClass(p0);
        } else {
            reflectJavaClass = null;
        }
        return reflectJavaClass;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<JavaClassifierType> getSupertypes() {
        void $this$mapTo$iv$iv;
        if (Intrinsics.areEqual(this.klass, Object.class)) {
            return CollectionsKt.emptyList();
        }
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        Type type2 = this.klass.getGenericSuperclass();
        if (type2 == null) {
            type2 = (Type)((Object)Object.class);
        }
        spreadBuilder.add(type2);
        spreadBuilder.addSpread(this.klass.getGenericInterfaces());
        Iterable $this$map$iv = CollectionsKt.listOf(spreadBuilder.toArray(new Type[spreadBuilder.size()]));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Type type3 = (Type)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ReflectJavaClassifierType((Type)p0));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<ReflectJavaMethod> getMethods() {
        Method[] methodArray = this.klass.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue(methodArray, "getDeclaredMethods(...)");
        return SequencesKt.toList(SequencesKt.map(SequencesKt.filter(ArraysKt.asSequence((Object[])methodArray), arg_0 -> ReflectJavaClass._get_methods_$lambda$7(this, arg_0)), methods.2.INSTANCE));
    }

    private final boolean isEnumValuesOrValueOf(Method method) {
        boolean bl;
        String string2 = method.getName();
        if (Intrinsics.areEqual(string2, "values")) {
            Class<?>[] classArray = method.getParameterTypes();
            Intrinsics.checkNotNullExpressionValue(classArray, "getParameterTypes(...)");
            bl = ((Object[])classArray).length == 0;
        } else if (Intrinsics.areEqual(string2, "valueOf")) {
            Object[] objectArray = new Class[]{String.class};
            bl = Arrays.equals(method.getParameterTypes(), objectArray);
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public List<ReflectJavaField> getFields() {
        Field[] fieldArray = this.klass.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue(fieldArray, "getDeclaredFields(...)");
        return SequencesKt.toList(SequencesKt.map(SequencesKt.filterNot(ArraysKt.asSequence((Object[])fieldArray), fields.1.INSTANCE), fields.2.INSTANCE));
    }

    @NotNull
    public List<ReflectJavaConstructor> getConstructors() {
        Constructor<?>[] constructorArray = this.klass.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, "getDeclaredConstructors(...)");
        return SequencesKt.toList(SequencesKt.map(SequencesKt.filterNot(ArraysKt.asSequence((Object[])constructorArray), constructors.1.INSTANCE), constructors.2.INSTANCE));
    }

    @Override
    public boolean hasDefaultConstructor() {
        return false;
    }

    @Override
    @Nullable
    public LightClassOriginKind getLightClassOriginKind() {
        return null;
    }

    @Override
    @NotNull
    public Name getName() {
        Name name;
        if (this.klass.isAnonymousClass()) {
            String string2 = this.klass.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
            Name name2 = Name.identifier(StringsKt.substringAfterLast$default(string2, ".", null, 2, null));
            Intrinsics.checkNotNull(name2);
            name = name2;
        } else {
            Name name3 = Name.identifier(this.klass.getSimpleName());
            Intrinsics.checkNotNull(name3);
            name = name3;
        }
        return name;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ReflectJavaTypeParameter> getTypeParameters() {
        void $this$mapTo$iv$iv;
        TypeVariable<Class<?>>[] typeVariableArray = this.klass.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(typeVariableArray, "getTypeParameters(...)");
        Object[] $this$map$iv = typeVariableArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TypeVariable typeVariable = (TypeVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ReflectJavaTypeParameter((TypeVariable<?>)p0));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean isInterface() {
        return this.klass.isInterface();
    }

    @Override
    public boolean isAnnotationType() {
        return this.klass.isAnnotation();
    }

    @Override
    public boolean isEnum() {
        return this.klass.isEnum();
    }

    @Override
    public boolean isRecord() {
        Boolean bl = Java16SealedRecordLoader.INSTANCE.loadIsRecord(this.klass);
        return bl != null ? bl : false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<JavaRecordComponent> getRecordComponents() {
        void $this$mapTo$iv$iv;
        Object[] objectArray = Java16SealedRecordLoader.INSTANCE.loadGetRecordComponents(this.klass);
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Object[] $this$map$iv = objectArray;
        boolean $i$f$map = false;
        Object[] objectArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void p0;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ReflectJavaRecordComponent(p0));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public boolean isSealed() {
        Boolean bl = Java16SealedRecordLoader.INSTANCE.loadIsSealed(this.klass);
        return bl != null ? bl : false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Sequence<JavaClassifierType> getPermittedTypes() {
        Sequence<JavaClassifierType> sequence2;
        Class<?>[] classArray = Java16SealedRecordLoader.INSTANCE.loadGetPermittedSubclasses(this.klass);
        if (classArray != null) {
            void $this$mapTo$iv$iv;
            Class<?>[] $this$map$iv = classArray;
            boolean $i$f$map = false;
            Class<?>[] classArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                Type type2 = (Type)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new ReflectJavaClassifierType((Type)p0));
            }
            Sequence sequence3 = CollectionsKt.asSequence((List)destination$iv$iv);
            if (sequence3 != null) {
                sequence2 = sequence3;
                return sequence2;
            }
        }
        sequence2 = SequencesKt.emptySequence();
        return sequence2;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ReflectJavaClass && Intrinsics.areEqual(this.klass, ((ReflectJavaClass)other).klass);
    }

    public int hashCode() {
        return this.klass.hashCode();
    }

    @NotNull
    public String toString() {
        return this.getClass().getName() + ": " + this.klass;
    }

    private static final boolean _get_innerClassNames_$lambda$0(Class it) {
        String string2 = it.getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "getSimpleName(...)");
        return ((CharSequence)string2).length() == 0;
    }

    private static final Name _get_innerClassNames_$lambda$2(Class it) {
        Name name;
        String string2;
        String p0 = string2 = it.getSimpleName();
        boolean bl = false;
        String string3 = Name.isValidIdentifier(p0) ? string2 : null;
        if (string3 != null) {
            p0 = string3;
            boolean bl2 = false;
            name = Name.identifier(p0);
        } else {
            name = null;
        }
        return name;
    }

    private static final boolean _get_methods_$lambda$7(ReflectJavaClass this$0, Method method) {
        boolean bl;
        if (method.isSynthetic()) {
            bl = false;
        } else if (this$0.isEnum()) {
            Intrinsics.checkNotNull(method);
            bl = !this$0.isEnumValuesOrValueOf(method);
        } else {
            bl = true;
        }
        return bl;
    }
}

