/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.runtime.structure;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaMember;
import org.jetbrains.kotlin.descriptors.runtime.structure.ReflectJavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.JavaConstructor;
import org.jetbrains.kotlin.load.java.structure.JavaValueParameter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0013\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00038\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0007\u001a\u0004\b\b\u0010\tR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\n8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\r"}, d2={"Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaConstructor;", "Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaMember;", "Lorg/jetbrains/kotlin/load/java/structure/JavaConstructor;", "Ljava/lang/reflect/Constructor;", "member", "<init>", "(Ljava/lang/reflect/Constructor;)V", "Ljava/lang/reflect/Constructor;", "getMember", "()Ljava/lang/reflect/Constructor;", "", "Lorg/jetbrains/kotlin/load/java/structure/JavaValueParameter;", "getValueParameters", "()Ljava/util/List;", "valueParameters", "Lorg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaTypeParameter;", "getTypeParameters", "typeParameters"})
public final class ReflectJavaConstructor
extends ReflectJavaMember
implements JavaConstructor {
    @NotNull
    private final Constructor<?> member;

    public ReflectJavaConstructor(@NotNull Constructor<?> member) {
        Intrinsics.checkNotNullParameter(member, "member");
        this.member = member;
    }

    @Override
    @NotNull
    public Constructor<?> getMember() {
        return this.member;
    }

    @Override
    @NotNull
    public List<JavaValueParameter> getValueParameters() {
        Annotation[][] annotationArray;
        Type[] types2 = ((Constructor)this.getMember()).getGenericParameterTypes();
        Intrinsics.checkNotNull(types2);
        if (types2.length == 0) {
            return CollectionsKt.emptyList();
        }
        Class klass = ((Constructor)this.getMember()).getDeclaringClass();
        Type[] realTypes = klass.getDeclaringClass() != null && !Modifier.isStatic(klass.getModifiers()) ? ArraysKt.copyOfRange(types2, 1, types2.length) : types2;
        Annotation[][] annotations2 = ((Constructor)this.getMember()).getParameterAnnotations();
        if (((Object[])annotations2).length < realTypes.length) {
            throw new IllegalStateException("Illegal generic signature: " + this.getMember());
        }
        if (((Object[])annotations2).length > realTypes.length) {
            Intrinsics.checkNotNull(annotations2);
            annotationArray = (Annotation[][])ArraysKt.copyOfRange((Object[])annotations2, ((Object[])annotations2).length - realTypes.length, ((Object[])annotations2).length);
        } else {
            annotationArray = annotations2;
        }
        Annotation[][] realAnnotations = annotationArray;
        Intrinsics.checkNotNull(realTypes);
        Intrinsics.checkNotNull(realAnnotations);
        return this.getValueParameters(realTypes, realAnnotations, ((Constructor)this.getMember()).isVarArgs());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ReflectJavaTypeParameter> getTypeParameters() {
        void $this$mapTo$iv$iv;
        TypeVariable<Constructor<T>>[] typeVariableArray = ((Constructor)this.getMember()).getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(typeVariableArray, "getTypeParameters(...)");
        Object[] $this$map$iv = typeVariableArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TypeVariable typeVariable = (TypeVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ReflectJavaTypeParameter((TypeVariable<?>)p0));
        }
        return (List)destination$iv$iv;
    }
}

