/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.google.common.collect.ImmutableSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Severity;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\t\b&\u0018\u0000 $*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0007$%&'()*B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J+\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0014J'\u0010\u0017\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\rH$\u00a2\u0006\u0002\u0010\u0019J5\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u001dH\u0014\u00a2\u0006\u0002\u0010\u001eJ\u001b\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u001b\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010 J\u001b\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00110\"2\u0006\u0010\u001b\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010#RD\u0010\u0005\u001a/\u0012\u0010\u0012\u000e\b\u00028\u0000\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\b\b0\u0006\u00a2\u0006\u0002\b\u0007X\u0084\u0004\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache;", "Element", "", "<init>", "()V", "suppressors", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$Suppressor;", "getSuppressors", "()Ljava/util/concurrent/ConcurrentMap;", "isSuppressed", "", "element", "rootElement", "suppressionKey", "", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/Severity;)Z", "request", "Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$SuppressRequest;", "getClosestAnnotatedAncestorElement", "excludeSelf", "(Ljava/lang/Object;Ljava/lang/Object;Z)Ljava/lang/Object;", "isSuppressedByAnnotated", "annotated", "debugDepth", "", "(Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/Severity;Ljava/lang/Object;Ljava/lang/Object;I)Z", "getOrCreateSuppressor", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$Suppressor;", "getSuppressingStrings", "", "(Ljava/lang/Object;)Ljava/util/Set;", "Companion", "Suppressor", "EmptySuppressor", "SingularSuppressor", "MultiSuppressor", "SuppressRequest", "StringSuppressRequest", "frontend.common"})
public abstract class AbstractKotlinSuppressCache<Element> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<Element, Suppressor<Element>> suppressors;

    public AbstractKotlinSuppressCache() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakValueMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "createConcurrentWeakValueMap(...)");
        this.suppressors = concurrentMap;
    }

    @NotNull
    protected final ConcurrentMap<Element, Suppressor<Element>> getSuppressors() {
        return this.suppressors;
    }

    public final boolean isSuppressed(Element element, Element rootElement, @NotNull String suppressionKey, @NotNull Severity severity) {
        Intrinsics.checkNotNullParameter(suppressionKey, "suppressionKey");
        Intrinsics.checkNotNullParameter((Object)severity, "severity");
        String string2 = suppressionKey.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        return this.isSuppressed(new StringSuppressRequest<Element>(element, rootElement, severity, string2));
    }

    protected boolean isSuppressed(@NotNull SuppressRequest<Element> request) {
        Intrinsics.checkNotNullParameter(request, "request");
        Element Element2 = this.getClosestAnnotatedAncestorElement(request.getElement(), request.getRootElement(), false);
        if (Element2 == null) {
            return false;
        }
        Element annotated = Element2;
        return this.isSuppressedByAnnotated(request.getSuppressKey(), request.getSeverity(), annotated, request.getRootElement(), 0);
    }

    @Nullable
    protected abstract Element getClosestAnnotatedAncestorElement(Element var1, Element var2, boolean var3);

    protected boolean isSuppressedByAnnotated(@NotNull String suppressionKey, @NotNull Severity severity, Element annotated, Element rootElement, int debugDepth) {
        Intrinsics.checkNotNullParameter(suppressionKey, "suppressionKey");
        Intrinsics.checkNotNullParameter((Object)severity, "severity");
        Suppressor<Element> suppressor = this.getOrCreateSuppressor(annotated);
        if (suppressor.isSuppressed(suppressionKey, severity)) {
            return true;
        }
        Element Element2 = this.getClosestAnnotatedAncestorElement(suppressor.getAnnotatedElement(), rootElement, true);
        if (Element2 == null) {
            return false;
        }
        Element annotatedAbove = Element2;
        boolean suppressed = this.isSuppressedByAnnotated(suppressionKey, severity, annotatedAbove, rootElement, debugDepth + 1);
        Suppressor suppressorAbove = (Suppressor)this.suppressors.get(annotatedAbove);
        if (suppressorAbove != null && suppressorAbove.dominates(suppressor)) {
            ((Map)this.suppressors).put(annotated, suppressorAbove);
        }
        return suppressed;
    }

    @NotNull
    protected final Suppressor<Element> getOrCreateSuppressor(Element annotated) {
        Object object;
        Map $this$getOrPut$iv = this.suppressors;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(annotated);
        if (value$iv == null) {
            Suppressor suppressor;
            boolean bl = false;
            Set<String> strings2 = this.getSuppressingStrings(annotated);
            switch (strings2.size()) {
                case 0: {
                    suppressor = new EmptySuppressor<Element>(annotated);
                    break;
                }
                case 1: {
                    suppressor = new SingularSuppressor<Element>(annotated, (String)CollectionsKt.first((Iterable)strings2));
                    break;
                }
                default: {
                    suppressor = new MultiSuppressor<Element>(annotated, strings2);
                }
            }
            Suppressor answer$iv = suppressor;
            $this$getOrPut$iv.put(annotated, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Suppressor)object;
    }

    @NotNull
    protected abstract Set<String> getSuppressingStrings(Element var1);

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$Companion;", "", "<init>", "()V", "", "key", "", "strings", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "severity", "", "isSuppressedByStrings", "(Ljava/lang/String;Ljava/util/Set;Lorg/jetbrains/kotlin/diagnostics/Severity;)Z"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isSuppressedByStrings(String key, Set<String> strings2, Severity severity) {
            if (severity == Severity.WARNING) {
                if (strings2.contains("warnings")) return true;
            }
            String string2 = key.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            if (!strings2.contains(string2)) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u00028\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u000e\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$EmptySuppressor;", "Element", "Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$Suppressor;", "annotated", "<init>", "(Ljava/lang/Object;)V", "", "suppressionKey", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "severity", "", "isSuppressed", "(Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/Severity;)Z", "other", "dominates", "(Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$Suppressor;)Z"})
    private static final class EmptySuppressor<Element>
    extends Suppressor<Element> {
        public EmptySuppressor(Element annotated) {
            super(annotated);
        }

        @Override
        public boolean isSuppressed(@NotNull String suppressionKey, @NotNull Severity severity) {
            Intrinsics.checkNotNullParameter(suppressionKey, "suppressionKey");
            Intrinsics.checkNotNullParameter((Object)severity, "severity");
            return false;
        }

        @Override
        public boolean dominates(@NotNull Suppressor<Element> other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return other instanceof EmptySuppressor;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u00028\u00010\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0010\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$MultiSuppressor;", "Element", "Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$Suppressor;", "annotated", "", "", "strings", "<init>", "(Ljava/lang/Object;Ljava/util/Set;)V", "suppressionKey", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "severity", "", "isSuppressed", "(Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/Severity;)Z", "other", "dominates", "(Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$Suppressor;)Z", "Ljava/util/Set;"})
    private static final class MultiSuppressor<Element>
    extends Suppressor<Element> {
        @NotNull
        private final Set<String> strings;

        public MultiSuppressor(Element annotated, @NotNull Set<String> strings2) {
            Intrinsics.checkNotNullParameter(strings2, "strings");
            super(annotated);
            this.strings = strings2;
        }

        @Override
        public boolean isSuppressed(@NotNull String suppressionKey, @NotNull Severity severity) {
            Intrinsics.checkNotNullParameter(suppressionKey, "suppressionKey");
            Intrinsics.checkNotNullParameter((Object)severity, "severity");
            return Companion.isSuppressedByStrings(suppressionKey, this.strings, severity);
        }

        @Override
        public boolean dominates(@NotNull Suppressor<Element> other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return other instanceof EmptySuppressor;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u00028\u00010\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u000f\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0011"}, d2={"Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$SingularSuppressor;", "Element", "Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$Suppressor;", "annotated", "", "string", "<init>", "(Ljava/lang/Object;Ljava/lang/String;)V", "suppressionKey", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "severity", "", "isSuppressed", "(Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/Severity;)Z", "other", "dominates", "(Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$Suppressor;)Z", "Ljava/lang/String;"})
    private static final class SingularSuppressor<Element>
    extends Suppressor<Element> {
        @NotNull
        private final String string;

        public SingularSuppressor(Element annotated, @NotNull String string2) {
            Intrinsics.checkNotNullParameter(string2, "string");
            super(annotated);
            this.string = string2;
        }

        @Override
        public boolean isSuppressed(@NotNull String suppressionKey, @NotNull Severity severity) {
            Intrinsics.checkNotNullParameter(suppressionKey, "suppressionKey");
            Intrinsics.checkNotNullParameter((Object)severity, "severity");
            ImmutableSet<String> immutableSet = ImmutableSet.of(this.string);
            Intrinsics.checkNotNullExpressionValue(immutableSet, "of(...)");
            return Companion.isSuppressedByStrings(suppressionKey, immutableSet, severity);
        }

        @Override
        public boolean dominates(@NotNull Suppressor<Element> other) {
            Intrinsics.checkNotNullParameter(other, "other");
            return other instanceof EmptySuppressor || other instanceof SingularSuppressor && Intrinsics.areEqual(((SingularSuppressor)other).string, this.string);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u00028\u00010\u0002B'\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u001a\u0010\u0003\u001a\u00028\u00018\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00028\u00018\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u000b\u001a\u0004\b\u000e\u0010\rR\u001a\u0010\u0006\u001a\u00020\u00058\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\b\u001a\u00020\u00078\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014"}, d2={"Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$StringSuppressRequest;", "Element", "Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$SuppressRequest;", "element", "rootElement", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "severity", "", "suppressKey", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/jetbrains/kotlin/diagnostics/Severity;Ljava/lang/String;)V", "Ljava/lang/Object;", "getElement", "()Ljava/lang/Object;", "getRootElement", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "getSeverity", "()Lorg/jetbrains/kotlin/diagnostics/Severity;", "Ljava/lang/String;", "getSuppressKey", "()Ljava/lang/String;"})
    private static final class StringSuppressRequest<Element>
    implements SuppressRequest<Element> {
        private final Element element;
        private final Element rootElement;
        @NotNull
        private final Severity severity;
        @NotNull
        private final String suppressKey;

        public StringSuppressRequest(Element element, Element rootElement, @NotNull Severity severity, @NotNull String suppressKey) {
            Intrinsics.checkNotNullParameter((Object)severity, "severity");
            Intrinsics.checkNotNullParameter(suppressKey, "suppressKey");
            this.element = element;
            this.rootElement = rootElement;
            this.severity = severity;
            this.suppressKey = suppressKey;
        }

        @Override
        public Element getElement() {
            return this.element;
        }

        @Override
        public Element getRootElement() {
            return this.rootElement;
        }

        @Override
        @NotNull
        public Severity getSeverity() {
            return this.severity;
        }

        @Override
        @NotNull
        public String getSuppressKey() {
            return this.suppressKey;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\bd\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002R\u0014\u0010\u0005\u001a\u00028\u00018&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0007\u001a\u00028\u00018&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004R\u0014\u0010\u000b\u001a\u00020\b8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000f\u001a\u00020\f8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$SuppressRequest;", "Element", "", "getElement", "()Ljava/lang/Object;", "element", "getRootElement", "rootElement", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "getSeverity", "()Lorg/jetbrains/kotlin/diagnostics/Severity;", "severity", "", "getSuppressKey", "()Ljava/lang/String;", "suppressKey"})
    protected static interface SuppressRequest<Element> {
        public Element getElement();

        public Element getRootElement();

        @NotNull
        public Severity getSeverity();

        @NotNull
        public String getSuppressKey();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b$\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH&\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u000e\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000H&\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0003\u001a\u00028\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$Suppressor;", "Element", "", "annotatedElement", "<init>", "(Ljava/lang/Object;)V", "", "suppressionKey", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "severity", "", "isSuppressed", "(Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/Severity;)Z", "other", "dominates", "(Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$Suppressor;)Z", "Ljava/lang/Object;", "getAnnotatedElement", "()Ljava/lang/Object;"})
    protected static abstract class Suppressor<Element> {
        private final Element annotatedElement;

        public Suppressor(Element annotatedElement) {
            this.annotatedElement = annotatedElement;
        }

        public final Element getAnnotatedElement() {
            return this.annotatedElement;
        }

        public abstract boolean isSuppressed(@NotNull String var1, @NotNull Severity var2);

        public abstract boolean dominates(@NotNull Suppressor<Element> var1);
    }
}

