/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRenderer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\b&\u0018\u0000 !*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0003:\u0001!B\u001b\b\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0014\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\nJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001b\u0010\u0011\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0004H\u0017\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0018R\u001a\u0010\u0007\u001a\u00020\u00068\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u000b\u001a\u00020\u00048WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0017R*\u0010\u0010\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000f8\u0017@\u0016X\u0097\u000e\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "Lorg/jetbrains/kotlin/diagnostics/UnboundDiagnostic;", "D", "", "", "_name", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "severity", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/Severity;)V", "(Lorg/jetbrains/kotlin/diagnostics/Severity;)V", "name", "", "initializeName", "(Ljava/lang/String;)V", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticRenderer;", "defaultRenderer", "initDefaultRenderer", "(Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticRenderer;)V", "diagnostic", "cast", "(Lorg/jetbrains/kotlin/diagnostics/UnboundDiagnostic;)Lorg/jetbrains/kotlin/diagnostics/UnboundDiagnostic;", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "getSeverity", "()Lorg/jetbrains/kotlin/diagnostics/Severity;", "getName", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticRenderer;", "getDefaultRenderer", "()Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticRenderer;", "setDefaultRenderer", "Companion"})
public abstract class DiagnosticFactory<D extends UnboundDiagnostic> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String _name;
    @NotNull
    private final Severity severity;
    @Nullable
    private DiagnosticRenderer<? super D> defaultRenderer;

    protected DiagnosticFactory(@Nullable String _name, @NotNull Severity severity) {
        Intrinsics.checkNotNullParameter((Object)severity, "severity");
        this._name = _name;
        this.severity = severity;
    }

    @NotNull
    public Severity getSeverity() {
        return this.severity;
    }

    @NotNull
    public String getName() {
        String string2 = this._name;
        Intrinsics.checkNotNull(string2);
        return string2;
    }

    public final void initializeName(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this._name = name;
    }

    @Nullable
    public DiagnosticRenderer<D> getDefaultRenderer() {
        return this.defaultRenderer;
    }

    public void setDefaultRenderer(@Nullable DiagnosticRenderer<? super D> diagnosticRenderer) {
        this.defaultRenderer = diagnosticRenderer;
    }

    protected DiagnosticFactory(@NotNull Severity severity) {
        Intrinsics.checkNotNullParameter((Object)severity, "severity");
        this(null, severity);
    }

    public final void initDefaultRenderer(@Nullable DiagnosticRenderer<?> defaultRenderer) {
        this.setDefaultRenderer(defaultRenderer);
    }

    @NotNull
    public final D cast(@NotNull UnboundDiagnostic diagnostic) {
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        if (!(diagnostic.getFactory() == this)) {
            boolean bl = false;
            String string2 = "Factory mismatch: expected " + this + " but was " + diagnostic.getFactory();
            throw new IllegalArgumentException(string2.toString());
        }
        return (D)diagnostic;
    }

    @NotNull
    public String toString() {
        String string2 = this._name;
        if (string2 == null) {
            string2 = "<Anonymous DiagnosticFactory>";
        }
        return string2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JE\u0010\n\u001a\u00028\u0001\"\b\b\u0001\u0010\u0005*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\"\u0010\t\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00010\b0\u0007\"\n\u0012\u0006\b\u0001\u0012\u00028\u00010\bH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ7\u0010\n\u001a\u00028\u0001\"\b\b\u0001\u0010\u0005*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00010\b0\fH\u0007\u00a2\u0006\u0004\b\n\u0010\r"}, d2={"Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/diagnostics/UnboundDiagnostic;", "D", "diagnostic", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "factories", "cast", "(Lorg/jetbrains/kotlin/diagnostics/UnboundDiagnostic;[Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;)Lorg/jetbrains/kotlin/diagnostics/UnboundDiagnostic;", "", "(Lorg/jetbrains/kotlin/diagnostics/UnboundDiagnostic;Ljava/util/Collection;)Lorg/jetbrains/kotlin/diagnostics/UnboundDiagnostic;"})
    public static final class Companion {
        private Companion() {
        }

        @SafeVarargs
        @NotNull
        public final <D extends UnboundDiagnostic> D cast(@NotNull UnboundDiagnostic diagnostic, DiagnosticFactory<? extends D> ... factories) {
            Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
            Intrinsics.checkNotNullParameter(factories, "factories");
            return this.cast(diagnostic, (Collection)CollectionsKt.listOf(Arrays.copyOf(factories, factories.length)));
        }

        @NotNull
        public final <D extends UnboundDiagnostic> D cast(@NotNull UnboundDiagnostic diagnostic, @NotNull Collection<? extends DiagnosticFactory<? extends D>> factories) {
            Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
            Intrinsics.checkNotNullParameter(factories, "factories");
            for (DiagnosticFactory<D> factory2 : factories) {
                if (diagnostic.getFactory() != factory2) continue;
                return factory2.cast(diagnostic);
            }
            throw new IllegalArgumentException("Factory mismatch: expected one of " + factories + " but was " + diagnostic.getFactory());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

