/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.diagnostics.AbstractKtDiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.AbstractSourceElementPositioningStrategy;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.KtLightSimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtOffsetsOnlySimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtPsiSimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtSimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.SimpleKtDiagnosticRenderer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\b\u00a2\u0006\u0004\b\n\u0010\u000bJ!\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\u00020\u00128\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016"}, d2={"Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory0;", "Lorg/jetbrains/kotlin/diagnostics/AbstractKtDiagnosticFactory;", "", "name", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "severity", "Lorg/jetbrains/kotlin/diagnostics/AbstractSourceElementPositioningStrategy;", "defaultPositioningStrategy", "Lkotlin/reflect/KClass;", "psiType", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/diagnostics/Severity;Lorg/jetbrains/kotlin/diagnostics/AbstractSourceElementPositioningStrategy;Lkotlin/reflect/KClass;)V", "Lorg/jetbrains/kotlin/AbstractKtSourceElement;", "element", "positioningStrategy", "Lorg/jetbrains/kotlin/diagnostics/KtSimpleDiagnostic;", "on", "(Lorg/jetbrains/kotlin/AbstractKtSourceElement;Lorg/jetbrains/kotlin/diagnostics/AbstractSourceElementPositioningStrategy;)Lorg/jetbrains/kotlin/diagnostics/KtSimpleDiagnostic;", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticRenderer;", "ktRenderer", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticRenderer;", "getKtRenderer", "()Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticRenderer;"})
public final class KtDiagnosticFactory0
extends AbstractKtDiagnosticFactory {
    @NotNull
    private final KtDiagnosticRenderer ktRenderer;

    public KtDiagnosticFactory0(@NotNull String name, @NotNull Severity severity, @NotNull AbstractSourceElementPositioningStrategy defaultPositioningStrategy, @NotNull KClass<?> psiType) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter((Object)severity, "severity");
        Intrinsics.checkNotNullParameter(defaultPositioningStrategy, "defaultPositioningStrategy");
        Intrinsics.checkNotNullParameter(psiType, "psiType");
        super(name, severity, defaultPositioningStrategy, psiType, null);
        this.ktRenderer = new SimpleKtDiagnosticRenderer("");
    }

    @Override
    @NotNull
    public KtDiagnosticRenderer getKtRenderer() {
        return this.ktRenderer;
    }

    @NotNull
    public final KtSimpleDiagnostic on(@NotNull AbstractKtSourceElement element, @Nullable AbstractSourceElementPositioningStrategy positioningStrategy) {
        KtSimpleDiagnostic ktSimpleDiagnostic;
        Intrinsics.checkNotNullParameter(element, "element");
        AbstractKtSourceElement abstractKtSourceElement = element;
        if (abstractKtSourceElement instanceof KtPsiSourceElement) {
            KtPsiSourceElement ktPsiSourceElement = (KtPsiSourceElement)element;
            Severity severity = this.getSeverity();
            AbstractSourceElementPositioningStrategy abstractSourceElementPositioningStrategy = positioningStrategy;
            if (abstractSourceElementPositioningStrategy == null) {
                abstractSourceElementPositioningStrategy = this.getDefaultPositioningStrategy();
            }
            ktSimpleDiagnostic = new KtPsiSimpleDiagnostic(ktPsiSourceElement, severity, this, abstractSourceElementPositioningStrategy);
        } else if (abstractKtSourceElement instanceof KtLightSourceElement) {
            KtLightSourceElement ktLightSourceElement = (KtLightSourceElement)element;
            Severity severity = this.getSeverity();
            AbstractSourceElementPositioningStrategy abstractSourceElementPositioningStrategy = positioningStrategy;
            if (abstractSourceElementPositioningStrategy == null) {
                abstractSourceElementPositioningStrategy = this.getDefaultPositioningStrategy();
            }
            ktSimpleDiagnostic = new KtLightSimpleDiagnostic(ktLightSourceElement, severity, this, abstractSourceElementPositioningStrategy);
        } else {
            Severity severity = this.getSeverity();
            AbstractSourceElementPositioningStrategy abstractSourceElementPositioningStrategy = positioningStrategy;
            if (abstractSourceElementPositioningStrategy == null) {
                abstractSourceElementPositioningStrategy = this.getDefaultPositioningStrategy();
            }
            ktSimpleDiagnostic = new KtOffsetsOnlySimpleDiagnostic(element, severity, this, abstractSourceElementPositioningStrategy);
        }
        return ktSimpleDiagnostic;
    }
}

