/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.rendering.ContextIndependentParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRendererKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0005\"\u0004\b\u0000\u0010\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0007\u00a2\u0006\u0004\b\b\u0010\tR\"\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\"\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\f\u001a\u0004\b\u0010\u0010\u000eR\"\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u0012\u0010\u000eR\"\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010\f\u001a\u0004\b\u0014\u0010\u000eR \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0016\u0010\f\u001a\u0004\b\u0017\u0010\u000eR\"\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0018\u0010\f\u001a\u0004\b\u0019\u0010\u000eR \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u001b\u0010\f\u001a\u0004\b\u001c\u0010\u000eR \u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u001e\u0010\f\u001a\u0004\b\u001f\u0010\u000e"}, d2={"Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticRenderers;", "", "<init>", "()V", "T", "Lorg/jetbrains/kotlin/diagnostics/rendering/ContextIndependentParameterRenderer;", "renderer", "", "COLLECTION", "(Lorg/jetbrains/kotlin/diagnostics/rendering/ContextIndependentParameterRenderer;)Lorg/jetbrains/kotlin/diagnostics/rendering/ContextIndependentParameterRenderer;", "", "NULLABLE_STRING", "Lorg/jetbrains/kotlin/diagnostics/rendering/ContextIndependentParameterRenderer;", "getNULLABLE_STRING", "()Lorg/jetbrains/kotlin/diagnostics/rendering/ContextIndependentParameterRenderer;", "TO_STRING", "getTO_STRING", "OPTIONAL_COLON_TO_STRING", "getOPTIONAL_COLON_TO_STRING", "EMPTY", "getEMPTY", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "VISIBILITY", "getVISIBILITY", "NOT_RENDERED", "getNOT_RENDERED", "", "FUNCTION_PARAMETERS", "getFUNCTION_PARAMETERS", "Lorg/jetbrains/kotlin/name/ClassId;", "CLASS_ID", "getCLASS_ID"})
public final class KtDiagnosticRenderers {
    @NotNull
    public static final KtDiagnosticRenderers INSTANCE = new KtDiagnosticRenderers();
    @NotNull
    private static final ContextIndependentParameterRenderer<String> NULLABLE_STRING = DiagnosticParameterRendererKt.Renderer(KtDiagnosticRenderers::NULLABLE_STRING$lambda$0);
    @NotNull
    private static final ContextIndependentParameterRenderer<Object> TO_STRING = DiagnosticParameterRendererKt.Renderer(KtDiagnosticRenderers::TO_STRING$lambda$1);
    @NotNull
    private static final ContextIndependentParameterRenderer<Object> OPTIONAL_COLON_TO_STRING = DiagnosticParameterRendererKt.Renderer(KtDiagnosticRenderers::OPTIONAL_COLON_TO_STRING$lambda$2);
    @NotNull
    private static final ContextIndependentParameterRenderer<Object> EMPTY = DiagnosticParameterRendererKt.Renderer(KtDiagnosticRenderers::EMPTY$lambda$3);
    @NotNull
    private static final ContextIndependentParameterRenderer<Visibility> VISIBILITY = DiagnosticParameterRendererKt.Renderer(KtDiagnosticRenderers::VISIBILITY$lambda$4);
    @NotNull
    private static final ContextIndependentParameterRenderer<Object> NOT_RENDERED = DiagnosticParameterRendererKt.Renderer(KtDiagnosticRenderers::NOT_RENDERED$lambda$5);
    @NotNull
    private static final ContextIndependentParameterRenderer<Boolean> FUNCTION_PARAMETERS = DiagnosticParameterRendererKt.Renderer(KtDiagnosticRenderers::FUNCTION_PARAMETERS$lambda$6);
    @NotNull
    private static final ContextIndependentParameterRenderer<ClassId> CLASS_ID = DiagnosticParameterRendererKt.Renderer(KtDiagnosticRenderers::CLASS_ID$lambda$7);

    private KtDiagnosticRenderers() {
    }

    @NotNull
    public final ContextIndependentParameterRenderer<String> getNULLABLE_STRING() {
        return NULLABLE_STRING;
    }

    @NotNull
    public final ContextIndependentParameterRenderer<Object> getTO_STRING() {
        return TO_STRING;
    }

    @NotNull
    public final ContextIndependentParameterRenderer<Object> getOPTIONAL_COLON_TO_STRING() {
        return OPTIONAL_COLON_TO_STRING;
    }

    @NotNull
    public final ContextIndependentParameterRenderer<Object> getEMPTY() {
        return EMPTY;
    }

    @NotNull
    public final ContextIndependentParameterRenderer<Visibility> getVISIBILITY() {
        return VISIBILITY;
    }

    @NotNull
    public final ContextIndependentParameterRenderer<Object> getNOT_RENDERED() {
        return NOT_RENDERED;
    }

    @NotNull
    public final ContextIndependentParameterRenderer<Boolean> getFUNCTION_PARAMETERS() {
        return FUNCTION_PARAMETERS;
    }

    @NotNull
    public final ContextIndependentParameterRenderer<ClassId> getCLASS_ID() {
        return CLASS_ID;
    }

    @NotNull
    public final <T> ContextIndependentParameterRenderer<Collection<? extends T>> COLLECTION(@NotNull ContextIndependentParameterRenderer<? super T> renderer) {
        Intrinsics.checkNotNullParameter(renderer, "renderer");
        return DiagnosticParameterRendererKt.Renderer(arg_0 -> KtDiagnosticRenderers.COLLECTION$lambda$9(renderer, arg_0));
    }

    private static final String NULLABLE_STRING$lambda$0(String it) {
        String string2 = it;
        if (string2 == null) {
            string2 = "null";
        }
        return string2;
    }

    private static final String TO_STRING$lambda$1(Object element) {
        return String.valueOf(element);
    }

    private static final String OPTIONAL_COLON_TO_STRING$lambda$2(Object element) {
        String string2 = String.valueOf(element);
        return ((CharSequence)string2).length() > 0 ? ": " + string2 : "";
    }

    private static final String EMPTY$lambda$3(Object object) {
        return "";
    }

    private static final String VISIBILITY$lambda$4(Visibility visibility) {
        Intrinsics.checkNotNullParameter(visibility, "visibility");
        return visibility.getExternalDisplayName();
    }

    private static final String NOT_RENDERED$lambda$5(Object it) {
        return "";
    }

    private static final String FUNCTION_PARAMETERS$lambda$6(boolean hasValueParameters) {
        return hasValueParameters ? "..." : "";
    }

    private static final String CLASS_ID$lambda$7(ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return classId.asFqNameString();
    }

    private static final CharSequence COLLECTION$lambda$9$lambda$8(ContextIndependentParameterRenderer $renderer, Object it) {
        return $renderer.render(it);
    }

    private static final String COLLECTION$lambda$9(ContextIndependentParameterRenderer $renderer, Collection list) {
        Intrinsics.checkNotNullParameter(list, "list");
        return CollectionsKt.joinToString(list, ", ", "[", "]", 3, "...", arg_0 -> KtDiagnosticRenderers.COLLECTION$lambda$9$lambda$8($renderer, arg_0));
    }
}

