/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.diagnostics.AbstractKtDiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticMarker;
import org.jetbrains.kotlin.diagnostics.Severity;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0005\u001a\u00020\u00028'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004R\u0014\u0010\t\u001a\u00020\u00068'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0012\u001a\u00020\u000f8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u00138WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u001a\u001a\u00020\u00178WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/diagnostics/KtPsiDiagnostic;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticMarker;", "Lorg/jetbrains/kotlin/diagnostics/AbstractKtDiagnosticFactory;", "getFactory", "()Lorg/jetbrains/kotlin/diagnostics/AbstractKtDiagnosticFactory;", "factory", "Lorg/jetbrains/kotlin/KtPsiSourceElement;", "getElement", "()Lorg/jetbrains/kotlin/KtPsiSourceElement;", "element", "", "Lcom/intellij/openapi/util/TextRange;", "getTextRanges", "()Ljava/util/List;", "textRanges", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "getSeverity", "()Lorg/jetbrains/kotlin/diagnostics/Severity;", "severity", "Lcom/intellij/psi/PsiElement;", "getPsiElement", "()Lcom/intellij/psi/PsiElement;", "psiElement", "Lcom/intellij/psi/PsiFile;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "psiFile"})
public interface KtPsiDiagnostic
extends DiagnosticMarker {
    @NotNull
    public AbstractKtDiagnosticFactory getFactory();

    @NotNull
    public KtPsiSourceElement getElement();

    @NotNull
    public List<TextRange> getTextRanges();

    @NotNull
    public Severity getSeverity();

    @Override
    @NotNull
    default public PsiElement getPsiElement() {
        return this.getElement().getPsi();
    }

    @NotNull
    default public PsiFile getPsiFile() {
        PsiFile psiFile = this.getPsiElement().getContainingFile();
        Intrinsics.checkNotNullExpressionValue(psiFile, "getContainingFile(...)");
        return psiFile;
    }
}

