/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticMarker;
import org.jetbrains.kotlin.diagnostics.PositioningStrategyKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u0000*\n\b\u0000\u0010\u0002 \u0000*\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00028\u0000H\u0017\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011"}, d2={"Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "Lcom/intellij/psi/PsiElement;", "E", "", "<init>", "()V", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticMarker;", "diagnostic", "", "Lcom/intellij/openapi/util/TextRange;", "markDiagnostic", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticMarker;)Ljava/util/List;", "element", "mark", "(Lcom/intellij/psi/PsiElement;)Ljava/util/List;", "", "isValid", "(Lcom/intellij/psi/PsiElement;)Z"})
public class PositioningStrategy<E extends PsiElement> {
    @NotNull
    public List<TextRange> markDiagnostic(@NotNull DiagnosticMarker diagnostic) {
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        PsiElement psiElement = diagnostic.getPsiElement();
        Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type E of org.jetbrains.kotlin.diagnostics.PositioningStrategy");
        return this.mark(psiElement);
    }

    @NotNull
    public List<TextRange> mark(@NotNull E element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return PositioningStrategyKt.markElement(element);
    }

    public boolean isValid(@NotNull E element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return !PositioningStrategyKt.hasSyntaxErrors(element);
    }
}

