/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0017\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0001\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0007\u00a2\u0006\u0004\b\r\u0010\u000e\u001a%\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\r\u0010\u0011\u001a\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a\u0017\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014\u001a\u0015\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019"}, d2={"Lcom/intellij/psi/PsiElement;", "element", "", "Lcom/intellij/openapi/util/TextRange;", "markElement", "(Lcom/intellij/psi/PsiElement;)Ljava/util/List;", "markSingleElement", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/lang/ASTNode;", "node", "markNode", "(Lcom/intellij/lang/ASTNode;)Ljava/util/List;", "range", "markRange", "(Lcom/intellij/openapi/util/TextRange;)Ljava/util/List;", "from", "to", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)Ljava/util/List;", "", "getStartOffset", "(Lcom/intellij/psi/PsiElement;)I", "getEndOffset", "psiElement", "", "hasSyntaxErrors", "(Lcom/intellij/psi/PsiElement;)Z"})
public final class PositioningStrategyKt {
    @NotNull
    public static final List<TextRange> markElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return CollectionsKt.listOf(new TextRange(PositioningStrategyKt.getStartOffset(element), PositioningStrategyKt.getEndOffset(element)));
    }

    @NotNull
    public static final TextRange markSingleElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return new TextRange(PositioningStrategyKt.getStartOffset(element), PositioningStrategyKt.getEndOffset(element));
    }

    @NotNull
    public static final List<TextRange> markNode(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
        PsiElement psiElement = node.getPsi();
        Intrinsics.checkNotNullExpressionValue(psiElement, "getPsi(...)");
        return PositioningStrategyKt.markElement(psiElement);
    }

    @NotNull
    public static final List<TextRange> markRange(@NotNull TextRange range) {
        Intrinsics.checkNotNullParameter(range, "range");
        return CollectionsKt.listOf(range);
    }

    @NotNull
    public static final List<TextRange> markRange(@NotNull PsiElement from, @NotNull PsiElement to) {
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        return PositioningStrategyKt.markRange(new TextRange(PositioningStrategyKt.getStartOffset(from), PositioningStrategyKt.getEndOffset(to)));
    }

    private static final int getStartOffset(PsiElement element) {
        PsiElement child = element.getFirstChild();
        if (child != null) {
            while (child instanceof PsiComment || child instanceof PsiWhiteSpace) {
                child = child.getNextSibling();
            }
            if (child != null) {
                return PositioningStrategyKt.getStartOffset(child);
            }
        }
        return PsiUtilsKt.getStartOffset(element);
    }

    private static final int getEndOffset(PsiElement element) {
        PsiElement child = element.getLastChild();
        if (child != null) {
            while (child instanceof PsiComment || child instanceof PsiWhiteSpace) {
                child = child.getPrevSibling();
            }
            if (child != null) {
                return PositioningStrategyKt.getEndOffset(child);
            }
        }
        return PsiUtilsKt.getEndOffset(element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasSyntaxErrors(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter(psiElement, "psiElement");
        if (psiElement instanceof PsiErrorElement) {
            return true;
        }
        PsiElement[] psiElementArray = psiElement.getChildren();
        Intrinsics.checkNotNullExpressionValue(psiElementArray, "getChildren(...)");
        PsiElement[] children2 = psiElementArray;
        if (children2.length == 0) {
            return false;
        }
        boolean bl = false;
        if (bl) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        PsiElement psiElement2 = ArraysKt.last(children2);
        Intrinsics.checkNotNullExpressionValue(psiElement2, "last(...)");
        if (!PositioningStrategyKt.hasSyntaxErrors(psiElement2)) return false;
        return true;
    }
}

