/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRenderer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00028\u00008\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\f\u001a\u0004\b\r\u0010\u000eR \u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\t8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u000bR\u0015\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00158G\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017"}, d2={"Lorg/jetbrains/kotlin/diagnostics/RenderedDiagnostic;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "D", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticRenderer;", "renderer", "<init>", "(Lorg/jetbrains/kotlin/diagnostics/Diagnostic;Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticRenderer;)V", "", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getDiagnostic", "()Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticRenderer;", "getRenderer", "()Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticRenderer;", "text", "Ljava/lang/String;", "getText", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "getFactory", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "factory"})
public final class RenderedDiagnostic<D extends Diagnostic> {
    @NotNull
    private final D diagnostic;
    @NotNull
    private final DiagnosticRenderer<D> renderer;
    @NotNull
    private final String text;

    public RenderedDiagnostic(@NotNull D diagnostic, @NotNull DiagnosticRenderer<? super D> renderer) {
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        Intrinsics.checkNotNullParameter(renderer, "renderer");
        this.diagnostic = diagnostic;
        this.renderer = renderer;
        this.text = this.renderer.render((UnboundDiagnostic)this.diagnostic);
    }

    @NotNull
    public final D getDiagnostic() {
        return this.diagnostic;
    }

    @NotNull
    public final DiagnosticRenderer<D> getRenderer() {
        return this.renderer;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final DiagnosticFactory<?> getFactory() {
        return ((UnboundDiagnostic)this.diagnostic).getFactory();
    }

    @NotNull
    public String toString() {
        return this.text;
    }
}

