/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.AbstractSourceElementPositioningStrategy;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategy;
import org.jetbrains.kotlin.diagnostics.OffsetsOnlyPositioningStrategy;
import org.jetbrains.kotlin.diagnostics.PositioningStrategy;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0017\u001a\u00020\u0012*\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0019R\u0018\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001aR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001b"}, d2={"Lorg/jetbrains/kotlin/diagnostics/SourceElementPositioningStrategy;", "Lorg/jetbrains/kotlin/diagnostics/AbstractSourceElementPositioningStrategy;", "Lorg/jetbrains/kotlin/diagnostics/LightTreePositioningStrategy;", "lightTreeStrategy", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "psiStrategy", "Lorg/jetbrains/kotlin/diagnostics/OffsetsOnlyPositioningStrategy;", "offsetsOnlyPositioningStrategy", "<init>", "(Lorg/jetbrains/kotlin/diagnostics/LightTreePositioningStrategy;Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;Lorg/jetbrains/kotlin/diagnostics/OffsetsOnlyPositioningStrategy;)V", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "diagnostic", "", "Lcom/intellij/openapi/util/TextRange;", "markDiagnostic", "(Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;)Ljava/util/List;", "Lorg/jetbrains/kotlin/AbstractKtSourceElement;", "element", "", "isValid", "(Lorg/jetbrains/kotlin/AbstractKtSourceElement;)Z", "Lcom/intellij/psi/PsiElement;", "psi", "hackyIsValid", "(Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;Lcom/intellij/psi/PsiElement;)Z", "Lorg/jetbrains/kotlin/diagnostics/LightTreePositioningStrategy;", "Lorg/jetbrains/kotlin/diagnostics/PositioningStrategy;", "Lorg/jetbrains/kotlin/diagnostics/OffsetsOnlyPositioningStrategy;"})
public final class SourceElementPositioningStrategy
extends AbstractSourceElementPositioningStrategy {
    @NotNull
    private final LightTreePositioningStrategy lightTreeStrategy;
    @NotNull
    private final PositioningStrategy<?> psiStrategy;
    @NotNull
    private final OffsetsOnlyPositioningStrategy offsetsOnlyPositioningStrategy;

    public SourceElementPositioningStrategy(@NotNull LightTreePositioningStrategy lightTreeStrategy, @NotNull PositioningStrategy<?> psiStrategy, @NotNull OffsetsOnlyPositioningStrategy offsetsOnlyPositioningStrategy) {
        Intrinsics.checkNotNullParameter(lightTreeStrategy, "lightTreeStrategy");
        Intrinsics.checkNotNullParameter(psiStrategy, "psiStrategy");
        Intrinsics.checkNotNullParameter(offsetsOnlyPositioningStrategy, "offsetsOnlyPositioningStrategy");
        this.lightTreeStrategy = lightTreeStrategy;
        this.psiStrategy = psiStrategy;
        this.offsetsOnlyPositioningStrategy = offsetsOnlyPositioningStrategy;
    }

    public /* synthetic */ SourceElementPositioningStrategy(LightTreePositioningStrategy lightTreePositioningStrategy, PositioningStrategy positioningStrategy, OffsetsOnlyPositioningStrategy offsetsOnlyPositioningStrategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            offsetsOnlyPositioningStrategy = new OffsetsOnlyPositioningStrategy();
        }
        this(lightTreePositioningStrategy, positioningStrategy, offsetsOnlyPositioningStrategy);
    }

    @Override
    @NotNull
    public List<TextRange> markDiagnostic(@NotNull KtDiagnostic diagnostic) {
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        AbstractKtSourceElement element = diagnostic.getElement();
        return element instanceof KtPsiSourceElement ? this.psiStrategy.markDiagnostic(diagnostic) : (element instanceof KtLightSourceElement ? this.lightTreeStrategy.markKtDiagnostic((KtSourceElement)element, diagnostic) : this.offsetsOnlyPositioningStrategy.markKtDiagnostic(element, diagnostic));
    }

    @Override
    public boolean isValid(@NotNull AbstractKtSourceElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        AbstractKtSourceElement abstractKtSourceElement = element;
        return abstractKtSourceElement instanceof KtPsiSourceElement ? this.hackyIsValid(this.psiStrategy, ((KtPsiSourceElement)element).getPsi()) : (abstractKtSourceElement instanceof KtLightSourceElement ? this.lightTreeStrategy.isValid(((KtLightSourceElement)element).getLighterASTNode(), ((KtLightSourceElement)element).getTreeStructure()) : true);
    }

    private final boolean hackyIsValid(PositioningStrategy<?> $this$hackyIsValid, PsiElement psi) {
        Intrinsics.checkNotNull($this$hackyIsValid, "null cannot be cast to non-null type org.jetbrains.kotlin.diagnostics.PositioningStrategy<com.intellij.psi.PsiElement>");
        return $this$hackyIsValid.isValid(psi);
    }
}

