/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.ClassifierNamePolicy;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J+\u0010\u0016\u001a\u00020\u000b*\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0018R&\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u001a0\u00198\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/AdaptiveClassifierNamePolicy;", "Lorg/jetbrains/kotlin/renderer/ClassifierNamePolicy;", "", "Lorg/jetbrains/kotlin/name/Name;", "ambiguousNames", "<init>", "(Ljava/util/List;)V", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "classifier", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "renderer", "", "renderClassifier", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;)Ljava/lang/String;", "", "hasUniqueName", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;)Z", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "typeParameter", "", "index", "firstOccurence", "renderAmbiguousTypeParameter", "(Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;IZ)Ljava/lang/String;", "Ljava/util/List;", "", "Ljava/util/LinkedHashSet;", "renderedParameters", "Ljava/util/Map;"})
final class AdaptiveClassifierNamePolicy
implements ClassifierNamePolicy {
    @NotNull
    private final List<Name> ambiguousNames;
    @NotNull
    private final Map<Name, LinkedHashSet<TypeParameterDescriptor>> renderedParameters;

    public AdaptiveClassifierNamePolicy(@NotNull List<Name> ambiguousNames) {
        Intrinsics.checkNotNullParameter(ambiguousNames, "ambiguousNames");
        this.ambiguousNames = ambiguousNames;
        this.renderedParameters = new LinkedHashMap();
    }

    @Override
    @NotNull
    public String renderClassifier(@NotNull ClassifierDescriptor classifier2, @NotNull DescriptorRenderer renderer) {
        String string2;
        Intrinsics.checkNotNullParameter(classifier2, "classifier");
        Intrinsics.checkNotNullParameter(renderer, "renderer");
        if (this.hasUniqueName(classifier2)) {
            string2 = ClassifierNamePolicy.SHORT.INSTANCE.renderClassifier(classifier2, renderer);
        } else if (classifier2 instanceof ClassDescriptor || classifier2 instanceof TypeAliasDescriptor) {
            string2 = ClassifierNamePolicy.FULLY_QUALIFIED.INSTANCE.renderClassifier(classifier2, renderer);
        } else if (classifier2 instanceof TypeParameterDescriptor) {
            LinkedHashSet<TypeParameterDescriptor> linkedHashSet;
            Name name = ((TypeParameterDescriptor)classifier2).getName();
            Intrinsics.checkNotNullExpressionValue(name, "getName(...)");
            Name name2 = name;
            Map<Name, LinkedHashSet<TypeParameterDescriptor>> $this$getOrPut$iv = this.renderedParameters;
            boolean $i$f$getOrPut = false;
            LinkedHashSet<TypeParameterDescriptor> value$iv = $this$getOrPut$iv.get(name2);
            if (value$iv == null) {
                boolean bl = false;
                LinkedHashSet answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(name2, answer$iv);
                linkedHashSet = answer$iv;
            } else {
                linkedHashSet = value$iv;
            }
            LinkedHashSet<TypeParameterDescriptor> typeParametersWithSameName = linkedHashSet;
            boolean isFirstOccurence = typeParametersWithSameName.add((TypeParameterDescriptor)classifier2);
            int index2 = CollectionsKt.indexOf((Iterable)typeParametersWithSameName, classifier2);
            string2 = this.renderAmbiguousTypeParameter(renderer, (TypeParameterDescriptor)classifier2, index2 + 1, isFirstOccurence);
        } else {
            throw new IllegalStateException(("Unexpected classifier: " + classifier2.getClass()).toString());
        }
        return string2;
    }

    private final boolean hasUniqueName(ClassifierDescriptor classifier2) {
        return !this.ambiguousNames.contains(classifier2.getName());
    }

    private final String renderAmbiguousTypeParameter(DescriptorRenderer $this$renderAmbiguousTypeParameter, TypeParameterDescriptor typeParameter, int index2, boolean firstOccurence) {
        StringBuilder stringBuilder;
        StringBuilder $this$renderAmbiguousTypeParameter_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$renderAmbiguousTypeParameter_u24lambda_u241.append(typeParameter.getName());
        $this$renderAmbiguousTypeParameter_u24lambda_u241.append("" + '#' + index2);
        if (firstOccurence) {
            StringBuilder stringBuilder2 = new StringBuilder().append(" (type parameter of ");
            DeclarationDescriptor declarationDescriptor = typeParameter.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
            $this$renderAmbiguousTypeParameter_u24lambda_u241.append($this$renderAmbiguousTypeParameter.renderMessage(stringBuilder2.append($this$renderAmbiguousTypeParameter.renderFqName(DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor))).append(')').toString()));
        }
        return stringBuilder.toString();
    }
}

