/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.platform.PlatformSpecificDiagnosticComponents;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0097\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0003H\u00c7\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0005H\u00c7\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ$\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c7\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\u0019H\u00d7\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0004\u001a\u00020\u00038\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001c\u001a\u0004\b\u001d\u0010\rR\u001a\u0010\u0006\u001a\u00020\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001e\u001a\u0004\b\u001f\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/DeclarationWithDiagnosticComponents;", "", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "declaration", "Lorg/jetbrains/kotlin/platform/PlatformSpecificDiagnosticComponents;", "diagnosticComponents", "<init>", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/platform/PlatformSpecificDiagnosticComponents;)V", "", "iterator", "()Ljava/util/Iterator;", "component1", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "component2", "()Lorg/jetbrains/kotlin/platform/PlatformSpecificDiagnosticComponents;", "copy", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/platform/PlatformSpecificDiagnosticComponents;)Lorg/jetbrains/kotlin/diagnostics/rendering/DeclarationWithDiagnosticComponents;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getDeclaration", "Lorg/jetbrains/kotlin/platform/PlatformSpecificDiagnosticComponents;", "getDiagnosticComponents"})
public final class DeclarationWithDiagnosticComponents
implements Iterable<Object>,
KMappedMarker {
    @NotNull
    private final DeclarationDescriptor declaration;
    @NotNull
    private final PlatformSpecificDiagnosticComponents diagnosticComponents;

    public DeclarationWithDiagnosticComponents(@NotNull DeclarationDescriptor declaration, @NotNull PlatformSpecificDiagnosticComponents diagnosticComponents) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(diagnosticComponents, "diagnosticComponents");
        this.declaration = declaration;
        this.diagnosticComponents = diagnosticComponents;
    }

    @NotNull
    public final DeclarationDescriptor getDeclaration() {
        return this.declaration;
    }

    @NotNull
    public final PlatformSpecificDiagnosticComponents getDiagnosticComponents() {
        return this.diagnosticComponents;
    }

    @Override
    @NotNull
    public Iterator<Object> iterator() {
        Object[] objectArray = new Object[]{this.declaration, this.diagnosticComponents};
        return SequencesKt.sequenceOf(objectArray).iterator();
    }

    @NotNull
    public final DeclarationDescriptor component1() {
        return this.declaration;
    }

    @NotNull
    public final PlatformSpecificDiagnosticComponents component2() {
        return this.diagnosticComponents;
    }

    @NotNull
    public final DeclarationWithDiagnosticComponents copy(@NotNull DeclarationDescriptor declaration, @NotNull PlatformSpecificDiagnosticComponents diagnosticComponents) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(diagnosticComponents, "diagnosticComponents");
        return new DeclarationWithDiagnosticComponents(declaration, diagnosticComponents);
    }

    public static /* synthetic */ DeclarationWithDiagnosticComponents copy$default(DeclarationWithDiagnosticComponents declarationWithDiagnosticComponents, DeclarationDescriptor declarationDescriptor, PlatformSpecificDiagnosticComponents platformSpecificDiagnosticComponents, int n, Object object) {
        if ((n & 1) != 0) {
            declarationDescriptor = declarationWithDiagnosticComponents.declaration;
        }
        if ((n & 2) != 0) {
            platformSpecificDiagnosticComponents = declarationWithDiagnosticComponents.diagnosticComponents;
        }
        return declarationWithDiagnosticComponents.copy(declarationDescriptor, platformSpecificDiagnosticComponents);
    }

    @NotNull
    public String toString() {
        return "DeclarationWithDiagnosticComponents(declaration=" + this.declaration + ", diagnosticComponents=" + this.diagnosticComponents + ')';
    }

    public int hashCode() {
        int result2 = this.declaration.hashCode();
        result2 = result2 * 31 + this.diagnosticComponents.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DeclarationWithDiagnosticComponents)) {
            return false;
        }
        DeclarationWithDiagnosticComponents declarationWithDiagnosticComponents = (DeclarationWithDiagnosticComponents)other;
        if (!Intrinsics.areEqual(this.declaration, declarationWithDiagnosticComponents.declaration)) {
            return false;
        }
        return Intrinsics.areEqual(this.diagnosticComponents, declarationWithDiagnosticComponents.diagnosticComponents);
    }
}

