/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import org.jetbrains.kotlin.diagnostics.rendering.RuntimeFeatureToFlagMapKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\b\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001:\u0001\u001bB\u0019\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ+\u0010\u000f\u001a\u00020\u000e2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\u0006\u0010\r\u001a\u00020\fH\u0017\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0011R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0012R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\u00138\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R'\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\u00138BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/LanguageFeatureMessageRenderer;", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticParameterRenderer;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "Lorg/jetbrains/kotlin/diagnostics/rendering/LanguageFeatureMessageRenderer$Type;", "type", "", "useHtml", "<init>", "(Lorg/jetbrains/kotlin/diagnostics/rendering/LanguageFeatureMessageRenderer$Type;Z)V", "obj", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;", "renderingContext", "", "render", "(Lkotlin/Pair;Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/diagnostics/rendering/LanguageFeatureMessageRenderer$Type;", "Z", "", "additionalFeatureMessages", "Ljava/util/Map;", "featureToFlagMap$delegate", "Lkotlin/Lazy;", "getFeatureToFlagMap", "()Ljava/util/Map;", "featureToFlagMap", "Type"})
public final class LanguageFeatureMessageRenderer
implements DiagnosticParameterRenderer<Pair<? extends LanguageFeature, ? extends LanguageVersionSettings>> {
    @NotNull
    private final Type type;
    private final boolean useHtml;
    @NotNull
    private final Map<LanguageFeature, String> additionalFeatureMessages;
    @NotNull
    private final Lazy featureToFlagMap$delegate;

    public LanguageFeatureMessageRenderer(@NotNull Type type2, boolean useHtml) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        this.type = type2;
        this.useHtml = useHtml;
        this.additionalFeatureMessages = MapsKt.mapOf(TuplesKt.to(LanguageFeature.UnitConversionsOnArbitraryExpressions, "You can also change the original type of this expression to (...) -> Unit"));
        this.featureToFlagMap$delegate = LazyKt.lazy(() -> LanguageFeatureMessageRenderer.featureToFlagMap_delegate$lambda$0(this));
    }

    public /* synthetic */ LanguageFeatureMessageRenderer(Type type2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(type2, bl);
    }

    private final Map<LanguageFeature, String> getFeatureToFlagMap() {
        Lazy lazy = this.featureToFlagMap$delegate;
        return (Map)lazy.getValue();
    }

    @Override
    @NotNull
    public String render(@NotNull Pair<? extends LanguageFeature, ? extends LanguageVersionSettings> obj, @NotNull RenderingContext renderingContext) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        Intrinsics.checkNotNullParameter(renderingContext, "renderingContext");
        LanguageFeature feature = obj.component1();
        LanguageVersionSettings settings = obj.component2();
        LanguageVersion since = feature.getSinceVersion();
        StringBuilder sb = new StringBuilder();
        sb.append("The feature \"").append(feature.getPresentableName()).append("\" is ");
        String string2 = this.getFeatureToFlagMap().get((Object)feature);
        if (string2 == null) {
            string2 = "-XXLanguage:+" + feature.name();
        }
        String featureFlag = string2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                StringBuilder stringBuilder;
                if (settings.supportsFeature(feature) && settings.getLanguageVersion().compareTo((Enum)LanguageVersion.KOTLIN_2_0) < 0) {
                    stringBuilder = sb.append("not supported in language versions 1.*, please use version 2.0 or later");
                    break;
                }
                if (since == null) {
                    stringBuilder = sb.append("experimental and should be enabled explicitly. This can be done by supplying the compiler argument '" + featureFlag + "', but note that no stability guarantees are provided.");
                    break;
                }
                if (since.compareTo((Enum)settings.getLanguageVersion()) > 0) {
                    stringBuilder = sb.append("only available since language version ").append(since.getVersionString());
                    break;
                }
                if (feature.getSinceApiVersion().compareTo(settings.getApiVersion()) > 0) {
                    stringBuilder = sb.append("only available since API version ").append(feature.getSinceApiVersion().getVersionString());
                    break;
                }
                stringBuilder = sb.append("disabled");
                break;
            }
            case 2: {
                StringBuilder stringBuilder = sb.append("experimental");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String hintUrl = feature.getHintUrl();
        if (hintUrl != null) {
            StringBuilder stringBuilder = this.useHtml ? sb.append(" (").append("see more <a href=\"").append(hintUrl).append("\">here</a>)") : sb.append(" (see: ").append(hintUrl).append(")");
        }
        if (this.additionalFeatureMessages.containsKey((Object)feature)) {
            sb.append(". " + this.additionalFeatureMessages.get((Object)feature));
        }
        String string3 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        return string3;
    }

    public LanguageFeatureMessageRenderer(@NotNull Type type2) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        this(type2, false, 2, null);
    }

    private static final Map featureToFlagMap_delegate$lambda$0(LanguageFeatureMessageRenderer this$0) {
        ClassLoader classLoader = this$0.getClass().getClassLoader();
        Intrinsics.checkNotNullExpressionValue(classLoader, "getClassLoader(...)");
        return RuntimeFeatureToFlagMapKt.buildRuntimeFeatureToFlagMap(classLoader);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/LanguageFeatureMessageRenderer$Type;", "", "<init>", "(Ljava/lang/String;I)V", "UNSUPPORTED", "WARNING"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type UNSUPPORTED = new Type();
        public static final /* enum */ Type WARNING = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value2) {
            return Enum.valueOf(Type.class, value2);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.UNSUPPORTED, Type.WARNING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.UNSUPPORTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

