/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.analyzer.ModuleInfoUtilsKt;
import org.jetbrains.kotlin.analyzer.ModuleSourceInfoBaseKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.Named;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.diagnostics.rendering.AnnotationsWhitelistDescriptorRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.AnnotationsWhitelistDescriptorRendererKt;
import org.jetbrains.kotlin.diagnostics.rendering.CommonRenderers;
import org.jetbrains.kotlin.diagnostics.rendering.ContextIndependentParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticParameterRendererKt;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRendererUtilKt;
import org.jetbrains.kotlin.diagnostics.rendering.MultiplatformDiagnosticRenderingMode;
import org.jetbrains.kotlin.diagnostics.rendering.RenderersKt;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import org.jetbrains.kotlin.diagnostics.rendering.SmartDescriptorRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.SmartTypeRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.TabledDescriptorRenderer;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.renderer.PropertyAccessorRenderingPolicy;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.MemberComparator;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.CannotCapture;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructor;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedTypeConstructorKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintError;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintsUtil;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.ParameterConstraintError;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariableKt;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKt;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ValidityConstraintForConstituentType;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0094\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ/\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u000b\"\u0004\b\u0000\u0010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0014J\u001f\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0014J\u001f\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0014J)\u0010\u001b\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u001d\u0010\u0014J3\u0010#\u001a\u00020\u00072\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001e0\u000b2\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b#\u0010$J\u001f\u0010(\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00192\u0006\u0010'\u001a\u00020&H\u0007\u00a2\u0006\u0004\b(\u0010)J\u001f\u0010,\u001a\u00020\u00072\u0006\u0010+\u001a\u00020*2\u0006\u0010'\u001a\u00020&H\u0002\u00a2\u0006\u0004\b,\u0010-J\u001f\u00102\u001a\u00020\u00072\u0006\u0010/\u001a\u00020.2\u0006\u00101\u001a\u000200H\u0002\u00a2\u0006\u0004\b2\u00103J\u001f\u00106\u001a\u00020\u00072\u0006\u00105\u001a\u0002042\u0006\u0010'\u001a\u00020&H\u0002\u00a2\u0006\u0004\b6\u00107J\u0017\u0010:\u001a\u00020\u00072\u0006\u00109\u001a\u000208H\u0002\u00a2\u0006\u0004\b:\u0010;J)\u0010=\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010'\u001a\u00020&H\u0002\u00a2\u0006\u0004\b=\u0010>J\u0013\u0010?\u001a\u00020\u0007*\u00020\u0007H\u0002\u00a2\u0006\u0004\b?\u0010@J\u0013\u0010?\u001a\u00020\u0007*\u00020AH\u0002\u00a2\u0006\u0004\b?\u0010BJ)\u0010F\u001a\u00020\u00072\b\u0010C\u001a\u0004\u0018\u00010\u001e2\u000e\u0010E\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010DH\u0007\u00a2\u0006\u0004\bF\u0010GJ!\u0010K\u001a\u00020\u00072\b\u0010I\u001a\u0004\u0018\u00010H2\u0006\u0010J\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\bK\u0010LR\u0019\u0010O\u001a\u00070M\u00a2\u0006\u0002\bN8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\bO\u0010PR\u001a\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00010Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bR\u0010SR\u001c\u0010T\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bT\u0010SR\u001a\u0010V\u001a\b\u0012\u0004\u0012\u00020U0Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bV\u0010SR\u001a\u0010X\u001a\b\u0012\u0004\u0012\u00020W0Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bX\u0010SR\u001a\u0010Z\u001a\b\u0012\u0004\u0012\u00020Y0Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bZ\u0010SR\u001a\u0010[\u001a\b\u0012\u0004\u0012\u00020Y0Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b[\u0010SR\u001a\u0010]\u001a\b\u0012\u0004\u0012\u00020\\0Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b]\u0010SR\u001a\u0010_\u001a\b\u0012\u0004\u0012\u00020^0Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b_\u0010SR\u001a\u0010`\u001a\b\u0012\u0004\u0012\u00020^0Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b`\u0010SR\u001a\u0010a\u001a\b\u0012\u0004\u0012\u00020^0Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\ba\u0010SR\u001a\u0010c\u001a\b\u0012\u0004\u0012\u00020b0Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bc\u0010SR\u001a\u0010e\u001a\b\u0012\u0004\u0012\u00020d0Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\be\u0010SR\u001a\u0010g\u001a\b\u0012\u0004\u0012\u00020f0Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bg\u0010SR\u001a\u0010i\u001a\b\u0012\u0004\u0012\u00020h0Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bi\u0010SR\u0014\u0010k\u001a\u00020j8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bk\u0010lR\u0014\u0010m\u001a\u00020j8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bm\u0010lR\u001a\u0010o\u001a\b\u0012\u0004\u0012\u00020n0Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bo\u0010SR$\u0010q\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030p0\u00040Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bq\u0010SR\u001a\u0010r\u001a\b\u0012\u0004\u0012\u00020\u00050Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\br\u0010SR \u0010s\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bs\u0010SR\u001a\u0010t\u001a\b\u0012\u0004\u0012\u00020\u000f0Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bt\u0010SR\u001a\u0010u\u001a\b\u0012\u0004\u0012\u00020\u000f0Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bu\u0010SR\u001a\u0010v\u001a\b\u0012\u0004\u0012\u00020\u000f0Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bv\u0010SR\u001a\u0010w\u001a\b\u0012\u0004\u0012\u00020\u000f0Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bw\u0010SR\u001a\u0010x\u001a\b\u0012\u0004\u0012\u00020\u000f0Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bx\u0010SR \u0010z\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020y0\u00040Q8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\bz\u0010SR \u0010{\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u00040\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b{\u0010|R\u0014\u0010~\u001a\u00020}8\u0002X\u0083D\u00a2\u0006\u0006\n\u0004\b~\u0010\u007fR#\u0010\u0084\u0001\u001a\u000200*\n\u0012\u0005\u0012\u00030\u0081\u00010\u0080\u00018BX\u0082\u0004\u00a2\u0006\b\u001a\u0006\b\u0082\u0001\u0010\u0083\u0001R$\u0010\u0085\u0001\u001a\u0010\u0012\f\u0012\n\u0012\u0005\u0012\u00030\u0081\u00010\u0080\u00010Q8\u0006X\u0087\u0004\u00a2\u0006\u0007\n\u0005\b\u0085\u0001\u0010SR\u0018\u0010\u0087\u0001\u001a\u00030\u0086\u00018\u0006X\u0087\u0004\u00a2\u0006\b\n\u0006\b\u0087\u0001\u0010\u0088\u0001R\u0018\u0010\u008a\u0001\u001a\u00030\u0089\u00018\u0006X\u0087\u0004\u00a2\u0006\b\n\u0006\b\u008a\u0001\u0010\u008b\u0001R\u0018\u0010\u008c\u0001\u001a\u00030\u0086\u00018\u0006X\u0087\u0004\u00a2\u0006\b\n\u0006\b\u008c\u0001\u0010\u0088\u0001R\u0018\u0010\u008d\u0001\u001a\u00030\u0086\u00018\u0006X\u0087\u0004\u00a2\u0006\b\n\u0006\b\u008d\u0001\u0010\u0088\u0001R\u0018\u0010\u008e\u0001\u001a\u00030\u0086\u00018\u0006X\u0087\u0004\u00a2\u0006\b\n\u0006\b\u008e\u0001\u0010\u0088\u0001R\u0018\u0010\u008f\u0001\u001a\u00030\u0086\u00018\u0006X\u0087\u0004\u00a2\u0006\b\n\u0006\b\u008f\u0001\u0010\u0088\u0001R\u0018\u0010\u0090\u0001\u001a\u00030\u0086\u00018\u0006X\u0087\u0004\u00a2\u0006\b\n\u0006\b\u0090\u0001\u0010\u0088\u0001R\u0018\u0010\u0091\u0001\u001a\u00030\u0086\u00018\u0006X\u0087\u0004\u00a2\u0006\b\n\u0006\b\u0091\u0001\u0010\u0088\u0001R\u0018\u0010\u0092\u0001\u001a\u00030\u0086\u00018\u0006X\u0087\u0004\u00a2\u0006\b\n\u0006\b\u0092\u0001\u0010\u0088\u0001R\"\u0010\u0093\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020^0\u00040\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0007\n\u0005\b\u0093\u0001\u0010|"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/Renderers;", "", "<init>", "()V", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "descriptors", "", "renderAmbiguousDescriptors", "(Ljava/util/Collection;)Ljava/lang/String;", "T", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticParameterRenderer;", "itemRenderer", "commaSeparated", "(Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticParameterRenderer;)Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticParameterRenderer;", "Lorg/jetbrains/kotlin/resolve/calls/inference/InferenceErrorData;", "inferenceErrorData", "Lorg/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer;", "result", "renderConflictingSubstitutionsInferenceError", "(Lorg/jetbrains/kotlin/resolve/calls/inference/InferenceErrorData;Lorg/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer;)Lorg/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer;", "renderer", "renderParameterConstraintError", "renderNoInformationForParameterError", "renderUpperBoundViolatedInferenceError", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem;", "systemWithoutWeakConstraints", "renderUpperBoundViolatedInferenceErrorForTypeAliasConstructor", "(Lorg/jetbrains/kotlin/resolve/calls/inference/InferenceErrorData;Lorg/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer;Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem;)Lorg/jetbrains/kotlin/diagnostics/rendering/TabledDescriptorRenderer;", "renderCannotCaptureTypeParameterError", "Lorg/jetbrains/kotlin/types/KotlinType;", "types", "typeRenderer", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;", "context", "renderTypes", "(Ljava/util/Collection;Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticParameterRenderer;Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;)Ljava/lang/String;", "constraintSystem", "Lorg/jetbrains/kotlin/diagnostics/rendering/Renderers$ConstraintSystemRenderingVerbosity;", "verbosity", "renderConstraintSystem", "(Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem;Lorg/jetbrains/kotlin/diagnostics/rendering/Renderers$ConstraintSystemRenderingVerbosity;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds;", "typeBounds", "renderTypeBounds", "(Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds;Lorg/jetbrains/kotlin/diagnostics/rendering/Renderers$ConstraintSystemRenderingVerbosity;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "typeVariable", "", "includeTypeConstructor", "renderTypeVariable", "(Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;Z)Ljava/lang/String;", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$Bound;", "bound", "renderTypeBound", "(Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$Bound;Lorg/jetbrains/kotlin/diagnostics/rendering/Renderers$ConstraintSystemRenderingVerbosity;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "typeConstructor", "renderTypeConstructor", "(Lorg/jetbrains/kotlin/types/TypeConstructor;)Ljava/lang/String;", "message", "debugMessage", "(Ljava/lang/String;Lorg/jetbrains/kotlin/resolve/calls/inference/InferenceErrorData;Lorg/jetbrains/kotlin/diagnostics/rendering/Renderers$ConstraintSystemRenderingVerbosity;)Ljava/lang/String;", "wrapIntoQuotes", "(Ljava/lang/String;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/name/Name;", "(Lorg/jetbrains/kotlin/name/Name;)Ljava/lang/String;", "type", "", "dataFlowTypes", "renderExpressionType", "(Lorg/jetbrains/kotlin/types/KotlinType;Ljava/util/Set;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "fqName", "typeCall", "renderCallInfo", "(Lorg/jetbrains/kotlin/name/FqNameUnsafe;Ljava/lang/String;)Ljava/lang/String;", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/kotlin/diagnostics/rendering/ContextIndependentParameterRenderer;", "TO_STRING", "Lorg/jetbrains/kotlin/diagnostics/rendering/ContextIndependentParameterRenderer;", "NOT_RENDERED", "Lorg/jetbrains/kotlin/descriptors/Named;", "NAME", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "FQ_NAME", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "MODULE_WITH_PLATFORM", "MODULE", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "VISIBILITY", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "DECLARATION_NAME_WITH_KIND", "CAPITALIZED_DECLARATION_NAME_WITH_KIND_AND_PLATFORM", "NAME_OF_CONTAINING_DECLARATION_OR_FILE", "Lcom/intellij/psi/PsiElement;", "ELEMENT_TEXT", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "DECLARATION_NAME", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "RENDER_CLASS_OR_OBJECT", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;", "RENDER_CLASS_OR_OBJECT_NAME", "Lorg/jetbrains/kotlin/diagnostics/rendering/SmartTypeRenderer;", "RENDER_TYPE", "Lorg/jetbrains/kotlin/diagnostics/rendering/SmartTypeRenderer;", "RENDER_TYPE_WITH_ANNOTATIONS", "Lorg/jetbrains/kotlin/types/TypeProjection;", "TYPE_PROJECTION", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "AMBIGUOUS_CALLS", "COMPATIBILITY_CANDIDATE", "AMBIGUOUS_CALLABLE_REFERENCES", "TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER", "TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR_RENDERER", "TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER", "TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER", "TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "CLASSES_OR_SEPARATED", "RENDER_COLLECTION_OF_TYPES", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticParameterRenderer;", "", "WHEN_MISSING_LIMIT", "I", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "getAssumesElseBranchOnly", "(Ljava/util/List;)Z", "assumesElseBranchOnly", "RENDER_WHEN_MISSING_CASES", "Lorg/jetbrains/kotlin/diagnostics/rendering/SmartDescriptorRenderer;", "FQ_NAMES_IN_TYPES", "Lorg/jetbrains/kotlin/diagnostics/rendering/SmartDescriptorRenderer;", "Lorg/jetbrains/kotlin/diagnostics/rendering/AnnotationsWhitelistDescriptorRenderer;", "FQ_NAMES_IN_TYPES_ANNOTATIONS_WHITELIST", "Lorg/jetbrains/kotlin/diagnostics/rendering/AnnotationsWhitelistDescriptorRenderer;", "FQ_NAMES_IN_TYPES_WITH_ANNOTATIONS", "COMPACT", "COMPACT_WITHOUT_SUPERTYPES", "WITHOUT_MODIFIERS", "SHORT_NAMES_IN_TYPES", "COMPACT_WITH_MODIFIERS", "DEPRECATION_RENDERER", "DESCRIPTORS_ON_NEWLINE_WITH_INDENT", "ConstraintSystemRenderingVerbosity"})
public final class Renderers {
    @NotNull
    public static final Renderers INSTANCE = new Renderers();
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final ContextIndependentParameterRenderer<Object> TO_STRING;
    @NotNull
    public static final ContextIndependentParameterRenderer<Object> NOT_RENDERED;
    @NotNull
    public static final ContextIndependentParameterRenderer<Named> NAME;
    @NotNull
    public static final ContextIndependentParameterRenderer<MemberDescriptor> FQ_NAME;
    @NotNull
    public static final ContextIndependentParameterRenderer<ModuleDescriptor> MODULE_WITH_PLATFORM;
    @NotNull
    public static final ContextIndependentParameterRenderer<ModuleDescriptor> MODULE;
    @NotNull
    public static final ContextIndependentParameterRenderer<DescriptorVisibility> VISIBILITY;
    @NotNull
    public static final ContextIndependentParameterRenderer<DeclarationDescriptor> DECLARATION_NAME_WITH_KIND;
    @NotNull
    public static final ContextIndependentParameterRenderer<DeclarationDescriptor> CAPITALIZED_DECLARATION_NAME_WITH_KIND_AND_PLATFORM;
    @NotNull
    public static final ContextIndependentParameterRenderer<DeclarationDescriptor> NAME_OF_CONTAINING_DECLARATION_OR_FILE;
    @NotNull
    public static final ContextIndependentParameterRenderer<PsiElement> ELEMENT_TEXT;
    @NotNull
    public static final ContextIndependentParameterRenderer<KtNamedDeclaration> DECLARATION_NAME;
    @NotNull
    public static final ContextIndependentParameterRenderer<KtClassOrObject> RENDER_CLASS_OR_OBJECT;
    @NotNull
    public static final ContextIndependentParameterRenderer<ClassifierDescriptorWithTypeParameters> RENDER_CLASS_OR_OBJECT_NAME;
    @NotNull
    public static final SmartTypeRenderer RENDER_TYPE;
    @NotNull
    public static final SmartTypeRenderer RENDER_TYPE_WITH_ANNOTATIONS;
    @NotNull
    public static final ContextIndependentParameterRenderer<TypeProjection> TYPE_PROJECTION;
    @NotNull
    public static final ContextIndependentParameterRenderer<Collection<? extends ResolvedCall<?>>> AMBIGUOUS_CALLS;
    @NotNull
    public static final ContextIndependentParameterRenderer<CallableDescriptor> COMPATIBILITY_CANDIDATE;
    @NotNull
    public static final ContextIndependentParameterRenderer<Collection<? extends CallableDescriptor>> AMBIGUOUS_CALLABLE_REFERENCES;
    @NotNull
    public static final ContextIndependentParameterRenderer<InferenceErrorData> TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER;
    @NotNull
    public static final ContextIndependentParameterRenderer<InferenceErrorData> TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR_RENDERER;
    @NotNull
    public static final ContextIndependentParameterRenderer<InferenceErrorData> TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER;
    @NotNull
    public static final ContextIndependentParameterRenderer<InferenceErrorData> TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER;
    @NotNull
    public static final ContextIndependentParameterRenderer<InferenceErrorData> TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER;
    @NotNull
    public static final ContextIndependentParameterRenderer<Collection<? extends ClassDescriptor>> CLASSES_OR_SEPARATED;
    @NotNull
    public static final DiagnosticParameterRenderer<Collection<? extends KotlinType>> RENDER_COLLECTION_OF_TYPES;
    private static final int WHEN_MISSING_LIMIT;
    @NotNull
    public static final ContextIndependentParameterRenderer<List<? extends WhenMissingCase>> RENDER_WHEN_MISSING_CASES;
    @NotNull
    public static final SmartDescriptorRenderer FQ_NAMES_IN_TYPES;
    @NotNull
    public static final AnnotationsWhitelistDescriptorRenderer FQ_NAMES_IN_TYPES_ANNOTATIONS_WHITELIST;
    @NotNull
    public static final SmartDescriptorRenderer FQ_NAMES_IN_TYPES_WITH_ANNOTATIONS;
    @NotNull
    public static final SmartDescriptorRenderer COMPACT;
    @NotNull
    public static final SmartDescriptorRenderer COMPACT_WITHOUT_SUPERTYPES;
    @NotNull
    public static final SmartDescriptorRenderer WITHOUT_MODIFIERS;
    @NotNull
    public static final SmartDescriptorRenderer SHORT_NAMES_IN_TYPES;
    @NotNull
    public static final SmartDescriptorRenderer COMPACT_WITH_MODIFIERS;
    @NotNull
    public static final SmartDescriptorRenderer DEPRECATION_RENDERER;
    @NotNull
    public static final DiagnosticParameterRenderer<Collection<? extends DeclarationDescriptor>> DESCRIPTORS_ON_NEWLINE_WITH_INDENT;

    private Renderers() {
    }

    private final String renderAmbiguousDescriptors(Collection<? extends CallableDescriptor> descriptors) {
        RenderingContext.Impl context = new RenderingContext.Impl(descriptors);
        Iterable iterable = descriptors;
        MemberComparator memberComparator = MemberComparator.INSTANCE;
        Intrinsics.checkNotNullExpressionValue(memberComparator, "INSTANCE");
        return CollectionsKt.joinToString$default(CollectionsKt.sortedWith(iterable, memberComparator), "\n", "\n", null, 0, null, arg_0 -> Renderers.renderAmbiguousDescriptors$lambda$22(context, arg_0), 28, null);
    }

    @NotNull
    public static final <T> DiagnosticParameterRenderer<Collection<? extends T>> commaSeparated(@NotNull DiagnosticParameterRenderer<? super T> itemRenderer) {
        Intrinsics.checkNotNullParameter(itemRenderer, "itemRenderer");
        return CommonRenderers.commaSeparated(itemRenderer);
    }

    @NotNull
    public static final TabledDescriptorRenderer renderConflictingSubstitutionsInferenceError(@NotNull InferenceErrorData inferenceErrorData, @NotNull TabledDescriptorRenderer result2) {
        Intrinsics.checkNotNullParameter(inferenceErrorData, "inferenceErrorData");
        Intrinsics.checkNotNullParameter(result2, "result");
        LOG.assertTrue(inferenceErrorData.constraintSystem.getStatus().hasConflictingConstraints(), Renderers.debugMessage$default(INSTANCE, "Conflicting substitutions inference error renderer is applied for incorrect status", inferenceErrorData, null, 4, null));
        ArrayList<CallableDescriptor> substitutedDescriptors = Lists.newArrayList();
        Collection<TypeSubstitutor> collection = ConstraintsUtil.getSubstitutorsForConflictingParameters(inferenceErrorData.constraintSystem);
        Intrinsics.checkNotNullExpressionValue(collection, "getSubstitutorsForConflictingParameters(...)");
        Collection<TypeSubstitutor> substitutors = collection;
        for (TypeSubstitutor substitutor2 : substitutors) {
            CallableDescriptor callableDescriptor = inferenceErrorData.descriptor;
            Intrinsics.checkNotNull(substitutor2);
            CallableDescriptor substitutedDescriptor = (CallableDescriptor)callableDescriptor.substitute(substitutor2);
            substitutedDescriptors.add(substitutedDescriptor);
        }
        TypeVariable firstConflictingVariable = ConstraintsUtil.getFirstConflictingVariable(inferenceErrorData.constraintSystem);
        if (firstConflictingVariable == null) {
            LOG.error(Renderers.debugMessage$default(INSTANCE, "There is no conflicting parameter for 'conflicting constraints' error.", inferenceErrorData, null, 4, null));
            return result2;
        }
        result2.text(TabledDescriptorRenderer.newText().normal("Cannot infer type parameter ").strong(firstConflictingVariable.getName()).normal(" in "));
        TabledDescriptorRenderer.TableRenderer table = TabledDescriptorRenderer.newTable();
        result2.table(table);
        table.descriptor(inferenceErrorData.descriptor).text("None of the following substitutions");
        Iterator iterator2 = substitutedDescriptors.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            CallableDescriptor substitutedDescriptor = (CallableDescriptor)iterator3.next();
            KotlinType receiverType = DescriptorUtils.getReceiverParameterType(substitutedDescriptor.getExtensionReceiverParameter());
            HashSet<ConstraintPosition> errorPositions = new HashSet<ConstraintPosition>();
            ArrayList<KotlinType> parameterTypes = Lists.newArrayList();
            for (ValueParameterDescriptor valueParameterDescriptor : substitutedDescriptor.getValueParameters()) {
                KotlinType actualType;
                parameterTypes.add(valueParameterDescriptor.getType());
                if (valueParameterDescriptor.getIndex() >= inferenceErrorData.valueArgumentsTypes.size() || KotlinTypeChecker.DEFAULT.isSubtypeOf(actualType = inferenceErrorData.valueArgumentsTypes.get(valueParameterDescriptor.getIndex()), valueParameterDescriptor.getType())) continue;
                errorPositions.add(ConstraintPositionKind.VALUE_PARAMETER_POSITION.position(valueParameterDescriptor.getIndex()));
            }
            if (receiverType != null && inferenceErrorData.receiverArgumentType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(inferenceErrorData.receiverArgumentType, receiverType)) {
                errorPositions.add(ConstraintPositionKind.RECEIVER_POSITION.position());
            }
            table.functionArgumentTypeList(receiverType, (List<KotlinType>)parameterTypes, arg_0 -> Renderers.renderConflictingSubstitutionsInferenceError$lambda$28(errorPositions, arg_0));
        }
        table.text("can be applied to").functionArgumentTypeList(inferenceErrorData.receiverArgumentType, inferenceErrorData.valueArgumentsTypes);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final TabledDescriptorRenderer renderParameterConstraintError(@NotNull InferenceErrorData inferenceErrorData, @NotNull TabledDescriptorRenderer renderer) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ConstraintError it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(inferenceErrorData, "inferenceErrorData");
        Intrinsics.checkNotNullParameter(renderer, "renderer");
        List<ConstraintError> constraintErrors = inferenceErrorData.constraintSystem.getStatus().getConstraintErrors();
        Iterable $this$filter$iv = constraintErrors;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ConstraintError)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof ParameterConstraintError)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ConstraintError)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getConstraintPosition());
        }
        List errorPositions = (List)destination$iv$iv;
        TabledDescriptorRenderer tabledDescriptorRenderer = renderer.table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor).text("cannot be applied to").functionArgumentTypeList(inferenceErrorData.receiverArgumentType, inferenceErrorData.valueArgumentsTypes, arg_0 -> Renderers.renderParameterConstraintError$lambda$31(errorPositions, arg_0)));
        Intrinsics.checkNotNullExpressionValue(tabledDescriptorRenderer, "table(...)");
        return tabledDescriptorRenderer;
    }

    @NotNull
    public static final TabledDescriptorRenderer renderNoInformationForParameterError(@NotNull InferenceErrorData inferenceErrorData, @NotNull TabledDescriptorRenderer result2) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(inferenceErrorData, "inferenceErrorData");
            Intrinsics.checkNotNullParameter(result2, "result");
            Iterable $this$firstOrNull$iv = inferenceErrorData.constraintSystem.getTypeVariables();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TypeVariable variable = (TypeVariable)element$iv;
                boolean bl = false;
                if (!inferenceErrorData.constraintSystem.getTypeBounds(variable).getValues().isEmpty()) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        TypeVariable typeVariable = v0;
        if (typeVariable == null) {
            TabledDescriptorRenderer tabledDescriptorRenderer;
            TabledDescriptorRenderer $this$renderNoInformationForParameterError_u24lambda_u2433 = tabledDescriptorRenderer = result2;
            boolean bl = false;
            LOG.error(Renderers.debugMessage$default(INSTANCE, "There is no unknown parameter for 'no information for parameter error'.", inferenceErrorData, null, 4, null));
            return tabledDescriptorRenderer;
        }
        TypeVariable firstUnknownVariable = typeVariable;
        TabledDescriptorRenderer tabledDescriptorRenderer = result2.text(TabledDescriptorRenderer.newText().normal("Not enough information to infer parameter ").strong(firstUnknownVariable.getName()).normal(" in ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor).text("Please specify it explicitly."));
        Intrinsics.checkNotNullExpressionValue(tabledDescriptorRenderer, "table(...)");
        return tabledDescriptorRenderer;
    }

    @NotNull
    public static final TabledDescriptorRenderer renderUpperBoundViolatedInferenceError(@NotNull InferenceErrorData inferenceErrorData, @NotNull TabledDescriptorRenderer result2) {
        Object v2;
        Object $this$firstOrNull$iv;
        ConstraintSystem systemWithoutWeakConstraints;
        ConstraintSystemStatus status2;
        block8: {
            Intrinsics.checkNotNullParameter(inferenceErrorData, "inferenceErrorData");
            Intrinsics.checkNotNullParameter(result2, "result");
            ConstraintSystem constraintSystem = inferenceErrorData.constraintSystem;
            Intrinsics.checkNotNullExpressionValue(constraintSystem, "constraintSystem");
            ConstraintSystem constraintSystem2 = constraintSystem;
            status2 = constraintSystem2.getStatus();
            LOG.assertTrue(status2.hasViolatedUpperBound(), Renderers.debugMessage$default(INSTANCE, "Upper bound violated renderer is applied for incorrect status", inferenceErrorData, null, 4, null));
            systemWithoutWeakConstraints = ConstraintSystemUtilsKt.filterConstraintsOut(constraintSystem2, ConstraintPositionKind.TYPE_BOUND_POSITION);
            List<TypeParameterDescriptor> list = inferenceErrorData.descriptor.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list, "getTypeParameters(...)");
            $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            Iterator iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)element$iv;
                boolean bl = false;
                if (!(!ConstraintsUtil.checkUpperBoundIsSatisfied(systemWithoutWeakConstraints, typeParameterDescriptor, inferenceErrorData.call, true))) continue;
                v2 = element$iv;
                break block8;
            }
            v2 = null;
        }
        TypeParameterDescriptor typeParameterDescriptor = v2;
        if (typeParameterDescriptor == null) {
            TabledDescriptorRenderer tabledDescriptorRenderer;
            if (inferenceErrorData.descriptor instanceof TypeAliasConstructorDescriptor && ($this$firstOrNull$iv = INSTANCE.renderUpperBoundViolatedInferenceErrorForTypeAliasConstructor(inferenceErrorData, result2, systemWithoutWeakConstraints)) != null) {
                Object it = $this$firstOrNull$iv;
                boolean bl = false;
                return it;
            }
            if (status2.hasConflictingConstraints()) {
                tabledDescriptorRenderer = Renderers.renderConflictingSubstitutionsInferenceError(inferenceErrorData, result2);
            } else {
                LOG.error(INSTANCE.debugMessage("There is no type parameter with violated upper bound for 'upper bound violated' error", inferenceErrorData, ConstraintSystemRenderingVerbosity.EXTRA_VERBOSE));
                tabledDescriptorRenderer = result2;
            }
            return tabledDescriptorRenderer;
        }
        Call call2 = inferenceErrorData.call;
        Intrinsics.checkNotNullExpressionValue(call2, "call");
        TypeVariable typeVariable = ConstraintSystemUtilsKt.descriptorToVariable(systemWithoutWeakConstraints, TypeVariableKt.toHandle(call2), typeParameterDescriptor);
        KotlinType inferredValueForTypeParameter = systemWithoutWeakConstraints.getTypeBounds(typeVariable).getValue();
        if (inferredValueForTypeParameter == null) {
            LOG.error(Renderers.debugMessage$default(INSTANCE, "System without weak constraints is not successful, there is no value for type parameter " + typeParameterDescriptor.getName() + "\n: " + systemWithoutWeakConstraints, inferenceErrorData, null, 4, null));
            return result2;
        }
        result2.text(TabledDescriptorRenderer.newText().normal("Type parameter bound for ").strong(typeParameterDescriptor.getName()).normal(" in ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor));
        KotlinType violatedUpperBound = null;
        for (KotlinType kotlinType : typeParameterDescriptor.getUpperBounds()) {
            KotlinType upperBoundWithSubstitutedInferredTypes = systemWithoutWeakConstraints.getResultingSubstitutor().substitute(kotlinType, Variance.INVARIANT);
            if (upperBoundWithSubstitutedInferredTypes == null || KotlinTypeChecker.DEFAULT.isSubtypeOf(inferredValueForTypeParameter, upperBoundWithSubstitutedInferredTypes)) continue;
            violatedUpperBound = upperBoundWithSubstitutedInferredTypes;
            break;
        }
        if (violatedUpperBound == null) {
            LOG.error(Renderers.debugMessage$default(INSTANCE, "Type parameter (chosen as violating its upper bound)" + typeParameterDescriptor.getName() + " violates no bounds after substitution", inferenceErrorData, null, 4, null));
            return result2;
        }
        Object[] objectArray = new Object[]{inferredValueForTypeParameter, violatedUpperBound};
        RenderingContext context = RenderingContext.Companion.of(objectArray);
        DiagnosticParameterRenderer<KotlinType> diagnosticParameterRenderer = result2.getTypeRenderer();
        Intrinsics.checkNotNullExpressionValue(diagnosticParameterRenderer, "getTypeRenderer(...)");
        DiagnosticParameterRenderer<KotlinType> diagnosticParameterRenderer2 = diagnosticParameterRenderer;
        result2.text(TabledDescriptorRenderer.newText().normal(" is not satisfied: inferred type ").error(diagnosticParameterRenderer2.render(inferredValueForTypeParameter, context)).normal(" is not a subtype of ").strong(diagnosticParameterRenderer2.render(violatedUpperBound, context)));
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final TabledDescriptorRenderer renderUpperBoundViolatedInferenceErrorForTypeAliasConstructor(InferenceErrorData inferenceErrorData, TabledDescriptorRenderer result2, ConstraintSystem systemWithoutWeakConstraints) {
        Object[] it;
        void $this$mapTo$iv$iv;
        CallableDescriptor callableDescriptor = inferenceErrorData.descriptor;
        Intrinsics.checkNotNullExpressionValue(callableDescriptor, "descriptor");
        CallableDescriptor descriptor2 = callableDescriptor;
        if (!(descriptor2 instanceof TypeAliasConstructorDescriptor)) {
            LOG.error("Type alias constructor descriptor expected: " + descriptor2);
            return result2;
        }
        List<TypeParameterDescriptor> list = ((TypeAliasConstructorDescriptor)descriptor2).getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getTypeParameters(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Call call2 = inferenceErrorData.call;
            Intrinsics.checkNotNullExpressionValue(call2, "call");
            CallHandle callHandle = TypeVariableKt.toHandle(call2);
            Intrinsics.checkNotNull(it);
            TypeVariable typeVariable = ConstraintSystemUtilsKt.descriptorToVariable(systemWithoutWeakConstraints, callHandle, (TypeParameterDescriptor)it);
            collection.add(systemWithoutWeakConstraints.getTypeBounds(typeVariable).getValue());
        }
        List inferredTypesForTypeParameters = (List)destination$iv$iv;
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(new TypeConstructorSubstitution(descriptor2, inferredTypesForTypeParameters){
            final /* synthetic */ CallableDescriptor $descriptor;
            final /* synthetic */ List<KotlinType> $inferredTypesForTypeParameters;
            {
                this.$descriptor = $descriptor;
                this.$inferredTypesForTypeParameters = $inferredTypesForTypeParameters;
            }

            public TypeProjection get(TypeConstructor key) {
                TypeProjectionImpl typeProjectionImpl;
                Intrinsics.checkNotNullParameter(key, "key");
                ClassifierDescriptor classifierDescriptor = key.getDeclarationDescriptor();
                TypeParameterDescriptor typeParameterDescriptor = classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null;
                if (typeParameterDescriptor == null) {
                    return null;
                }
                TypeParameterDescriptor typeDescriptor = typeParameterDescriptor;
                if (!Intrinsics.areEqual(typeDescriptor.getContainingDeclaration(), ((TypeAliasConstructorDescriptor)this.$descriptor).getTypeAliasDescriptor())) {
                    return null;
                }
                KotlinType kotlinType = this.$inferredTypesForTypeParameters.get(typeDescriptor.getIndex());
                if (kotlinType != null) {
                    KotlinType p0 = kotlinType;
                    boolean bl = false;
                    typeProjectionImpl = new TypeProjectionImpl(p0);
                } else {
                    typeProjectionImpl = null;
                }
                return typeProjectionImpl;
            }
        });
        Intrinsics.checkNotNullExpressionValue(typeSubstitutor2, "create(...)");
        TypeSubstitutor inferredTypeSubstitutor2 = typeSubstitutor2;
        for (ConstraintError constraintError : inferenceErrorData.constraintSystem.getStatus().getConstraintErrors()) {
            ValidityConstraintForConstituentType validityConstraintForConstituentType = ConstraintPositionKt.getValidityConstraintForConstituentType(constraintError.getConstraintPosition());
            if (validityConstraintForConstituentType == null) continue;
            ValidityConstraintForConstituentType constraintInfo = validityConstraintForConstituentType;
            KotlinType kotlinType = inferredTypeSubstitutor2.safeSubstitute(constraintInfo.getBound(), Variance.INVARIANT);
            Intrinsics.checkNotNullExpressionValue(kotlinType, "safeSubstitute(...)");
            KotlinType violatedUpperBound = kotlinType;
            KotlinType kotlinType2 = inferredTypeSubstitutor2.safeSubstitute(constraintInfo.getTypeArgument(), Variance.INVARIANT);
            Intrinsics.checkNotNullExpressionValue(kotlinType2, "safeSubstitute(...)");
            KotlinType violatingInferredType = kotlinType2;
            it = new Object[]{violatingInferredType, violatedUpperBound};
            RenderingContext context = RenderingContext.Companion.of(it);
            DiagnosticParameterRenderer<KotlinType> diagnosticParameterRenderer = result2.getTypeRenderer();
            Intrinsics.checkNotNullExpressionValue(diagnosticParameterRenderer, "getTypeRenderer(...)");
            DiagnosticParameterRenderer<KotlinType> typeRenderer = diagnosticParameterRenderer;
            result2.text(TabledDescriptorRenderer.newText().normal("Type parameter bound for ").strong(constraintInfo.getTypeParameter().getName()).normal(" in type inferred from type alias expansion for ")).table(TabledDescriptorRenderer.newTable().descriptor(inferenceErrorData.descriptor));
            result2.text(TabledDescriptorRenderer.newText().normal(" is not satisfied: inferred type ").error(typeRenderer.render(violatingInferredType, context)).normal(" is not a subtype of ").strong(typeRenderer.render(violatedUpperBound, context)));
            return result2;
        }
        return null;
    }

    @NotNull
    public static final TabledDescriptorRenderer renderCannotCaptureTypeParameterError(@NotNull InferenceErrorData inferenceErrorData, @NotNull TabledDescriptorRenderer result2) {
        boolean element$iv3;
        CapturedTypeConstructor capturedTypeConstructor;
        TypeBounds.Bound boundWithCapturedType;
        Object object;
        Object v4;
        TypeVariable typeVariableWithCapturedConstraint;
        block6: {
            Object v1;
            ConstraintSystem system;
            block5: {
                Intrinsics.checkNotNullParameter(inferenceErrorData, "inferenceErrorData");
                Intrinsics.checkNotNullParameter(result2, "result");
                ConstraintSystem constraintSystem = inferenceErrorData.constraintSystem;
                Intrinsics.checkNotNullExpressionValue(constraintSystem, "constraintSystem");
                system = constraintSystem;
                List<ConstraintError> errors = system.getStatus().getConstraintErrors();
                Iterable $this$firstIsInstanceOrNull$iv = errors;
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv2 : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv2 instanceof CannotCapture)) continue;
                    v1 = element$iv2;
                    break block5;
                }
                v1 = null;
            }
            CannotCapture cannotCapture = v1;
            TypeVariable typeVariable = typeVariableWithCapturedConstraint = cannotCapture != null ? cannotCapture.getTypeVariable() : null;
            if (typeVariableWithCapturedConstraint == null) {
                LOG.error(Renderers.debugMessage$default(INSTANCE, "An error 'cannot capture type parameter' is not found in errors", inferenceErrorData, null, 4, null));
                return result2;
            }
            TypeBounds typeBounds = system.getTypeBounds(typeVariableWithCapturedConstraint);
            Iterable $this$firstOrNull$iv = typeBounds.getBounds();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv3 : $this$firstOrNull$iv) {
                TypeBounds.Bound it = (TypeBounds.Bound)element$iv3;
                boolean bl = false;
                if (!CapturedTypeConstructorKt.isCaptured(it.getConstrainingType())) continue;
                v4 = element$iv3;
                break block6;
            }
            v4 = null;
        }
        TypeConstructor $i$f$firstOrNull = (object = (boundWithCapturedType = (TypeBounds.Bound)v4)) != null && (object = ((TypeBounds.Bound)object).getConstrainingType()) != null ? ((KotlinType)object).getConstructor() : null;
        CapturedTypeConstructor capturedTypeConstructor2 = capturedTypeConstructor = $i$f$firstOrNull instanceof CapturedTypeConstructor ? (CapturedTypeConstructor)$i$f$firstOrNull : null;
        if (capturedTypeConstructor == null) {
            LOG.error(Renderers.debugMessage$default(INSTANCE, "There is no captured type in bounds, but there is an error 'cannot capture type parameter'", inferenceErrorData, null, 4, null));
            return result2;
        }
        TypeParameterDescriptor typeParameter = typeVariableWithCapturedConstraint.getOriginalTypeParameter();
        KotlinType kotlinType = TypeIntersector.getUpperBoundsAsType(typeParameter);
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getUpperBoundsAsType(...)");
        KotlinType upperBound = kotlinType;
        boolean bl = element$iv3 = !KotlinBuiltIns.isNullableAny(upperBound) && capturedTypeConstructor.getProjection().getProjectionKind() == Variance.IN_VARIANCE;
        if (_Assertions.ENABLED && !element$iv3) {
            boolean bl2 = false;
            String string2 = "There is the only reason to report TYPE_INFERENCE_CANNOT_CAPTURE_TYPES";
            throw new AssertionError((Object)string2);
        }
        Object[] objectArray = new Object[]{upperBound};
        String explanation = "Type parameter has an upper bound " + INSTANCE.wrapIntoQuotes(result2.getTypeRenderer().render(upperBound, RenderingContext.Companion.of(objectArray))) + " that cannot be satisfied capturing 'in' projection";
        TabledDescriptorRenderer.TextRenderer textRenderer = TabledDescriptorRenderer.newText();
        StringBuilder stringBuilder = new StringBuilder();
        Name name = typeParameter.getName();
        Intrinsics.checkNotNullExpressionValue(name, "getName(...)");
        objectArray = new Object[]{capturedTypeConstructor.getProjection()};
        result2.text(textRenderer.normal(stringBuilder.append(INSTANCE.wrapIntoQuotes(name)).append(" cannot capture ").append(INSTANCE.wrapIntoQuotes(result2.getTypeProjectionRenderer().render(capturedTypeConstructor.getProjection(), RenderingContext.Companion.of(objectArray)))).append(". ").append(explanation).toString()));
        return result2;
    }

    private final String renderTypes(Collection<? extends KotlinType> types2, DiagnosticParameterRenderer<? super KotlinType> typeRenderer, RenderingContext context) {
        String string2 = StringUtil.join(types2, arg_0 -> Renderers.renderTypes$lambda$42(arg_0 -> Renderers.renderTypes$lambda$41(typeRenderer, context, arg_0), arg_0), ", ");
        Intrinsics.checkNotNullExpressionValue(string2, "join(...)");
        return string2;
    }

    @NotNull
    public final String renderConstraintSystem(@NotNull ConstraintSystem constraintSystem, @NotNull ConstraintSystemRenderingVerbosity verbosity) {
        Intrinsics.checkNotNullParameter(constraintSystem, "constraintSystem");
        Intrinsics.checkNotNullParameter((Object)verbosity, "verbosity");
        LinkedHashSet<TypeBounds> typeBounds = new LinkedHashSet<TypeBounds>();
        for (TypeVariable variable : constraintSystem.getTypeVariables()) {
            typeBounds.add(constraintSystem.getTypeBounds(variable));
        }
        String separator = verbosity == ConstraintSystemRenderingVerbosity.EXTRA_VERBOSE ? "\n\n" : "\n";
        return "type parameter bounds:\n" + CollectionsKt.joinToString$default(typeBounds, separator, null, null, 0, null, arg_0 -> Renderers.renderConstraintSystem$lambda$44(verbosity, arg_0), 30, null) + "\n\nstatus:\n" + ConstraintsUtil.getDebugMessageForStatus(constraintSystem.getStatus());
    }

    private final String renderTypeBounds(TypeBounds typeBounds, ConstraintSystemRenderingVerbosity verbosity) {
        String string2;
        String renderedTypeVariable = this.renderTypeVariable(typeBounds.getTypeVariable(), verbosity == ConstraintSystemRenderingVerbosity.EXTRA_VERBOSE);
        if (typeBounds.getBounds().isEmpty()) {
            string2 = renderedTypeVariable;
        } else {
            String boundsPrefix = verbosity == ConstraintSystemRenderingVerbosity.EXTRA_VERBOSE ? "\n" : " ";
            String boundsSeparator = verbosity == ConstraintSystemRenderingVerbosity.EXTRA_VERBOSE ? "\n" : ", ";
            String renderedBounds = CollectionsKt.joinToString$default(typeBounds.getBounds(), boundsSeparator, null, null, 0, null, arg_0 -> Renderers.renderTypeBounds$lambda$45(verbosity, arg_0), 30, null);
            string2 = renderedTypeVariable + boundsPrefix + renderedBounds;
        }
        return string2;
    }

    private final String renderTypeVariable(TypeVariable typeVariable, boolean includeTypeConstructor) {
        String string2 = typeVariable.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        String typeVariableName = string2;
        if (!includeTypeConstructor) {
            return typeVariableName;
        }
        StringBuilder stringBuilder = new StringBuilder().append("TypeVariable ").append(typeVariableName).append(", descriptor = ").append(typeVariable.getFreshTypeParameter$frontend()).append(", typeConstructor = ");
        TypeConstructor typeConstructor2 = typeVariable.getFreshTypeParameter$frontend().getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue(typeConstructor2, "getTypeConstructor(...)");
        return stringBuilder.append(this.renderTypeConstructor(typeConstructor2)).toString();
    }

    private final String renderTypeBound(TypeBounds.Bound bound, ConstraintSystemRenderingVerbosity verbosity) {
        String string2;
        String string3;
        DescriptorRenderer typeRendered = verbosity == ConstraintSystemRenderingVerbosity.COMPACT ? DescriptorRenderer.SHORT_NAMES_IN_TYPES : DescriptorRenderer.FQ_NAMES_IN_TYPES;
        switch (WhenMappings.$EnumSwitchMapping$0[bound.getKind().ordinal()]) {
            case 1: {
                string3 = ">: ";
                break;
            }
            case 2: {
                string3 = "<: ";
                break;
            }
            default: {
                string3 = ":= ";
            }
        }
        String arrow = string3;
        String initialBoundRender = arrow + typeRendered.renderType(bound.getConstrainingType()) + (!bound.isProper() ? "*" : "");
        switch (WhenMappings.$EnumSwitchMapping$1[verbosity.ordinal()]) {
            case 1: {
                string2 = initialBoundRender;
                break;
            }
            case 2: {
                string2 = initialBoundRender + " (" + bound.getPosition() + ") ";
                break;
            }
            case 3: {
                StringBuilder stringBuilder = new StringBuilder().append(initialBoundRender).append(" (").append(bound.getPosition()).append(")\nConstraining type additional info: ").append(this.renderTypeConstructor(bound.getConstrainingType().getConstructor())).append("\nSupertypes of constraining type:\n");
                Set<KotlinType> set = TypeUtils.getAllSupertypes(bound.getConstrainingType());
                Intrinsics.checkNotNullExpressionValue(set, "getAllSupertypes(...)");
                string2 = stringBuilder.append(CollectionsKt.joinToString$default(set, "\n", null, null, 0, null, arg_0 -> Renderers.renderTypeBound$lambda$46(typeRendered, arg_0), 30, null)).append('\n').toString();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    private final String renderTypeConstructor(TypeConstructor typeConstructor2) {
        AbstractTypeConstructor abstractTypeConstructor = typeConstructor2 instanceof AbstractTypeConstructor ? (AbstractTypeConstructor)typeConstructor2 : null;
        return typeConstructor2 + '[' + typeConstructor2.getClass().getName() + "], " + (abstractTypeConstructor != null ? abstractTypeConstructor.renderAdditionalDebugInformation() : null);
    }

    private final String debugMessage(String message, InferenceErrorData inferenceErrorData, ConstraintSystemRenderingVerbosity verbosity) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder $this$debugMessage_u24lambda_u2447 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        $this$debugMessage_u24lambda_u2447.append(message);
        $this$debugMessage_u24lambda_u2447.append("\nConstraint system: \n");
        ConstraintSystem constraintSystem = inferenceErrorData.constraintSystem;
        Intrinsics.checkNotNullExpressionValue(constraintSystem, "constraintSystem");
        $this$debugMessage_u24lambda_u2447.append(INSTANCE.renderConstraintSystem(constraintSystem, verbosity));
        $this$debugMessage_u24lambda_u2447.append("\nDescriptor:\n");
        $this$debugMessage_u24lambda_u2447.append(inferenceErrorData.descriptor);
        $this$debugMessage_u24lambda_u2447.append("\nExpected type:\n");
        RenderingContext.Empty context = RenderingContext.Empty.INSTANCE;
        if (TypeUtils.noExpectedType(inferenceErrorData.expectedType)) {
            stringBuilder = $this$debugMessage_u24lambda_u2447.append(inferenceErrorData.expectedType);
        } else {
            KotlinType kotlinType = inferenceErrorData.expectedType;
            Intrinsics.checkNotNullExpressionValue(kotlinType, "expectedType");
            stringBuilder = $this$debugMessage_u24lambda_u2447.append(RENDER_TYPE_WITH_ANNOTATIONS.render(kotlinType, (RenderingContext)context));
        }
        $this$debugMessage_u24lambda_u2447.append("\nArgument types:\n");
        if (inferenceErrorData.receiverArgumentType != null) {
            $this$debugMessage_u24lambda_u2447.append(RENDER_TYPE_WITH_ANNOTATIONS.render(inferenceErrorData.receiverArgumentType, (RenderingContext)context)).append(".");
        }
        StringBuilder stringBuilder3 = $this$debugMessage_u24lambda_u2447.append("(");
        List<KotlinType> list = inferenceErrorData.valueArgumentsTypes;
        Intrinsics.checkNotNullExpressionValue(list, "valueArgumentsTypes");
        stringBuilder3.append(INSTANCE.renderTypes((Collection<? extends KotlinType>)list, RENDER_TYPE_WITH_ANNOTATIONS, context)).append(")");
        return stringBuilder2.toString();
    }

    static /* synthetic */ String debugMessage$default(Renderers renderers, String string2, InferenceErrorData inferenceErrorData, ConstraintSystemRenderingVerbosity constraintSystemRenderingVerbosity, int n, Object object) {
        if ((n & 4) != 0) {
            constraintSystemRenderingVerbosity = ConstraintSystemRenderingVerbosity.DEBUG;
        }
        return renderers.debugMessage(string2, inferenceErrorData, constraintSystemRenderingVerbosity);
    }

    private final String wrapIntoQuotes(String $this$wrapIntoQuotes) {
        return '\'' + $this$wrapIntoQuotes + '\'';
    }

    private final String wrapIntoQuotes(Name $this$wrapIntoQuotes) {
        return '\'' + $this$wrapIntoQuotes.asString() + '\'';
    }

    private final boolean getAssumesElseBranchOnly(List<? extends WhenMissingCase> $this$assumesElseBranchOnly) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$assumesElseBranchOnly;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    WhenMissingCase it = (WhenMissingCase)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual(it, WhenMissingCase.Unknown.INSTANCE) || it instanceof WhenMissingCase.ConditionTypeIsExpect)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String renderExpressionType(@Nullable KotlinType type2, @Nullable Set<? extends KotlinType> dataFlowTypes) {
        Set set;
        void $this$mapTo$iv$iv;
        if (type2 == null) {
            return "Type is unknown";
        }
        if (dataFlowTypes == null) {
            return DescriptorRenderer.DEBUG_TEXT.renderType(type2);
        }
        Iterable $this$map$iv = dataFlowTypes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DescriptorRenderer.DEBUG_TEXT.renderType((KotlinType)it));
        }
        Set $this$renderExpressionType_u24lambda_u2453 = set = CollectionsKt.toMutableSet((List)destination$iv$iv);
        boolean bl = false;
        $this$renderExpressionType_u24lambda_u2453.add(DescriptorRenderer.DEBUG_TEXT.renderType(type2));
        Set typesAsString = set;
        return CollectionsKt.joinToString$default(CollectionsKt.sorted(typesAsString), " & ", null, null, 0, null, null, 62, null);
    }

    @NotNull
    public final String renderCallInfo(@Nullable FqNameUnsafe fqName2, @NotNull String typeCall) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(typeCall, "typeCall");
        StringBuilder $this$renderCallInfo_u24lambda_u2454 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = new StringBuilder().append("fqName: ");
        Object object = fqName2;
        if (object == null || (object = ((FqNameUnsafe)object).asString()) == null) {
            object = "fqName is unknown";
        }
        $this$renderCallInfo_u24lambda_u2454.append(stringBuilder2.append((String)object).append("; ").toString());
        $this$renderCallInfo_u24lambda_u2454.append("typeCall: " + typeCall);
        return stringBuilder.toString();
    }

    private static final String TO_STRING$lambda$0(Object element) {
        Intrinsics.checkNotNullParameter(element, "element");
        if (element instanceof DeclarationDescriptor) {
            LOG.warn("Diagnostic renderer TO_STRING was used to render an instance of DeclarationDescriptor.\nThis is usually a bad idea, because descriptors' toString() includes some debug information, which should not be seen by the user.\nDescriptor: " + element);
        }
        return element.toString();
    }

    private static final String NOT_RENDERED$lambda$1(Object object) {
        return "";
    }

    private static final String NAME$lambda$2(Named it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string2 = it.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        return string2;
    }

    private static final String FQ_NAME$lambda$3(MemberDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return DescriptorUtilsKt.getFqNameSafe(it).asString();
    }

    private static final String MODULE_WITH_PLATFORM$lambda$4(ModuleDescriptor module2) {
        Intrinsics.checkNotNullParameter(module2, "module");
        TargetPlatform platform = module2.getPlatform();
        String moduleName = MODULE.render(module2);
        String platformNameIfAny = platform == null || TargetPlatformKt.isCommon(platform) ? "" : " for " + ((SimplePlatform)CollectionsKt.single(platform)).getPlatformName();
        return moduleName + platformNameIfAny;
    }

    private static final String MODULE$lambda$5(ModuleDescriptor module2) {
        Intrinsics.checkNotNullParameter(module2, "module");
        Object object = ModuleInfoUtilsKt.getModuleInfo(module2);
        if (object == null || (object = ModuleSourceInfoBaseKt.unwrapPlatform((ModuleInfo)object)) == null || (object = object.getDisplayedName()) == null) {
            String string2 = module2.getName().asString();
            object = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        }
        return object;
    }

    private static final String VISIBILITY$lambda$6(DescriptorVisibility it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getExternalDisplayName();
    }

    private static final String DECLARATION_NAME_WITH_KIND$lambda$7(DeclarationDescriptor it) {
        String string2;
        Intrinsics.checkNotNullParameter(it, "it");
        String string3 = it.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string3, "asString(...)");
        String name = string3;
        DeclarationDescriptor declarationDescriptor = it;
        if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            string2 = "package '" + name + '\'';
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            string2 = DiagnosticRendererUtilKt.renderKind((ClassDescriptor)it) + " '" + name + '\'';
        } else if (declarationDescriptor instanceof TypeAliasDescriptor) {
            string2 = "typealias '" + name + '\'';
        } else if (declarationDescriptor instanceof TypeAliasConstructorDescriptor) {
            string2 = "constructor of '" + ((TypeAliasConstructorDescriptor)it).getTypeAliasDescriptor().getName().asString() + '\'';
        } else if (declarationDescriptor instanceof ConstructorDescriptor) {
            string2 = "constructor of '" + ((ConstructorDescriptor)it).getConstructedClass().getName().asString() + '\'';
        } else if (declarationDescriptor instanceof PropertyGetterDescriptor) {
            string2 = "getter of property '" + ((PropertyGetterDescriptor)it).getCorrespondingProperty().getName().asString() + '\'';
        } else if (declarationDescriptor instanceof PropertySetterDescriptor) {
            string2 = "setter of property '" + ((PropertySetterDescriptor)it).getCorrespondingProperty().getName().asString() + '\'';
        } else if (declarationDescriptor instanceof FunctionDescriptor) {
            string2 = "function '" + name + '\'';
        } else if (declarationDescriptor instanceof PropertyDescriptor) {
            string2 = "property '" + name + '\'';
        } else {
            throw new AssertionError((Object)("Unexpected declaration kind: " + it));
        }
        return string2;
    }

    private static final String CAPITALIZED_DECLARATION_NAME_WITH_KIND_AND_PLATFORM$lambda$8(DeclarationDescriptor descriptor2) {
        String string2;
        String withPlatform;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        String declarationWithNameAndKind = DECLARATION_NAME_WITH_KIND.render(descriptor2);
        String string3 = withPlatform = descriptor2 instanceof MemberDescriptor && ((MemberDescriptor)descriptor2).isActual() ? "actual " + declarationWithNameAndKind : declarationWithNameAndKind;
        if (((CharSequence)string3).length() > 0) {
            char p0 = string3.charAt(0);
            boolean bl = false;
            char c = Character.toUpperCase(p0);
            String string4 = string3;
            int n = 1;
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
            string4 = string5;
            string2 = c + string4;
        } else {
            string2 = string3;
        }
        return string2;
    }

    private static final String NAME_OF_CONTAINING_DECLARATION_OR_FILE$lambda$9(DeclarationDescriptor it) {
        String string2;
        Intrinsics.checkNotNullParameter(it, "it");
        if (DescriptorUtils.isTopLevelDeclaration(it) && it instanceof DeclarationDescriptorWithVisibility && Intrinsics.areEqual(((DeclarationDescriptorWithVisibility)it).getVisibility(), DescriptorVisibilities.PRIVATE)) {
            string2 = "file";
        } else {
            DeclarationDescriptor containingDeclaration = it.getContainingDeclaration();
            if (containingDeclaration instanceof PackageFragmentDescriptor) {
                string2 = INSTANCE.wrapIntoQuotes(((PackageFragmentDescriptor)containingDeclaration).getFqName().asString());
            } else {
                DeclarationDescriptor declarationDescriptor = containingDeclaration;
                Intrinsics.checkNotNull(declarationDescriptor);
                String string3 = declarationDescriptor.getName().asString();
                Intrinsics.checkNotNullExpressionValue(string3, "asString(...)");
                string2 = INSTANCE.wrapIntoQuotes(string3);
            }
        }
        return string2;
    }

    private static final String ELEMENT_TEXT$lambda$10(PsiElement it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string2 = it.getText();
        Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
        return string2;
    }

    private static final String DECLARATION_NAME$lambda$11(KtNamedDeclaration it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string2 = it.getNameAsSafeName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        return string2;
    }

    private static final String RENDER_CLASS_OR_OBJECT$lambda$13(KtClassOrObject classOrObject) {
        String string2;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(classOrObject, "classOrObject");
                string2 = classOrObject.getName();
                if (string2 == null) break block2;
                String it = string2;
                boolean bl = false;
                String string3 = ' ' + INSTANCE.wrapIntoQuotes(it);
                string2 = string3;
                if (string3 != null) break block3;
            }
            string2 = "";
        }
        String name = string2;
        return !(classOrObject instanceof KtClass) ? "Object" + name : (((KtClass)classOrObject).isInterface() ? "Interface" + name : "Class" + name);
    }

    private static final String RENDER_CLASS_OR_OBJECT_NAME$lambda$14(ClassifierDescriptorWithTypeParameters it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return DiagnosticRendererUtilKt.renderKindWithName(it);
    }

    private static final Unit RENDER_TYPE$lambda$15(DescriptorRendererOptions $this$withOptions) {
        Intrinsics.checkNotNullParameter($this$withOptions, "$this$withOptions");
        $this$withOptions.setParameterNamesInFunctionalTypes(false);
        return Unit.INSTANCE;
    }

    private static final Unit RENDER_TYPE_WITH_ANNOTATIONS$lambda$16(DescriptorRendererOptions $this$withOptions) {
        Intrinsics.checkNotNullParameter($this$withOptions, "$this$withOptions");
        $this$withOptions.setParameterNamesInFunctionalTypes(false);
        return Unit.INSTANCE;
    }

    private static final String TYPE_PROJECTION$lambda$17(TypeProjection projection) {
        String string2;
        Intrinsics.checkNotNullParameter(projection, "projection");
        if (projection.isStarProjection()) {
            string2 = "*";
        } else if (projection.getProjectionKind() == Variance.INVARIANT) {
            KotlinType kotlinType = projection.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            Object[] objectArray = new Object[]{projection.getType()};
            string2 = RENDER_TYPE.render(kotlinType, RenderingContext.Companion.of(objectArray));
        } else {
            StringBuilder stringBuilder = new StringBuilder().append((Object)projection.getProjectionKind()).append(' ');
            KotlinType kotlinType = projection.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            Object[] objectArray = new Object[]{projection.getType()};
            string2 = stringBuilder.append(RENDER_TYPE.render(kotlinType, RenderingContext.Companion.of(objectArray))).toString();
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private static final String AMBIGUOUS_CALLS$lambda$19(Collection calls) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(calls, "calls");
        Iterable $this$map$iv = calls;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResolvedCall resolvedCall2 = (ResolvedCall)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object d = it.getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue(d, "getResultingDescriptor(...)");
            collection.add(d);
        }
        List descriptors = (List)destination$iv$iv;
        return INSTANCE.renderAmbiguousDescriptors(descriptors);
    }

    private static final String COMPATIBILITY_CANDIDATE$lambda$20(CallableDescriptor call2) {
        Intrinsics.checkNotNullParameter(call2, "call");
        return INSTANCE.renderAmbiguousDescriptors((Collection<? extends CallableDescriptor>)CollectionsKt.listOf(call2));
    }

    private static final String AMBIGUOUS_CALLABLE_REFERENCES$lambda$21(Collection references) {
        Intrinsics.checkNotNullParameter(references, "references");
        return INSTANCE.renderAmbiguousDescriptors(references);
    }

    private static final CharSequence renderAmbiguousDescriptors$lambda$22(RenderingContext.Impl $context, CallableDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return FQ_NAMES_IN_TYPES.render(it, (RenderingContext)$context);
    }

    private static final String TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER$lambda$23(InferenceErrorData it) {
        Intrinsics.checkNotNullParameter(it, "it");
        TabledDescriptorRenderer tabledDescriptorRenderer = TabledDescriptorRenderer.create();
        Intrinsics.checkNotNullExpressionValue(tabledDescriptorRenderer, "create(...)");
        String string2 = Renderers.renderConflictingSubstitutionsInferenceError(it, tabledDescriptorRenderer).toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    private static final String TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR_RENDERER$lambda$24(InferenceErrorData it) {
        Intrinsics.checkNotNullParameter(it, "it");
        TabledDescriptorRenderer tabledDescriptorRenderer = TabledDescriptorRenderer.create();
        Intrinsics.checkNotNullExpressionValue(tabledDescriptorRenderer, "create(...)");
        String string2 = Renderers.renderParameterConstraintError(it, tabledDescriptorRenderer).toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    private static final String TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER$lambda$25(InferenceErrorData it) {
        Intrinsics.checkNotNullParameter(it, "it");
        TabledDescriptorRenderer tabledDescriptorRenderer = TabledDescriptorRenderer.create();
        Intrinsics.checkNotNullExpressionValue(tabledDescriptorRenderer, "create(...)");
        String string2 = Renderers.renderNoInformationForParameterError(it, tabledDescriptorRenderer).toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    private static final String TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER$lambda$26(InferenceErrorData it) {
        Intrinsics.checkNotNullParameter(it, "it");
        TabledDescriptorRenderer tabledDescriptorRenderer = TabledDescriptorRenderer.create();
        Intrinsics.checkNotNullExpressionValue(tabledDescriptorRenderer, "create(...)");
        String string2 = Renderers.renderUpperBoundViolatedInferenceError(it, tabledDescriptorRenderer).toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    private static final String TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER$lambda$27(InferenceErrorData it) {
        Intrinsics.checkNotNullParameter(it, "it");
        TabledDescriptorRenderer tabledDescriptorRenderer = TabledDescriptorRenderer.create();
        Intrinsics.checkNotNullExpressionValue(tabledDescriptorRenderer, "create(...)");
        String string2 = Renderers.renderCannotCaptureTypeParameterError(it, tabledDescriptorRenderer).toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    private static final boolean renderConflictingSubstitutionsInferenceError$lambda$28(HashSet $errorPositions, ConstraintPosition it) {
        return $errorPositions.contains(it);
    }

    private static final boolean renderParameterConstraintError$lambda$31(List $errorPositions, ConstraintPosition it) {
        return $errorPositions.contains(it);
    }

    private static final String CLASSES_OR_SEPARATED$lambda$40(Collection descriptors) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(descriptors, "descriptors");
        StringBuilder $this$CLASSES_OR_SEPARATED_u24lambda_u2440_u24lambda_u2439 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int index2 = 0;
        for (ClassDescriptor descriptor2 : descriptors) {
            $this$CLASSES_OR_SEPARATED_u24lambda_u2440_u24lambda_u2439.append(DescriptorUtils.getFqName(descriptor2).asString());
            if (++index2 <= descriptors.size() - 2) {
                $this$CLASSES_OR_SEPARATED_u24lambda_u2440_u24lambda_u2439.append(", ");
                continue;
            }
            if (index2 != descriptors.size() - 1) continue;
            $this$CLASSES_OR_SEPARATED_u24lambda_u2440_u24lambda_u2439.append(" or ");
        }
        return stringBuilder.toString();
    }

    private static final String renderTypes$lambda$41(DiagnosticParameterRenderer $typeRenderer, RenderingContext $context, KotlinType it) {
        Intrinsics.checkNotNull(it);
        return $typeRenderer.render(it, $context);
    }

    private static final String renderTypes$lambda$42(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String RENDER_COLLECTION_OF_TYPES$lambda$43(Collection types2, RenderingContext context) {
        Intrinsics.checkNotNullParameter(types2, "types");
        Intrinsics.checkNotNullParameter(context, "context");
        return INSTANCE.renderTypes(types2, RENDER_TYPE, context);
    }

    private static final CharSequence renderConstraintSystem$lambda$44(ConstraintSystemRenderingVerbosity $verbosity, TypeBounds it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return INSTANCE.renderTypeBounds(it, $verbosity);
    }

    private static final CharSequence renderTypeBounds$lambda$45(ConstraintSystemRenderingVerbosity $verbosity, TypeBounds.Bound it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return INSTANCE.renderTypeBound(it, $verbosity);
    }

    private static final CharSequence renderTypeBound$lambda$46(DescriptorRenderer $typeRendered, KotlinType it) {
        StringBuilder stringBuilder = new StringBuilder().append("- ");
        Intrinsics.checkNotNull(it);
        return stringBuilder.append($typeRendered.renderType(it)).append(", TypeConstructor info: ").append(INSTANCE.renderTypeConstructor(it.getConstructor())).toString();
    }

    private static final CharSequence RENDER_WHEN_MISSING_CASES$lambda$50$lambda$49(WhenMissingCase it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return "" + '\'' + it + '\'';
    }

    private static final String RENDER_WHEN_MISSING_CASES$lambda$50(List it) {
        String string2;
        Intrinsics.checkNotNullParameter(it, "it");
        if (!INSTANCE.getAssumesElseBranchOnly(it)) {
            String list = CollectionsKt.joinToString$default(it, ", ", null, null, WHEN_MISSING_LIMIT, null, Renderers::RENDER_WHEN_MISSING_CASES$lambda$50$lambda$49, 22, null);
            String branches = it.size() > 1 ? "branches" : "branch";
            string2 = list + ' ' + branches + " or 'else' branch instead";
        } else {
            string2 = "'else' branch";
        }
        return string2;
    }

    private static final Unit DEPRECATION_RENDERER$lambda$51(DescriptorRendererOptions $this$withOptions) {
        Intrinsics.checkNotNullParameter($this$withOptions, "$this$withOptions");
        $this$withOptions.setWithoutTypeParameters(false);
        $this$withOptions.setReceiverAfterName(false);
        $this$withOptions.setPropertyAccessorRenderingPolicy(PropertyAccessorRenderingPolicy.PRETTY);
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(Renderers.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        LOG = logger;
        TO_STRING = DiagnosticParameterRendererKt.Renderer(Renderers::TO_STRING$lambda$0);
        NOT_RENDERED = DiagnosticParameterRendererKt.Renderer(Renderers::NOT_RENDERED$lambda$1);
        NAME = DiagnosticParameterRendererKt.Renderer(Renderers::NAME$lambda$2);
        FQ_NAME = DiagnosticParameterRendererKt.Renderer(Renderers::FQ_NAME$lambda$3);
        MODULE_WITH_PLATFORM = DiagnosticParameterRendererKt.Renderer(Renderers::MODULE_WITH_PLATFORM$lambda$4);
        MODULE = DiagnosticParameterRendererKt.Renderer(Renderers::MODULE$lambda$5);
        VISIBILITY = DiagnosticParameterRendererKt.Renderer(Renderers::VISIBILITY$lambda$6);
        DECLARATION_NAME_WITH_KIND = DiagnosticParameterRendererKt.Renderer(Renderers::DECLARATION_NAME_WITH_KIND$lambda$7);
        CAPITALIZED_DECLARATION_NAME_WITH_KIND_AND_PLATFORM = DiagnosticParameterRendererKt.Renderer(Renderers::CAPITALIZED_DECLARATION_NAME_WITH_KIND_AND_PLATFORM$lambda$8);
        NAME_OF_CONTAINING_DECLARATION_OR_FILE = DiagnosticParameterRendererKt.Renderer(Renderers::NAME_OF_CONTAINING_DECLARATION_OR_FILE$lambda$9);
        ELEMENT_TEXT = DiagnosticParameterRendererKt.Renderer(Renderers::ELEMENT_TEXT$lambda$10);
        DECLARATION_NAME = DiagnosticParameterRendererKt.Renderer(Renderers::DECLARATION_NAME$lambda$11);
        RENDER_CLASS_OR_OBJECT = DiagnosticParameterRendererKt.Renderer(Renderers::RENDER_CLASS_OR_OBJECT$lambda$13);
        RENDER_CLASS_OR_OBJECT_NAME = DiagnosticParameterRendererKt.Renderer(Renderers::RENDER_CLASS_OR_OBJECT_NAME$lambda$14);
        RENDER_TYPE = new SmartTypeRenderer(DescriptorRenderer.FQ_NAMES_IN_TYPES.withOptions(Renderers::RENDER_TYPE$lambda$15));
        RENDER_TYPE_WITH_ANNOTATIONS = new SmartTypeRenderer(DescriptorRenderer.FQ_NAMES_IN_TYPES_WITH_ANNOTATIONS.withOptions(Renderers::RENDER_TYPE_WITH_ANNOTATIONS$lambda$16));
        TYPE_PROJECTION = DiagnosticParameterRendererKt.Renderer(Renderers::TYPE_PROJECTION$lambda$17);
        AMBIGUOUS_CALLS = DiagnosticParameterRendererKt.Renderer(Renderers::AMBIGUOUS_CALLS$lambda$19);
        COMPATIBILITY_CANDIDATE = DiagnosticParameterRendererKt.Renderer(Renderers::COMPATIBILITY_CANDIDATE$lambda$20);
        AMBIGUOUS_CALLABLE_REFERENCES = DiagnosticParameterRendererKt.Renderer(Renderers::AMBIGUOUS_CALLABLE_REFERENCES$lambda$21);
        TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER = DiagnosticParameterRendererKt.Renderer(Renderers::TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS_RENDERER$lambda$23);
        TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR_RENDERER = DiagnosticParameterRendererKt.Renderer(Renderers::TYPE_INFERENCE_PARAMETER_CONSTRAINT_ERROR_RENDERER$lambda$24);
        TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER = DiagnosticParameterRendererKt.Renderer(Renderers::TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER_RENDERER$lambda$25);
        TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER = DiagnosticParameterRendererKt.Renderer(Renderers::TYPE_INFERENCE_UPPER_BOUND_VIOLATED_RENDERER$lambda$26);
        TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER = DiagnosticParameterRendererKt.Renderer(Renderers::TYPE_INFERENCE_CANNOT_CAPTURE_TYPES_RENDERER$lambda$27);
        CLASSES_OR_SEPARATED = DiagnosticParameterRendererKt.Renderer(Renderers::CLASSES_OR_SEPARATED$lambda$40);
        RENDER_COLLECTION_OF_TYPES = DiagnosticParameterRendererKt.ContextDependentRenderer(Renderers::RENDER_COLLECTION_OF_TYPES$lambda$43);
        WHEN_MISSING_LIMIT = 7;
        RENDER_WHEN_MISSING_CASES = DiagnosticParameterRendererKt.Renderer(Renderers::RENDER_WHEN_MISSING_CASES$lambda$50);
        FQ_NAMES_IN_TYPES = RenderersKt.asRenderer(DescriptorRenderer.FQ_NAMES_IN_TYPES);
        FQ_NAMES_IN_TYPES_ANNOTATIONS_WHITELIST = AnnotationsWhitelistDescriptorRendererKt.withAnnotationsWhitelist$default(DescriptorRenderer.FQ_NAMES_IN_TYPES_WITH_ANNOTATIONS, null, 1, null);
        FQ_NAMES_IN_TYPES_WITH_ANNOTATIONS = RenderersKt.asRenderer(DescriptorRenderer.FQ_NAMES_IN_TYPES_WITH_ANNOTATIONS);
        COMPACT = RenderersKt.asRenderer(DescriptorRenderer.COMPACT);
        COMPACT_WITHOUT_SUPERTYPES = RenderersKt.asRenderer(DescriptorRenderer.COMPACT_WITHOUT_SUPERTYPES);
        WITHOUT_MODIFIERS = RenderersKt.asRenderer(DescriptorRenderer.WITHOUT_MODIFIERS);
        SHORT_NAMES_IN_TYPES = RenderersKt.asRenderer(DescriptorRenderer.SHORT_NAMES_IN_TYPES);
        COMPACT_WITH_MODIFIERS = RenderersKt.asRenderer(DescriptorRenderer.COMPACT_WITH_MODIFIERS);
        DEPRECATION_RENDERER = RenderersKt.asRenderer(DescriptorRenderer.ONLY_NAMES_WITH_SHORT_TYPES.withOptions(Renderers::DEPRECATION_RENDERER$lambda$51));
        DESCRIPTORS_ON_NEWLINE_WITH_INDENT = new DiagnosticParameterRenderer<Collection<? extends DeclarationDescriptor>>(){
            private final MultiplatformDiagnosticRenderingMode mode;
            {
                this.mode = new MultiplatformDiagnosticRenderingMode();
            }

            public String render(Collection<? extends DeclarationDescriptor> obj, RenderingContext renderingContext) {
                StringBuilder stringBuilder;
                Intrinsics.checkNotNullParameter(obj, "obj");
                Intrinsics.checkNotNullParameter(renderingContext, "renderingContext");
                StringBuilder $this$render_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                for (DeclarationDescriptor declarationDescriptor : obj) {
                    this.mode.newLine($this$render_u24lambda_u240);
                    this.mode.renderDescriptor($this$render_u24lambda_u240, declarationDescriptor, renderingContext, "");
                }
                return stringBuilder.toString();
            }
        };
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/Renderers$ConstraintSystemRenderingVerbosity;", "", "<init>", "(Ljava/lang/String;I)V", "COMPACT", "DEBUG", "EXTRA_VERBOSE"})
    public static final class ConstraintSystemRenderingVerbosity
    extends Enum<ConstraintSystemRenderingVerbosity> {
        public static final /* enum */ ConstraintSystemRenderingVerbosity COMPACT = new ConstraintSystemRenderingVerbosity();
        public static final /* enum */ ConstraintSystemRenderingVerbosity DEBUG = new ConstraintSystemRenderingVerbosity();
        public static final /* enum */ ConstraintSystemRenderingVerbosity EXTRA_VERBOSE = new ConstraintSystemRenderingVerbosity();
        private static final /* synthetic */ ConstraintSystemRenderingVerbosity[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ConstraintSystemRenderingVerbosity[] values() {
            return (ConstraintSystemRenderingVerbosity[])$VALUES.clone();
        }

        public static ConstraintSystemRenderingVerbosity valueOf(String value2) {
            return Enum.valueOf(ConstraintSystemRenderingVerbosity.class, value2);
        }

        @NotNull
        public static EnumEntries<ConstraintSystemRenderingVerbosity> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = constraintSystemRenderingVerbosityArray = new ConstraintSystemRenderingVerbosity[]{ConstraintSystemRenderingVerbosity.COMPACT, ConstraintSystemRenderingVerbosity.DEBUG, ConstraintSystemRenderingVerbosity.EXTRA_VERBOSE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TypeBounds.BoundKind.values().length];
            try {
                nArray[TypeBounds.BoundKind.LOWER_BOUND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TypeBounds.BoundKind.UPPER_BOUND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ConstraintSystemRenderingVerbosity.values().length];
            try {
                nArray[ConstraintSystemRenderingVerbosity.COMPACT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintSystemRenderingVerbosity.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstraintSystemRenderingVerbosity.EXTRA_VERBOSE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

