/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics.rendering;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.DiagnosticRendererFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0097\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0001\u00a2\u0006\u0004\b\u000b\u0010\fR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\r8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u00108G\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016"}, d2={"Lorg/jetbrains/kotlin/diagnostics/rendering/RootDiagnosticRendererFactory;", "Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticRendererFactory;", "<init>", "()V", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticRenderer;", "invoke", "(Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;)Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticRenderer;", "factory", "", "registerFactory", "(Lorg/jetbrains/kotlin/diagnostics/rendering/DiagnosticRendererFactory;)V", "Ljava/util/LinkedHashSet;", "_factories", "Ljava/util/LinkedHashSet;", "", "getFactories", "()Ljava/util/Set;", "factories", "Ljava/util/concurrent/locks/ReentrantLock;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;"})
public final class RootDiagnosticRendererFactory
implements DiagnosticRendererFactory {
    @NotNull
    public static final RootDiagnosticRendererFactory INSTANCE = new RootDiagnosticRendererFactory();
    @NotNull
    private static final LinkedHashSet<DiagnosticRendererFactory> _factories = new LinkedHashSet();
    @NotNull
    private static final ReentrantLock lock = new ReentrantLock();

    private RootDiagnosticRendererFactory() {
    }

    @NotNull
    public final Set<DiagnosticRendererFactory> getFactories() {
        return _factories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public KtDiagnosticRenderer invoke(@NotNull KtDiagnostic diagnostic) {
        KtDiagnosticRenderer ktDiagnosticRenderer;
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        Lock lock = RootDiagnosticRendererFactory.lock;
        lock.lock();
        try {
            boolean bl = false;
            Iterator iterator2 = _factories.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                KtDiagnosticRenderer renderer;
                Object e = iterator3.next();
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                DiagnosticRendererFactory factory2 = (DiagnosticRendererFactory)e;
                KtDiagnosticRenderer ktDiagnosticRenderer2 = renderer = factory2.invoke(diagnostic);
                if (ktDiagnosticRenderer2 == null) continue;
                KtDiagnosticRenderer ktDiagnosticRenderer3 = ktDiagnosticRenderer2;
                return ktDiagnosticRenderer3;
            }
            ktDiagnosticRenderer = diagnostic.getFactory().getKtRenderer();
        }
        finally {
            lock.unlock();
        }
        return ktDiagnosticRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerFactory(@NotNull DiagnosticRendererFactory factory2) {
        Intrinsics.checkNotNullParameter(factory2, "factory");
        Lock lock = RootDiagnosticRendererFactory.lock;
        lock.lock();
        try {
            boolean bl = false;
            boolean bl2 = _factories.add(factory2);
        }
        finally {
            lock.unlock();
        }
    }
}

