/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.extensions;

import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0001B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00028\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0014R \u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00158\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019"}, d2={"Lorg/jetbrains/kotlin/extensions/ProjectExtensionDescriptor;", "", "T", "", "name", "Ljava/lang/Class;", "extensionClass", "<init>", "(Ljava/lang/String;Ljava/lang/Class;)V", "Lcom/intellij/openapi/project/Project;", "project", "", "registerExtensionPoint", "(Lcom/intellij/openapi/project/Project;)V", "extension", "registerExtension", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Object;)V", "", "getInstances", "(Lcom/intellij/openapi/project/Project;)Ljava/util/List;", "Ljava/lang/Class;", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "extensionPointName", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "getExtensionPointName", "()Lcom/intellij/openapi/extensions/ExtensionPointName;"})
public class ProjectExtensionDescriptor<T> {
    @NotNull
    private final Class<T> extensionClass;
    @NotNull
    private final ExtensionPointName<T> extensionPointName;

    public ProjectExtensionDescriptor(@NotNull String name, @NotNull Class<T> extensionClass) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(extensionClass, "extensionClass");
        this.extensionClass = extensionClass;
        this.extensionPointName = ExtensionPointName.Companion.create(name);
    }

    @NotNull
    public final ExtensionPointName<T> getExtensionPointName() {
        return this.extensionPointName;
    }

    public final void registerExtensionPoint(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        CoreApplicationEnvironment.registerExtensionPoint(project.getExtensionArea(), this.extensionPointName.getName(), this.extensionClass);
    }

    public final void registerExtension(@NotNull Project project, @NotNull T extension) {
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(extension, "extension");
        project.getExtensionArea().getExtensionPoint(this.extensionPointName).registerExtension(extension, project);
    }

    @NotNull
    public final List<T> getInstances(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        ExtensionsArea extensionsArea = project.getExtensionArea();
        Intrinsics.checkNotNullExpressionValue(extensionsArea, "getExtensionArea(...)");
        ExtensionsArea projectArea = extensionsArea;
        if (!projectArea.hasExtensionPoint(this.extensionPointName.getName())) {
            return CollectionsKt.emptyList();
        }
        T[] TArray = projectArea.getExtensionPoint(this.extensionPointName).getExtensions();
        Intrinsics.checkNotNullExpressionValue(TArray, "getExtensions(...)");
        return ArraysKt.toList(TArray);
    }
}

