/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fileClasses;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.fileClasses.JvmMultifileClassPartInfo;
import org.jetbrains.kotlin.fileClasses.JvmSimpleFileClassInfo;
import org.jetbrains.kotlin.fileClasses.ParsedJvmFileClassAnnotations;
import org.jetbrains.kotlin.load.java.descriptors.UtilKt;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0019\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J!\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0019\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0019\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001c\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u000b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)"}, d2={"Lorg/jetbrains/kotlin/fileClasses/JvmFileClassUtil;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedMemberDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/name/FqName;", "getPartFqNameForDeserialized", "(Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedMemberDescriptor;)Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/psi/KtFile;", "file", "", "getFileClassInternalName", "(Lorg/jetbrains/kotlin/psi/KtFile;)Ljava/lang/String;", "facadeName", "fileName", "manglePartName", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "getFileClassInfoNoResolve", "(Lorg/jetbrains/kotlin/psi/KtFile;)Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "Lorg/jetbrains/kotlin/fileClasses/ParsedJvmFileClassAnnotations;", "parseJvmNameOnFileNoResolve", "(Lorg/jetbrains/kotlin/psi/KtFile;)Lorg/jetbrains/kotlin/fileClasses/ParsedJvmFileClassAnnotations;", "shortName", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "findAnnotationEntryOnFileNoResolve", "(Lorg/jetbrains/kotlin/psi/KtFile;Ljava/lang/String;)Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "annotation", "getLiteralStringFromAnnotation", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/psi/KtLiteralStringTemplateEntry;", "getLiteralStringEntryFromAnnotation", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;)Lorg/jetbrains/kotlin/psi/KtLiteralStringTemplateEntry;", "JVM_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getJVM_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "JVM_NAME_SHORT", "Ljava/lang/String;", "getJVM_NAME_SHORT", "()Ljava/lang/String;"})
public final class JvmFileClassUtil {
    @NotNull
    public static final JvmFileClassUtil INSTANCE = new JvmFileClassUtil();
    @NotNull
    private static final FqName JVM_NAME = new FqName("kotlin.jvm.JvmName");
    @NotNull
    private static final String JVM_NAME_SHORT;

    private JvmFileClassUtil() {
    }

    @NotNull
    public final FqName getJVM_NAME() {
        return JVM_NAME;
    }

    @NotNull
    public final String getJVM_NAME_SHORT() {
        return JVM_NAME_SHORT;
    }

    @NotNull
    public final FqName getPartFqNameForDeserialized(@NotNull DeserializedMemberDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Object object = UtilKt.getImplClassNameForDeserialized(descriptor2);
        if (object == null || (object = ((JvmClassName)object).getFqNameForTopLevelClassMaybeWithDollars()) == null) {
            throw new IllegalStateException(("No implClassName for " + descriptor2).toString());
        }
        return object;
    }

    @NotNull
    public static final String getFileClassInternalName(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        return JvmFileClassUtilKt.getInternalNameWithoutInnerClasses(JvmFileClassUtil.getFileClassInfoNoResolve(file2).getFileClassFqName());
    }

    @NotNull
    public static final String manglePartName(@NotNull String facadeName, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter(facadeName, "facadeName");
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        return facadeName + "__" + PackagePartClassUtils.getFilePartShortName(fileName);
    }

    @NotNull
    public static final JvmFileClassInfo getFileClassInfoNoResolve(@NotNull KtFile file2) {
        JvmFileClassInfo jvmFileClassInfo;
        Intrinsics.checkNotNullParameter(file2, "file");
        ParsedJvmFileClassAnnotations parsedAnnotations = INSTANCE.parseJvmNameOnFileNoResolve(file2);
        Object object = parsedAnnotations;
        if (object == null || (object = ((ParsedJvmFileClassAnnotations)object).getJvmPackageName()) == null) {
            object = file2.getPackageFqName();
        }
        Object packageFqName = object;
        if (parsedAnnotations != null) {
            String string2 = parsedAnnotations.getJvmName();
            if (string2 == null) {
                String string3 = file2.getName();
                Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
                string2 = PackagePartClassUtils.getFilePartShortName(string3);
            }
            String simpleName2 = string2;
            Name name = Name.identifier(simpleName2);
            Intrinsics.checkNotNullExpressionValue(name, "identifier(...)");
            FqName facadeClassFqName = ((FqName)packageFqName).child(name);
            if (parsedAnnotations.isMultifileClass()) {
                String string4 = file2.getName();
                Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
                Name name2 = Name.identifier(JvmFileClassUtil.manglePartName(simpleName2, string4));
                Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
                jvmFileClassInfo = new JvmMultifileClassPartInfo(((FqName)packageFqName).child(name2), facadeClassFqName);
            } else {
                jvmFileClassInfo = new JvmSimpleFileClassInfo(facadeClassFqName, true);
            }
        } else {
            String string5 = file2.getName();
            Intrinsics.checkNotNullExpressionValue(string5, "getName(...)");
            jvmFileClassInfo = new JvmSimpleFileClassInfo(PackagePartClassUtils.getPackagePartFqName((FqName)packageFqName, string5), false);
        }
        return jvmFileClassInfo;
    }

    /*
     * Unable to fully structure code
     */
    private final ParsedJvmFileClassAnnotations parseJvmNameOnFileNoResolve(KtFile file) {
        jvmNameAnnotation = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file, JvmFileClassUtil.JVM_NAME_SHORT);
        v0 = jvmNameAnnotation;
        if (v0 == null) ** GOTO lbl-1000
        p0 = v0;
        $i$a$-let-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmName$1 = false;
        v1 = this.getLiteralStringFromAnnotation((KtAnnotationEntry)p0);
        v0 = v1;
        if (v1 != null) {
            p0 = var5_6 = v0;
            $i$a$-takeIf-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmName$2 = false;
            v2 = Name.isValidIdentifier((String)p0) ? var5_6 : null;
        } else lbl-1000:
        // 2 sources

        {
            v2 = jvmName = null;
        }
        if ((v3 = (jvmPackageNameAnnotation = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file, JvmStandardClassIds.INSTANCE.getJVM_PACKAGE_NAME_SHORT()))) == null) ** GOTO lbl-1000
        p0 = v3;
        $i$a$-let-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmPackageName$1 = false;
        v4 = this.getLiteralStringFromAnnotation((KtAnnotationEntry)p0);
        v3 = v4;
        if (v4 != null) {
            p0 = v3;
            $i$a$-let-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmPackageName$2 = false;
            v5 = new FqName((String)p0);
        } else lbl-1000:
        // 2 sources

        {
            v5 = jvmPackageName = null;
        }
        if (jvmName == null && jvmPackageName == null) {
            return null;
        }
        isMultifileClass = JvmFileClassUtilKt.isJvmMultifileClassFile(file);
        return new ParsedJvmFileClassAnnotations((String)jvmName, jvmPackageName, isMultifileClass);
    }

    @Nullable
    public static final KtAnnotationEntry findAnnotationEntryOnFileNoResolve(@NotNull KtFile file2, @NotNull String shortName) {
        KtAnnotationEntry ktAnnotationEntry;
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(shortName, "shortName");
        Object object = file2.getFileAnnotationList();
        if (object != null && (object = ((KtFileAnnotationList)object).getAnnotationEntries()) != null) {
            Object v2;
            block3: {
                Iterable $this$firstOrNull$iv = (Iterable)object;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    boolean bl = false;
                    KtExpression ktExpression = it.getCalleeExpression();
                    if (!Intrinsics.areEqual(ktExpression != null && (ktExpression = ((KtConstructorCalleeExpression)ktExpression).getConstructorReferenceExpression()) != null ? ktExpression.getReferencedName() : null, shortName)) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            ktAnnotationEntry = v2;
        } else {
            ktAnnotationEntry = null;
        }
        return ktAnnotationEntry;
    }

    @Nullable
    public final String getLiteralStringFromAnnotation(@NotNull KtAnnotationEntry annotation) {
        Intrinsics.checkNotNullParameter(annotation, "annotation");
        KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = this.getLiteralStringEntryFromAnnotation(annotation);
        return ktLiteralStringTemplateEntry != null ? ktLiteralStringTemplateEntry.getText() : null;
    }

    @Nullable
    public final KtLiteralStringTemplateEntry getLiteralStringEntryFromAnnotation(@NotNull KtAnnotationEntry annotation) {
        Object object;
        block4: {
            block3: {
                KtExpression ktExpression;
                Intrinsics.checkNotNullParameter(annotation, "annotation");
                List<? extends ValueArgument> list = annotation.getValueArguments();
                Intrinsics.checkNotNullExpressionValue(list, "getValueArguments(...)");
                object = CollectionsKt.firstOrNull(list);
                if (object == null) break block3;
                ValueArgument $this$getLiteralStringEntryFromAnnotation_u24lambda_u244 = object;
                boolean bl = false;
                KtStringTemplateExpression ktStringTemplateExpression = $this$getLiteralStringEntryFromAnnotation_u24lambda_u244 instanceof KtValueArgument ? ((KtValueArgument)$this$getLiteralStringEntryFromAnnotation_u24lambda_u244).getStringTemplateExpression() : ((ktExpression = $this$getLiteralStringEntryFromAnnotation_u24lambda_u244.getArgumentExpression()) instanceof KtStringTemplateExpression ? (KtStringTemplateExpression)ktExpression : null);
                object = ktStringTemplateExpression;
                if (ktStringTemplateExpression != null) break block4;
            }
            return null;
        }
        Object stringTemplateExpression = object;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = ((KtStringTemplateExpression)stringTemplateExpression).getEntries();
        Intrinsics.checkNotNullExpressionValue(ktStringTemplateEntryArray, "getEntries(...)");
        Object object2 = ArraysKt.singleOrNull((Object[])ktStringTemplateEntryArray);
        return object2 instanceof KtLiteralStringTemplateEntry ? (KtLiteralStringTemplateEntry)object2 : null;
    }

    static {
        String string2 = JVM_NAME.shortName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        JVM_NAME_SHORT = string2;
    }
}

