/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSessionComponent;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H&\u00a2\u0006\u0004\b\u0007\u0010\b"}, d2={"Lorg/jetbrains/kotlin/fir/FirModuleVisibilityChecker;", "Lorg/jetbrains/kotlin/fir/FirSessionComponent;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "declaration", "", "isInFriendModule", "(Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;)Z", "Standard"})
public abstract class FirModuleVisibilityChecker
implements FirSessionComponent {
    public abstract boolean isInFriendModule(@NotNull FirMemberDeclaration var1);

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00118\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/FirModuleVisibilityChecker$Standard;", "Lorg/jetbrains/kotlin/fir/FirModuleVisibilityChecker;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "declaration", "", "isInFriendModule", "(Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;)Z", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "useSiteModuleData", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "", "allDependsOnDependencies", "Ljava/util/List;"})
    public static final class Standard
    extends FirModuleVisibilityChecker {
        @NotNull
        private final FirSession session;
        @NotNull
        private final FirModuleData useSiteModuleData;
        @NotNull
        private final List<FirModuleData> allDependsOnDependencies;

        public Standard(@NotNull FirSession session) {
            Intrinsics.checkNotNullParameter(session, "session");
            this.session = session;
            this.useSiteModuleData = FirModuleDataKt.getModuleData(this.session);
            this.allDependsOnDependencies = this.useSiteModuleData.getAllDependsOnDependencies();
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        @Override
        public boolean isInFriendModule(@NotNull FirMemberDeclaration declaration) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            FirModuleData firModuleData = declaration.getModuleData();
            return Intrinsics.areEqual(firModuleData, this.useSiteModuleData) || this.useSiteModuleData.getFriendDependencies().contains(firModuleData) || this.allDependsOnDependencies.contains(firModuleData);
        }
    }
}

