/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.components.Position;
import org.jetbrains.kotlin.incremental.components.ScopeKind;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\u0004\b\b\u0010\tJ9\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J3\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0013R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0014R\"\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00198\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/IncrementalPassThroughLookupTrackerComponent;", "Lorg/jetbrains/kotlin/fir/FirLookupTrackerComponent;", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "lookupTracker", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/KtSourceElement;", "", "sourceToFilePath", "<init>", "(Lorg/jetbrains/kotlin/incremental/components/LookupTracker;Lkotlin/jvm/functions/Function1;)V", "name", "", "inScopes", "source", "fileSource", "", "recordLookup", "(Ljava/lang/String;Ljava/lang/Iterable;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/KtSourceElement;)V", "inScope", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/KtSourceElement;)V", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "Lkotlin/jvm/functions/Function1;", "", "requiresPosition", "Z", "Ljava/util/concurrent/ConcurrentHashMap;", "sourceToFilePathsCache", "Ljava/util/concurrent/ConcurrentHashMap;"})
public final class IncrementalPassThroughLookupTrackerComponent
extends FirLookupTrackerComponent {
    @NotNull
    private final LookupTracker lookupTracker;
    @NotNull
    private final Function1<KtSourceElement, String> sourceToFilePath;
    private final boolean requiresPosition;
    @NotNull
    private final ConcurrentHashMap<KtSourceElement, String> sourceToFilePathsCache;

    public IncrementalPassThroughLookupTrackerComponent(@NotNull LookupTracker lookupTracker, @NotNull Function1<? super KtSourceElement, String> sourceToFilePath) {
        Intrinsics.checkNotNullParameter(lookupTracker, "lookupTracker");
        Intrinsics.checkNotNullParameter(sourceToFilePath, "sourceToFilePath");
        this.lookupTracker = lookupTracker;
        this.sourceToFilePath = sourceToFilePath;
        this.requiresPosition = this.lookupTracker.getRequiresPosition();
        this.sourceToFilePathsCache = new ConcurrentHashMap();
    }

    @Override
    public void recordLookup(@NotNull String name, @NotNull Iterable<String> inScopes, @Nullable KtSourceElement source, @Nullable KtSourceElement fileSource) {
        Position position;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(inScopes, "inScopes");
        KtSourceElement ktSourceElement = fileSource;
        if (ktSourceElement == null) {
            KtPsiSourceElement ktPsiSourceElement = source instanceof KtPsiSourceElement ? (KtPsiSourceElement)source : null;
            if (ktPsiSourceElement != null) {
                ktSourceElement = ktPsiSourceElement;
            } else {
                return;
            }
        }
        KtSourceElement definedSource = ktSourceElement;
        ConcurrentMap $this$getOrPut$iv = this.sourceToFilePathsCache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(definedSource);
        if (object == null) {
            boolean bl = false;
            String string2 = this.sourceToFilePath.invoke(definedSource);
            if (string2 == null) {
                return;
            }
            String default$iv = string2;
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(definedSource, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        String path = (String)object;
        if (this.requiresPosition && source != null && source instanceof KtPsiSourceElement) {
            PsiDiagnosticUtils.LineAndColumn it = DiagnosticUtils.getLineAndColumnInPsiFile(((KtPsiSourceElement)source).getPsi().getContainingFile(), ((KtPsiSourceElement)source).getPsi().getTextRange());
            boolean bl = false;
            position = new Position(it.getLine(), it.getColumn());
        } else {
            position = Position.Companion.getNO_POSITION();
        }
        Position position2 = position;
        for (String scope2 : inScopes) {
            Intrinsics.checkNotNull(path);
            this.lookupTracker.record(path, position2, scope2, ScopeKind.PACKAGE, name);
        }
    }

    @Override
    public void recordLookup(@NotNull String name, @NotNull String inScope, @Nullable KtSourceElement source, @Nullable KtSourceElement fileSource) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(inScope, "inScope");
        this.recordLookup(name, (Iterable<String>)new SmartList<String>(inScope), source, fileSource);
    }
}

