/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirSyntheticPropertySymbol;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0013\u0010\u0001\u001a\u00020\u0000*\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0001\u0010\u0002\u001a\u0019\u0010\u0006\u001a\u00020\u0004*\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\"\u0015\u0010\u000b\u001a\u00020\u0004*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "nearestNonInPlaceGraph", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;)Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "", "isForInitialization", "requiresInitialization", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;Z)Z", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getEvaluatedInPlace", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Z", "evaluatedInPlace"})
public final class FirPropertyInitializationAnalyzerKt {
    public static final boolean getEvaluatedInPlace(@NotNull FirDeclaration $this$evaluatedInPlace) {
        Intrinsics.checkNotNullParameter($this$evaluatedInPlace, "<this>");
        FirDeclaration firDeclaration = $this$evaluatedInPlace;
        return firDeclaration instanceof FirAnonymousFunction ? EventOccurrencesRangeKt.isInPlace(((FirAnonymousFunction)$this$evaluatedInPlace).getInvocationKind()) : (firDeclaration instanceof FirAnonymousObject ? ((FirAnonymousObject)$this$evaluatedInPlace).getClassKind() != ClassKind.ENUM_ENTRY : (firDeclaration instanceof FirConstructor ? true : !(firDeclaration instanceof FirFunction) && !(firDeclaration instanceof FirClass)));
    }

    @NotNull
    public static final ControlFlowGraph nearestNonInPlaceGraph(@NotNull ControlFlowGraph $this$nearestNonInPlaceGraph) {
        CFGNode<?> cFGNode;
        Intrinsics.checkNotNullParameter($this$nearestNonInPlaceGraph, "<this>");
        FirDeclaration firDeclaration = $this$nearestNonInPlaceGraph.getDeclaration();
        boolean bl = firDeclaration != null ? FirPropertyInitializationAnalyzerKt.getEvaluatedInPlace(firDeclaration) : false;
        if (bl) {
            cFGNode = CollectionsKt.firstOrNull($this$nearestNonInPlaceGraph.getEnterNode().getPreviousNodes());
            if (cFGNode == null || (cFGNode = cFGNode.getOwner()) == null || (cFGNode = FirPropertyInitializationAnalyzerKt.nearestNonInPlaceGraph((ControlFlowGraph)((Object)cFGNode))) == null) {
                cFGNode = $this$nearestNonInPlaceGraph;
            }
        } else {
            cFGNode = $this$nearestNonInPlaceGraph;
        }
        return cFGNode;
    }

    public static final boolean requiresInitialization(@NotNull FirPropertySymbol $this$requiresInitialization, boolean isForInitialization) {
        Intrinsics.checkNotNullParameter($this$requiresInitialization, "<this>");
        boolean hasImplicitBackingField = !DeclarationAttributesKt.getHasExplicitBackingField($this$requiresInitialization) && DeclarationAttributesKt.getHasBackingField($this$requiresInitialization);
        return $this$requiresInitialization instanceof FirSyntheticPropertySymbol ? false : (isForInitialization ? $this$requiresInitialization.getHasDelegate() || hasImplicitBackingField : !$this$requiresInitialization.getHasInitializer() && hasImplicitBackingField && !Intrinsics.areEqual(ClassMembersKt.isCatchParameter((FirProperty)$this$requiresInitialization.getFir()), true));
    }
}

