/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.cfa.FirPropertyInitializationAnalyzerKt;
import org.jetbrains.kotlin.fir.analysis.cfa.VariableInitializationCheckProcessor;
import org.jetbrains.kotlin.fir.analysis.cfa.util.VariableInitializationInfoData;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.QualifiedAccessNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0015\u00a2\u0006\u0004\b\n\u0010\u000bJ7\u0010\u0014\u001a\u00020\u0013*\u00020\u00042\u0006\u0010\r\u001a\u00020\f2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0014\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001b\u0010\u0017\u001a\u00020\u0006*\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J3\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00192\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0012\u001a\u00020\u0011H\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bJ3\u0010\u001c\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\f2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0014\u00a2\u0006\u0004\b\u001c\u0010\u001dJ3\u0010\u001e\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\f2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0014\u00a2\u0006\u0004\b\u001e\u0010\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/PropertyInitializationCheckProcessor;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/VariableInitializationCheckProcessor;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;", "data", "", "isForInitialization", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "filterProperties", "(Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;Z)Ljava/util/Set;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "node", "symbol", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "", "reportCapturedInitialization", "(Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "hasMatchingReceiver", "(Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;)Z", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/QualifiedAccessNode;", "reportUninitializedVariable", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/QualifiedAccessNode;Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "reportNonInlineMemberValInitialization", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "reportValReassignment"})
public final class PropertyInitializationCheckProcessor
extends VariableInitializationCheckProcessor {
    @NotNull
    public static final PropertyInitializationCheckProcessor INSTANCE = new PropertyInitializationCheckProcessor();

    private PropertyInitializationCheckProcessor() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Set<FirVariableSymbol<?>> filterProperties(@NotNull VariableInitializationInfoData data2, boolean isForInitialization) {
        void destination$iv;
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter(data2, "data");
        Iterable iterable = data2.getProperties();
        Collection collection = new LinkedHashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            FirVariableSymbol it = (FirVariableSymbol)element$iv;
            boolean bl = false;
            if (!(it instanceof FirPropertySymbol)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            if (!(FirPropertyInitializationAnalyzerKt.requiresInitialization((FirPropertySymbol)it, isForInitialization) || data2.getConditionallyInitializedProperties().contains(it))) continue;
            destination$iv.add(element$iv);
        }
        return (Set)destination$iv;
    }

    @Override
    protected void reportCapturedInitialization(@NotNull VariableInitializationInfoData $this$reportCapturedInitialization, @NotNull VariableAssignmentNode node, @NotNull FirVariableSymbol<?> symbol, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter($this$reportCapturedInitialization, "<this>");
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!(symbol instanceof FirPropertySymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        KtDiagnosticFactory1<FirPropertySymbol> capturedInitializationError = $this$reportCapturedInitialization.getReceiver() != null ? FirErrors.INSTANCE.getCAPTURED_MEMBER_VAL_INITIALIZATION() : FirErrors.INSTANCE.getCAPTURED_VAL_INITIALIZATION();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)node.getFir().getLValue().getSource(), capturedInitializationError, symbol, (DiagnosticContext)context, null, 16, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean hasMatchingReceiver(@NotNull FirQualifiedAccessExpression $this$hasMatchingReceiver, @NotNull VariableInitializationInfoData data2) {
        Intrinsics.checkNotNullParameter($this$hasMatchingReceiver, "<this>");
        Intrinsics.checkNotNullParameter(data2, "data");
        FirExpression firExpression = $this$hasMatchingReceiver.getDispatchReceiver();
        FirExpression expression = firExpression != null ? FirExpressionUtilKt.unwrapSmartcastExpression(firExpression) : null;
        FirPureAbstractElement firPureAbstractElement = expression instanceof FirThisReceiverExpression ? (FirThisReceiverExpression)expression : null;
        if (Intrinsics.areEqual(firPureAbstractElement != null && (firPureAbstractElement = ((FirThisReceiverExpression)firPureAbstractElement).getCalleeReference()) != null ? ((FirThisReference)firPureAbstractElement).getBoundSymbol() : null, data2.getReceiver())) return true;
        FirResolvedQualifier firResolvedQualifier = expression instanceof FirResolvedQualifier ? (FirResolvedQualifier)expression : null;
        if (!Intrinsics.areEqual(firResolvedQualifier != null ? firResolvedQualifier.getSymbol() : null, data2.getReceiver())) return false;
        return true;
    }

    @Override
    protected void reportUninitializedVariable(@NotNull DiagnosticReporter reporter, @NotNull QualifiedAccessNode node, @NotNull FirVariableSymbol<?> symbol, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!(symbol instanceof FirPropertySymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)node.getFir().getSource(), FirErrors.INSTANCE.getUNINITIALIZED_VARIABLE(), symbol, (DiagnosticContext)context, null, 16, null);
    }

    @Override
    protected void reportNonInlineMemberValInitialization(@NotNull VariableAssignmentNode node, @NotNull FirVariableSymbol<?> symbol, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!(symbol instanceof FirPropertySymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)node.getFir().getLValue().getSource(), FirErrors.INSTANCE.getNON_INLINE_MEMBER_VAL_INITIALIZATION(), symbol, (DiagnosticContext)context, null, 16, null);
    }

    @Override
    protected void reportValReassignment(@NotNull VariableAssignmentNode node, @NotNull FirVariableSymbol<?> symbol, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(context, "context");
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)node.getFir().getLValue().getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT(), symbol, (DiagnosticContext)context, null, 16, null);
    }
}

