/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentMap;
import kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.contracts.description.MarkedEventOccurrencesRange;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.cfa.FirPropertyInitializationAnalyzerKt;
import org.jetbrains.kotlin.fir.analysis.cfa.VariableInitializationCheckProcessorKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.VariableInitializationInfoData;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNodeWithSubgraphs;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CapturedByValue;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeLabel;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.QualifiedAccessNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationNode;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJy\u0010\u001a\u001a\u00020\f*\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f2\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00112\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0018\u0010\u0019\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0018H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJA\u0010\u001e\u001a\u00020\f*\u00020\u00042\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00112\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJQ\u0010!\u001a\u00020\f*\u00020\u00042\u0006\u0010\u001d\u001a\u00020 2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00112\u0018\u0010\u0019\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0018H\u0002\u00a2\u0006\u0004\b!\u0010\"Ja\u0010$\u001a\u00020\f*\u00020\u00042\u0006\u0010\u001d\u001a\u00020#2\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00112\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0018\u0010\u0019\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0018H\u0002\u00a2\u0006\u0004\b$\u0010%JM\u0010'\u001a\u00020\f*\u00020\u00042\u0006\u0010\u001d\u001a\u00020&2\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00112\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b'\u0010(J+\u0010)\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u00122\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b)\u0010*J\u0085\u0001\u0010,\u001a\u00020\f*\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030+2\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00112\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0018\u0010\u0019\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0018H\u0002\u00a2\u0006\u0004\b,\u0010-J7\u0010/\u001a\u00020\f*\u00020\u00042\u0006\u0010\u001d\u001a\u00020#2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH$\u00a2\u0006\u0004\b/\u00100J3\u00101\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020&2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\t\u001a\u00020\bH$\u00a2\u0006\u0004\b1\u00102J3\u00103\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020#2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH$\u00a2\u0006\u0004\b3\u00104J3\u00105\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020#2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH$\u00a2\u0006\u0004\b5\u00104J)\u00106\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00112\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H%\u00a2\u0006\u0004\b6\u00107J\u001b\u00109\u001a\u00020\u0006*\u0002082\u0006\u0010\u0005\u001a\u00020\u0004H$\u00a2\u0006\u0004\b9\u0010:"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/VariableInitializationCheckProcessor;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;", "data", "", "isForInitialization", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "", "check", "(Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;ZLorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "graph", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "properties", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "scope", "doNotReportUninitializedVariable", "doNotReportConstantUninitialized", "", "scopes", "runCheck", "(Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;Ljava/util/Set;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;ZZZLjava/util/Map;)V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "node", "processUnionNode", "(Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;Ljava/util/Set;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "processVariableDeclaration", "(Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Ljava/util/Set;Ljava/util/Map;)V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "processVariableAssignment", "(Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;Ljava/util/Set;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Ljava/util/Map;)V", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/QualifiedAccessNode;", "processQualifiedAccess", "(Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/QualifiedAccessNode;Ljava/util/Set;ZZLorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "isInitializedAt", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;)Z", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNodeWithSubgraphs;", "processSubGraphs", "(Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNodeWithSubgraphs;Ljava/util/Set;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;ZZZLjava/util/Map;)V", "symbol", "reportCapturedInitialization", "(Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "reportUninitializedVariable", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/QualifiedAccessNode;Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "reportNonInlineMemberValInitialization", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "reportValReassignment", "filterProperties", "(Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;Z)Ljava/util/Set;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "hasMatchingReceiver", "(Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;)Z"})
public abstract class VariableInitializationCheckProcessor {
    public final void check(@NotNull VariableInitializationInfoData data2, boolean isForInitialization, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(data2, "data");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Set<FirVariableSymbol<?>> filtered = this.filterProperties(data2, isForInitialization);
        if (filtered.isEmpty()) {
            return;
        }
        this.runCheck(data2, data2.getGraph(), filtered, context, reporter, null, isForInitialization, false, true, new LinkedHashMap());
    }

    private final void runCheck(VariableInitializationInfoData $this$runCheck, ControlFlowGraph graph2, Set<? extends FirVariableSymbol<?>> properties2, CheckerContext context, DiagnosticReporter reporter, FirDeclaration scope2, boolean isForInitialization, boolean doNotReportUninitializedVariable, boolean doNotReportConstantUninitialized, Map<FirVariableSymbol<?>, FirDeclaration> scopes) {
        for (CFGNode<?> node : graph2.getNodes()) {
            CFGNode<?> cFGNode;
            if (node.isUnion()) {
                this.processUnionNode($this$runCheck, node, properties2, context, reporter);
            }
            if ((cFGNode = node) instanceof VariableDeclarationNode) {
                this.processVariableDeclaration($this$runCheck, (VariableDeclarationNode)node, scope2, properties2, scopes);
                continue;
            }
            if (cFGNode instanceof VariableAssignmentNode) {
                this.processVariableAssignment($this$runCheck, (VariableAssignmentNode)node, properties2, reporter, context, scope2, scopes);
                continue;
            }
            if (cFGNode instanceof QualifiedAccessNode) {
                this.processQualifiedAccess($this$runCheck, (QualifiedAccessNode)node, properties2, doNotReportUninitializedVariable, doNotReportConstantUninitialized, reporter, context);
                continue;
            }
            if (!(cFGNode instanceof CFGNodeWithSubgraphs)) continue;
            this.processSubGraphs($this$runCheck, graph2, (CFGNodeWithSubgraphs)node, properties2, context, reporter, scope2, isForInitialization, doNotReportUninitializedVariable, doNotReportConstantUninitialized, scopes);
        }
    }

    private final void processUnionNode(VariableInitializationInfoData $this$processUnionNode, CFGNode<?> node, Set<? extends FirVariableSymbol<?>> properties2, CheckerContext context, DiagnosticReporter reporter) {
        for (Map.Entry entry : ((Map)$this$processUnionNode.getValue(node)).entrySet()) {
            EdgeLabel path = (EdgeLabel)entry.getKey();
            PersistentMap data2 = (PersistentMap)entry.getValue();
            if (Intrinsics.areEqual(path, CapturedByValue.INSTANCE)) continue;
            for (Map.Entry entry2 : ((Map)data2).entrySet()) {
                boolean bl;
                FirVariableSymbol symbol;
                block5: {
                    symbol = (FirVariableSymbol)entry2.getKey();
                    MarkedEventOccurrencesRange range = (MarkedEventOccurrencesRange)entry2.getValue();
                    if (!symbol.isVal() || !EventOccurrencesRangeKt.canBeRevisited(range) || !properties2.contains(symbol)) continue;
                    Iterable $this$all$iv = CfgTraverserKt.getPreviousCfgNodes(node);
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            CFGNode it = (CFGNode)element$iv;
                            boolean bl2 = false;
                            Object object = (PersistentMap)$this$processUnionNode.getValue(it).get(path);
                            if (!(object != null && (object = (MarkedEventOccurrencesRange)object.get(symbol)) != null ? EventOccurrencesRangeKt.canBeRevisited(object) : false)) continue;
                            bl = false;
                            break block5;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                VariableInitializationCheckProcessor.processUnionNode$reportErrorsOnInitializationsInInputs(node, $this$processUnionNode, this, reporter, context, symbol, path, ExtensionsKt.persistentSetOf());
            }
        }
    }

    private final void processVariableDeclaration(VariableInitializationInfoData $this$processVariableDeclaration, VariableDeclarationNode node, FirDeclaration scope2, Set<? extends FirVariableSymbol<?>> properties2, Map<FirVariableSymbol<?>, FirDeclaration> scopes) {
        FirPropertySymbol symbol = node.getFir().getSymbol();
        if (scope2 != null && $this$processVariableDeclaration.getReceiver() == null && node.getFir().isVal() && properties2.contains(symbol)) {
            scopes.put(symbol, scope2);
        }
    }

    private final void processVariableAssignment(VariableInitializationInfoData $this$processVariableAssignment, VariableAssignmentNode node, Set<? extends FirVariableSymbol<?>> properties2, DiagnosticReporter reporter, CheckerContext context, FirDeclaration scope2, Map<FirVariableSymbol<?>, FirDeclaration> scopes) {
        boolean bl;
        Object symbol;
        block13: {
            block15: {
                block14: {
                    Object object = ReferenceUtilsKt.getCalleeReference(node.getFir());
                    if (object == null || (object = FirReferenceUtilsKt.toResolvedVariableSymbol$default((FirReference)object, false, 1, null)) == null) {
                        return;
                    }
                    symbol = object;
                    if (!((FirVariableSymbol)symbol).isVal()) break block14;
                    FirQualifiedAccessExpression firQualifiedAccessExpression = FirExpressionUtilKt.unwrapLValue(node.getFir());
                    if ((firQualifiedAccessExpression != null ? this.hasMatchingReceiver(firQualifiedAccessExpression, $this$processVariableAssignment) : false) && properties2.contains(symbol)) break block15;
                }
                return;
            }
            PersistentMap<EdgeLabel, PersistentMap<FirVariableSymbol<?>, MarkedEventOccurrencesRange<CFGNode<?>>>> info = $this$processVariableAssignment.getValue(node);
            Iterable $this$any$iv = info.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PersistentMap it = (PersistentMap)element$iv;
                    boolean bl2 = false;
                    MarkedEventOccurrencesRange markedEventOccurrencesRange = (MarkedEventOccurrencesRange)it.get(symbol);
                    boolean bl3 = markedEventOccurrencesRange != null ? EventOccurrencesRangeKt.canBeRevisited(markedEventOccurrencesRange) : false;
                    if (!bl3) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            this.reportValReassignment(node, (FirVariableSymbol<?>)symbol, reporter, context);
        } else if (!Intrinsics.areEqual(scope2, scopes.get(symbol))) {
            this.reportCapturedInitialization($this$processVariableAssignment, node, (FirVariableSymbol<?>)symbol, reporter, context);
        } else if (!VariableInitializationCheckProcessorKt.access$isLocal((FirVariableSymbol)symbol) && !VariableInitializationCheckProcessorKt.access$isInline(node.getOwner(), FirHelpersKt.getContainingSymbol((FirCallableSymbol)symbol, context.getSession()))) {
            this.reportNonInlineMemberValInitialization(node, (FirVariableSymbol<?>)symbol, reporter, context);
        }
    }

    private final void processQualifiedAccess(VariableInitializationInfoData $this$processQualifiedAccess, QualifiedAccessNode node, Set<? extends FirVariableSymbol<?>> properties2, boolean doNotReportUninitializedVariable, boolean doNotReportConstantUninitialized, DiagnosticReporter reporter, CheckerContext context) {
        if (doNotReportUninitializedVariable) {
            return;
        }
        if (FirHelpersKt.hasDiagnosticKind(FirTypeUtilsKt.getResolvedType(node.getFir()), DiagnosticKind.RecursionInImplicitTypes)) {
            return;
        }
        FirVariableSymbol firVariableSymbol = FirReferenceUtilsKt.toResolvedVariableSymbol$default(node.getFir().getCalleeReference(), false, 1, null);
        if (firVariableSymbol == null) {
            return;
        }
        FirVariableSymbol symbol = firVariableSymbol;
        if (doNotReportConstantUninitialized) {
            FirCallableSymbol $this$isConst$iv = symbol;
            boolean $i$f$isConst = false;
            if ($this$isConst$iv.getRawStatus().isConst()) {
                return;
            }
        }
        FirCallableSymbol $this$isLateInit$iv = symbol;
        boolean $i$f$isLateInit = false;
        if (!$this$isLateInit$iv.getRawStatus().isLateInit()) {
            FirCallableSymbol $this$isExternal$iv = symbol;
            boolean $i$f$isExternal = false;
            if (!$this$isExternal$iv.getRawStatus().isExternal() && this.hasMatchingReceiver(node.getFir(), $this$processQualifiedAccess) && properties2.contains(symbol) && !this.isInitializedAt(symbol, node, $this$processQualifiedAccess)) {
                this.reportUninitializedVariable(reporter, node, symbol, context);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInitializedAt(FirVariableSymbol<?> $this$isInitializedAt, CFGNode<?> node, VariableInitializationInfoData data2) {
        boolean bl;
        Map $this$all$iv = data2.getValue(node);
        boolean $i$f$all = false;
        if ($this$all$iv.isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.entrySet().iterator();
        do {
            Map.Entry element$iv;
            if (!iterator2.hasNext()) return true;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl2 = false;
            EdgeLabel key = (EdgeLabel)entry.getKey();
            PersistentMap value2 = (PersistentMap)entry.getValue();
            if (!Intrinsics.areEqual(key, CapturedByValue.INSTANCE) || VariableInitializationCheckProcessorKt.isCapturedByValue($this$isInitializedAt)) {
                MarkedEventOccurrencesRange markedEventOccurrencesRange = (MarkedEventOccurrencesRange)value2.get($this$isInitializedAt);
                if (markedEventOccurrencesRange == null) return false;
                if (!EventOccurrencesRangeKt.isDefinitelyVisited(markedEventOccurrencesRange)) return false;
                boolean bl3 = true;
                if (!bl3) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    private final void processSubGraphs(VariableInitializationInfoData $this$processSubGraphs, ControlFlowGraph graph2, CFGNodeWithSubgraphs<?> node, Set<? extends FirVariableSymbol<?>> properties2, CheckerContext context, DiagnosticReporter reporter, FirDeclaration scope2, boolean isForInitialization, boolean doNotReportUninitializedVariable, boolean doNotReportConstantUninitialized, Map<FirVariableSymbol<?>, FirDeclaration> scopes) {
        if ($this$processSubGraphs.getReceiver() != null && node == graph2.getExitNode()) {
            return;
        }
        for (ControlFlowGraph subGraph : node.getSubGraphs()) {
            FirDeclaration firDeclaration;
            boolean isSubGraphConstProperty;
            boolean doNotReportForSubGraph;
            block8: {
                block7: {
                    FirDeclaration firDeclaration2;
                    boolean bl;
                    doNotReportForSubGraph = isForInitialization && VariableInitializationCheckProcessorKt.access$getDoNotReportUninitializedVariableForInitialization(subGraph.getKind());
                    FirDeclaration firDeclaration3 = subGraph.getDeclaration();
                    FirProperty firProperty = firDeclaration3 instanceof FirProperty ? (FirProperty)firDeclaration3 : null;
                    if (firProperty != null) {
                        FirMemberDeclaration $this$isConst$iv = firProperty;
                        boolean $i$f$isConst = false;
                        bl = $this$isConst$iv.getStatus().isConst();
                    } else {
                        bl = isSubGraphConstProperty = false;
                    }
                    if ((firDeclaration = subGraph.getDeclaration()) == null) break block7;
                    FirDeclaration it = firDeclaration2 = firDeclaration;
                    boolean bl2 = false;
                    firDeclaration = !FirPropertyInitializationAnalyzerKt.getEvaluatedInPlace(it) ? firDeclaration2 : null;
                    if (firDeclaration != null) break block8;
                }
                firDeclaration = scope2;
            }
            FirDeclaration newScope = firDeclaration;
            this.runCheck($this$processSubGraphs, subGraph, properties2, context, reporter, newScope, isForInitialization, doNotReportUninitializedVariable || doNotReportForSubGraph, doNotReportConstantUninitialized && !isSubGraphConstProperty, scopes);
        }
    }

    protected abstract void reportCapturedInitialization(@NotNull VariableInitializationInfoData var1, @NotNull VariableAssignmentNode var2, @NotNull FirVariableSymbol<?> var3, @NotNull DiagnosticReporter var4, @NotNull CheckerContext var5);

    protected abstract void reportUninitializedVariable(@NotNull DiagnosticReporter var1, @NotNull QualifiedAccessNode var2, @NotNull FirVariableSymbol<?> var3, @NotNull CheckerContext var4);

    protected abstract void reportNonInlineMemberValInitialization(@NotNull VariableAssignmentNode var1, @NotNull FirVariableSymbol<?> var2, @NotNull DiagnosticReporter var3, @NotNull CheckerContext var4);

    protected abstract void reportValReassignment(@NotNull VariableAssignmentNode var1, @NotNull FirVariableSymbol<?> var2, @NotNull DiagnosticReporter var3, @NotNull CheckerContext var4);

    @NotNull
    protected abstract Set<FirVariableSymbol<?>> filterProperties(@NotNull VariableInitializationInfoData var1, boolean var2);

    protected abstract boolean hasMatchingReceiver(@NotNull FirQualifiedAccessExpression var1, @NotNull VariableInitializationInfoData var2);

    private static final void processUnionNode$reportErrorsOnInitializationsInInputs(CFGNode<?> $this$processUnionNode_u24reportErrorsOnInitializationsInInputs, VariableInitializationInfoData $this_processUnionNode, VariableInitializationCheckProcessor this$0, DiagnosticReporter $reporter, CheckerContext $context, FirVariableSymbol<?> symbol, EdgeLabel path, PersistentSet<? extends CFGNode<?>> visited2) {
        PersistentSet<CFGNode<?>> newVisited = visited2.add($this$processUnionNode_u24reportErrorsOnInitializationsInInputs);
        if (!(newVisited != visited2)) {
            boolean $i$a$-require-VariableInitializationCheckProcessor$processUnionNode$reportErrorsOnInitializationsInInputs$22 = false;
            String $i$a$-require-VariableInitializationCheckProcessor$processUnionNode$reportErrorsOnInitializationsInInputs$22 = VariableInitializationCheckProcessorKt.buildRecursionErrorMessage($this$processUnionNode_u24reportErrorsOnInitializationsInInputs, symbol, $context);
            throw new IllegalArgumentException($i$a$-require-VariableInitializationCheckProcessor$processUnionNode$reportErrorsOnInitializationsInInputs$22.toString());
        }
        for (CFGNode<?> previousNode : CfgTraverserKt.getPreviousCfgNodes($this$processUnionNode_u24reportErrorsOnInitializationsInInputs)) {
            Object object;
            CFGNode assignmentNode;
            if ($this$processUnionNode_u24reportErrorsOnInitializationsInInputs.edgeFrom(previousNode).getKind().isBack() || (assignmentNode = (object = (PersistentMap)$this_processUnionNode.getValue(previousNode).get(path)) != null && (object = (MarkedEventOccurrencesRange)object.get(symbol)) != null ? (CFGNode)((MarkedEventOccurrencesRange)object).getLocation() : null) instanceof VariableDeclarationNode) continue;
            if (assignmentNode instanceof VariableAssignmentNode) {
                this$0.reportCapturedInitialization($this_processUnionNode, (VariableAssignmentNode)assignmentNode, symbol, $reporter, $context);
                continue;
            }
            CFGNode cFGNode = assignmentNode;
            if (cFGNode == null) continue;
            VariableInitializationCheckProcessor.processUnionNode$reportErrorsOnInitializationsInInputs(cFGNode, $this_processUnionNode, this$0, $reporter, $context, symbol, path, newVisited);
        }
    }
}

